/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.confspace.MultiStateConfSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.tools.BigExp;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MapDBTools;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Streams;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class SeqDB
implements AutoCloseable {
    public final MultiStateConfSpace confSpace;
    public final MathContext mathContext;
    public final File file;
    private final DB db;
    private final HTreeMap<int[], SeqInfo> sequencedSums;
    private final HTreeMap<Integer, MathTools.BigDecimalBounds> unsequencedSums;

    private static boolean isEmptySum(MathTools.BigDecimalBounds z) {
        return MathTools.isZero(z.lower) && MathTools.isZero(z.upper);
    }

    private static MathTools.BigDecimalBounds makeEmptySum() {
        return new MathTools.BigDecimalBounds(BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public SeqDB(MultiStateConfSpace confSpace, MathContext mathContext) {
        this(confSpace, mathContext, null);
    }

    public SeqDB(MultiStateConfSpace confSpace, MathContext mathContext, File file) {
        this.confSpace = confSpace;
        this.mathContext = mathContext;
        this.file = file;
        this.db = file != null ? DBMaker.fileDB((File)file).fileMmapEnableIfSupported().closeOnJvmShutdown().make() : DBMaker.memoryDB().make();
        this.sequencedSums = this.db.hashMap("sequenced-sums").keySerializer((Serializer)new MapDBTools.IntArraySerializer(confSpace.seqSpace.positions.stream().flatMap(pos -> pos.resTypes.stream()).mapToInt(resType -> resType.index).max().orElse(-1), confSpace.seqSpace.positions.size())).valueSerializer((Serializer)new SeqInfoSerializer(confSpace.sequencedStates.size())).createOrOpen();
        this.unsequencedSums = this.db.hashMap("unsequenced-sums").keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)new MapDBTools.BigDecimalBoundsSerializer()).createOrOpen();
    }

    public BigMath bigMath() {
        return new BigMath(this.mathContext);
    }

    public Transaction transaction() {
        return new Transaction();
    }

    @Override
    public void close() {
        this.db.close();
    }

    public MathTools.BigDecimalBounds getUnsequencedSum(MultiStateConfSpace.State state) {
        MathTools.BigDecimalBounds z = (MathTools.BigDecimalBounds)this.unsequencedSums.get((Object)state.unsequencedIndex);
        if (z == null) {
            z = SeqDB.makeEmptySum();
        }
        return z;
    }

    public MathTools.BigDecimalBounds getUnsequencedZSumBounds(MultiStateConfSpace.State state) {
        MathTools.BigDecimalBounds z = (MathTools.BigDecimalBounds)this.unsequencedSums.get((Object)state.unsequencedIndex);
        if (z == null) {
            z = new MathTools.BigDecimalBounds(BigDecimal.ZERO, MathTools.BigPositiveInfinity);
        }
        return z;
    }

    public SeqInfo getSequencedSums(Sequence seq) {
        SeqInfo seqInfo = (SeqInfo)this.sequencedSums.get((Object)seq.rtIndices);
        if (seqInfo == null) {
            seqInfo = new SeqInfo(this.confSpace.sequencedStates.size());
            seqInfo.setEmpty();
        }
        return seqInfo;
    }

    public Iterable<Map.Entry<Sequence, SeqInfo>> getSequencedSums() {
        return () -> new Iterator<Map.Entry<Sequence, SeqInfo>>(){
            Iterator<Map.Entry<int[], SeqInfo>> iter;
            {
                this.iter = SeqDB.this.sequencedSums.getEntries().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<Sequence, SeqInfo> next() {
                Map.Entry<int[], SeqInfo> entry = this.iter.next();
                Sequence seq = new Sequence(SeqDB.this.confSpace.seqSpace, entry.getKey());
                SeqInfo seqInfo = entry.getValue();
                return new AbstractMap.SimpleEntry<Sequence, SeqInfo>(seq, seqInfo);
            }
        };
    }

    public SeqInfo getSequencedZSumBounds(Sequence seq) {
        SeqInfo seqInfo = this.getSequencedSums(seq);
        if (seq.isFullyAssigned()) {
            this.addZAncestry(seq, seqInfo);
        }
        return seqInfo;
    }

    public Iterable<Map.Entry<Sequence, SeqInfo>> getSequencedZSumBounds() {
        return () -> new Iterator<Map.Entry<Sequence, SeqInfo>>(){
            Iterator<Map.Entry<int[], SeqInfo>> iter;
            {
                this.iter = SeqDB.this.sequencedSums.getEntries().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<Sequence, SeqInfo> next() {
                Map.Entry<int[], SeqInfo> entry = this.iter.next();
                Sequence seq = new Sequence(SeqDB.this.confSpace.seqSpace, entry.getKey());
                SeqInfo seqInfo = entry.getValue();
                if (seq.isFullyAssigned()) {
                    SeqDB.this.addZAncestry(seq, seqInfo);
                }
                return new AbstractMap.SimpleEntry<Sequence, SeqInfo>(seq, seqInfo);
            }
        };
    }

    private void addZAncestry(Sequence seq, SeqInfo seqInfo) {
        int[] rtIndices = new int[this.confSpace.seqSpace.positions.size()];
        System.arraycopy(seq.rtIndices, 0, rtIndices, 0, rtIndices.length);
        for (int i = rtIndices.length - 1; i >= 0; --i) {
            rtIndices[i] = -1;
            SeqInfo parentSeqInfo = (SeqInfo)this.sequencedSums.get((Object)rtIndices);
            if (parentSeqInfo == null) continue;
            for (MultiStateConfSpace.State state : this.confSpace.sequencedStates) {
                seqInfo.zSumBounds[state.sequencedIndex].upper = this.bigMath().set(seqInfo.zSumBounds[state.sequencedIndex].upper).add(parentSeqInfo.zSumBounds[state.sequencedIndex].upper).get();
            }
        }
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        buf.append("Unsequenced");
        for (MultiStateConfSpace.State state : this.confSpace.unsequencedStates) {
            MathTools.BigDecimalBounds zSumBounds = this.getUnsequencedZSumBounds(state);
            buf.append(String.format("\n%10s  zSumBounds=%s w=%s", state.name, Log.formatBigLn(zSumBounds), Log.formatBigLn(zSumBounds.size(this.mathContext))));
        }
        buf.append("\nSequenced");
        for (Map.Entry entry : this.getSequencedZSumBounds()) {
            Sequence seq = (Sequence)entry.getKey();
            SeqInfo seqInfo = (SeqInfo)entry.getValue();
            buf.append(String.format("\n[%s]", seq));
            for (MultiStateConfSpace.State state : this.confSpace.sequencedStates) {
                buf.append(String.format("\n%10s  zSumBounds=%s w=%s", state.name, Log.formatBigLn(seqInfo.get(state)), Log.formatBigLn(seqInfo.get(state).size(this.mathContext))));
            }
        }
        return buf.toString();
    }

    private static class SeqInfoSerializer
    extends MapDBTools.SimpleSerializer<SeqInfo> {
        private final int numBounds;
        private final MapDBTools.BigDecimalBoundsSerializer s = new MapDBTools.BigDecimalBoundsSerializer();

        public SeqInfoSerializer(int numBounds) {
            this.numBounds = numBounds;
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull SeqInfo data) throws IOException {
            for (int i = 0; i < this.numBounds; ++i) {
                this.s.serialize(out, data.zSumBounds[i]);
            }
        }

        public SeqInfo deserialize(@NotNull DataInput2 in, int available) throws IOException {
            SeqInfo data = new SeqInfo(this.numBounds);
            for (int i = 0; i < this.numBounds; ++i) {
                data.zSumBounds[i] = this.s.deserialize(in, available);
            }
            return data;
        }

        public int compare(SeqInfo a, SeqInfo b) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(SeqInfo a, SeqInfo b) {
            return a.equals(b);
        }

        public int hashCode(@NotNull SeqInfo data, int seed) {
            return DataIO.intHash((int)(data.hashCode() + seed));
        }
    }

    public class Transaction {
        private final Map<Sequence, SeqInfo> sequencedSums = new HashMap<Sequence, SeqInfo>();
        private final Map<Integer, MathTools.BigDecimalBounds> unsequencedSums = new HashMap<Integer, MathTools.BigDecimalBounds>();
        private boolean isEmpty = true;

        private Transaction() {
        }

        public BigMath bigMath() {
            return SeqDB.this.bigMath();
        }

        private void updateZSumBounds(MultiStateConfSpace.State state, Sequence seq, Consumer<MathTools.BigDecimalBounds> f) {
            if (state.isSequenced) {
                SeqInfo seqInfo = this.sequencedSums.get(seq);
                if (seqInfo == null) {
                    seqInfo = new SeqInfo(SeqDB.this.confSpace.sequencedStates.size());
                    seqInfo.setEmpty();
                }
                f.accept(seqInfo.get(state));
                this.sequencedSums.put(seq, seqInfo);
            } else {
                MathTools.BigDecimalBounds sum = this.unsequencedSums.get(state.unsequencedIndex);
                if (sum == null) {
                    sum = new MathTools.BigDecimalBounds(BigDecimal.ZERO, BigDecimal.ZERO);
                }
                f.accept(sum);
                this.unsequencedSums.put(state.unsequencedIndex, sum);
            }
            this.isEmpty = false;
        }

        public void addZPath(MultiStateConfSpace.State state, Sequence seq, BigExp zPath, BigExp zSumUpper) {
            if (!zPath.isFinite() || !zSumUpper.isFinite()) {
                throw new IllegalArgumentException("Z must be finite: " + String.valueOf(zPath) + ", " + String.valueOf(zSumUpper));
            }
            this.updateZSumBounds(state, seq, sum -> {
                sum.lower = this.bigMath().set(sum.lower).add(zPath.toBigDecimal(SeqDB.this.mathContext)).get();
                sum.upper = this.bigMath().set(sum.upper).add(zPath.toBigDecimal(SeqDB.this.mathContext)).sub(zSumUpper.toBigDecimal(SeqDB.this.mathContext)).get();
            });
        }

        public void addZSumUpper(MultiStateConfSpace.State state, Sequence seq, BigExp zSumUpper) {
            if (!zSumUpper.isFinite()) {
                throw new IllegalArgumentException("Z must be finite: " + String.valueOf(zSumUpper));
            }
            this.updateZSumBounds(state, seq, sum -> {
                sum.upper = this.bigMath().set(sum.upper).add(zSumUpper.toBigDecimal(SeqDB.this.mathContext)).get();
            });
        }

        public void subZSumUpper(MultiStateConfSpace.State state, Sequence seq, BigExp zSumUpper) {
            if (!zSumUpper.isFinite()) {
                throw new IllegalArgumentException("Z must be finite: " + String.valueOf(zSumUpper));
            }
            this.updateZSumBounds(state, seq, sum -> {
                sum.upper = this.bigMath().set(sum.upper).sub(zSumUpper.toBigDecimal(SeqDB.this.mathContext)).get();
            });
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        private void combineSums(MathTools.BigDecimalBounds sum, MathTools.BigDecimalBounds oldSum) {
            sum.upper = this.bigMath().set(sum.upper).add(oldSum.upper).get();
            sum.lower = this.bigMath().set(sum.lower).add(oldSum.lower).get();
        }

        private void fixRoundoffError(MathTools.BigDecimalBounds z) {
            if (!z.isValid()) {
                z.upper = z.lower;
            }
        }

        public void commit() {
            if (this.isEmpty) {
                return;
            }
            for (Map.Entry<Sequence, SeqInfo> entry : this.sequencedSums.entrySet()) {
                Sequence seq = entry.getKey();
                SeqInfo seqInfo = entry.getValue();
                SeqInfo oldSeqInfo = (SeqInfo)SeqDB.this.sequencedSums.get((Object)seq.rtIndices);
                if (oldSeqInfo != null) {
                    for (MultiStateConfSpace.State state : SeqDB.this.confSpace.sequencedStates) {
                        MathTools.BigDecimalBounds sum = seqInfo.zSumBounds[state.sequencedIndex];
                        MathTools.BigDecimalBounds oldSum = oldSeqInfo.zSumBounds[state.sequencedIndex];
                        this.combineSums(sum, oldSum);
                        this.fixRoundoffError(sum);
                    }
                }
                SeqDB.this.sequencedSums.put((Object)seq.rtIndices, (Object)seqInfo);
            }
            for (Map.Entry<Object, Object> entry : this.unsequencedSums.entrySet()) {
                int unsequencedIndex = (Integer)entry.getKey();
                MathTools.BigDecimalBounds sum = (MathTools.BigDecimalBounds)entry.getValue();
                MathTools.BigDecimalBounds oldSum = (MathTools.BigDecimalBounds)SeqDB.this.unsequencedSums.get((Object)unsequencedIndex);
                if (oldSum != null) {
                    this.combineSums(sum, oldSum);
                    this.fixRoundoffError(sum);
                }
                SeqDB.this.unsequencedSums.put((Object)unsequencedIndex, (Object)sum);
            }
            SeqDB.this.db.commit();
            this.sequencedSums.clear();
            this.unsequencedSums.clear();
            this.isEmpty = true;
        }
    }

    public static class SeqInfo {
        public final MathTools.BigDecimalBounds[] zSumBounds;

        public SeqInfo(int size) {
            this.zSumBounds = new MathTools.BigDecimalBounds[size];
        }

        public void setEmpty() {
            for (int i = 0; i < this.zSumBounds.length; ++i) {
                this.zSumBounds[i] = SeqDB.makeEmptySum();
            }
        }

        public boolean isEmpty() {
            for (MathTools.BigDecimalBounds b : this.zSumBounds) {
                if (SeqDB.isEmptySum(b)) continue;
                return false;
            }
            return true;
        }

        public MathTools.BigDecimalBounds get(MultiStateConfSpace.State state) {
            return this.zSumBounds[state.sequencedIndex];
        }

        public int hashCode() {
            return HashCalculator.combineObjHashes(this.zSumBounds);
        }

        public boolean equals(Object other) {
            return other instanceof SeqInfo && this.equals((SeqInfo)other);
        }

        public boolean equals(SeqInfo other) {
            return Arrays.equals(this.zSumBounds, other.zSumBounds);
        }

        public String toString() {
            return Streams.joinToString(this.zSumBounds, ", ", b -> Log.formatBigLn(b));
        }
    }
}

