/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.confspace.MultiStateConfSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.sofea.FringeDB;
import edu.duke.cs.osprey.sofea.SeqDB;
import edu.duke.cs.osprey.sofea.Sofea;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.MathContext;
import java.util.HashSet;
import java.util.Set;

public class SequenceLMFE
implements Sofea.Criterion {
    public final Sequence seq;
    public final MultiStateConfSpace.LMFE lmfe;
    public final double minFreeEnergyWidth;
    private final Set<Integer> finishedStates = new HashSet<Integer>();

    public SequenceLMFE(Sequence seq, MultiStateConfSpace.LMFE lmfe, double minFreeEnergyWidth) {
        this.seq = seq;
        this.lmfe = lmfe;
        this.minFreeEnergyWidth = minFreeEnergyWidth;
    }

    @Override
    public Sofea.Criterion.Filter filterNode(MultiStateConfSpace.State state, int[] conf, BoltzmannCalculator bcalc) {
        if (!this.lmfe.states().contains(state) || this.finishedStates.contains(state.index)) {
            return Sofea.Criterion.Filter.Requeue;
        }
        Sequence nodeSeq = state.confSpace.seqSpace().makeSequence(state.confSpace, conf);
        if (!this.seq.isSubsequenceOf(nodeSeq)) {
            return Sofea.Criterion.Filter.Requeue;
        }
        return Sofea.Criterion.Filter.Process;
    }

    @Override
    public Sofea.Criterion.Satisfied isSatisfied(SeqDB seqdb, FringeDB fringedbLower, FringeDB fringedbUpper, long pass1Step, long pass2Step, BoltzmannCalculator bcalc) {
        SeqDB.SeqInfo seqInfo = seqdb.getSequencedZSumBounds(this.seq);
        MathTools.DoubleBounds[] stateFreeEnergies = this.lmfe.collectFreeEnergies(state -> {
            MathTools.BigDecimalBounds zSumBounds = state.isSequenced ? seqInfo.zSumBounds[state.sequencedIndex] : seqdb.getUnsequencedZSumBounds((MultiStateConfSpace.State)state);
            return bcalc.freeEnergyPrecise(zSumBounds);
        });
        boolean isFinished = true;
        for (MultiStateConfSpace.State state2 : this.lmfe.states()) {
            if (stateFreeEnergies[state2.index].size() <= this.minFreeEnergyWidth) {
                this.finishedStates.add(state2.index);
                continue;
            }
            isFinished = false;
        }
        MathTools.DoubleBounds lmfeBounds = this.lmfe.calc().addAll((MathTools.DoubleBounds[])stateFreeEnergies).bounds;
        Log.log("sequence [%s]:", this.seq);
        Log.log("%10s=%s w=%9.4f", "LMFE", lmfeBounds.toString(4, 9), lmfeBounds.size());
        for (MultiStateConfSpace.State state3 : this.lmfe.states()) {
            MathTools.DoubleBounds g = stateFreeEnergies[state3.index];
            Log.log("%10s=%s w=%9.4f  <  %9.4f   ? %s", state3.name, g.toString(4, 9), g.size(), this.minFreeEnergyWidth, g.size() <= this.minFreeEnergyWidth ? "yes, finished" : "no, keep refining");
        }
        return isFinished ? Sofea.Criterion.Satisfied.Terminate : Sofea.Criterion.Satisfied.KeepSweeping;
    }

    public MathTools.BigDecimalBounds getZBounds(SeqDB seqdb, MultiStateConfSpace.State state) {
        if (state.isSequenced) {
            return seqdb.getSequencedZSumBounds((Sequence)this.seq).zSumBounds[state.sequencedIndex];
        }
        return seqdb.getUnsequencedZSumBounds(state);
    }

    public MathTools.DoubleBounds getGBounds(SeqDB seqdb, MultiStateConfSpace.State state, MathContext mathContext) {
        return new BoltzmannCalculator(mathContext).freeEnergyPrecise(this.getZBounds(seqdb, state));
    }

    public MathTools.DoubleBounds getGBounds(SeqDB seqdb, MultiStateConfSpace.State state) {
        return this.getGBounds(seqdb, state, seqdb.mathContext);
    }
}

