/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.control.Main;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;

public class PDBIO {
    public static Molecule readFile(String path2) {
        return PDBIO.read(FileTools.readFile(path2));
    }

    public static Molecule readFile(File file) {
        return PDBIO.read(FileTools.readFile(file));
    }

    public static Molecule readResource(String path2) {
        return PDBIO.read(FileTools.readResource(path2));
    }

    public static Molecule read(String pdbText) {
        return PDBIO.readAll(pdbText).get(0);
    }

    public static List<Molecule> readAll(String pdbText) {
        List<Molecule> mols = PDBIO.readMols(pdbText);
        PDBIO.readSecondaryStructure(mols, pdbText);
        return mols;
    }

    public static List<Molecule> readMols(String pdbText) {
        return PDBIO.readMols(FileTools.parseLines(pdbText));
    }

    public static List<Molecule> readMols(File file) {
        List<Molecule> list;
        FileReader reader = new FileReader(file);
        try {
            list = PDBIO.readMols(FileTools.parseLinesFast(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        reader.close();
        return list;
    }

    private static List<Molecule> readMols(Iterable<String> pdbIter) {
        ArrayList<Molecule> mols = new ArrayList<Molecule>();
        Molecule mol = new Molecule();
        mols.add(mol);
        ResInfo resInfo = new ResInfo();
        for (String line : pdbIter) {
            if (PDBIO.isLine(line = PDBIO.padLine(line), "MODEL")) {
                if (mol.residues.isEmpty()) continue;
                resInfo.flush(mol);
                mol = new Molecule();
                mols.add(mol);
                continue;
            }
            if (!PDBIO.isLine(line, "ATOM") && !PDBIO.isLine(line, "HETATM")) continue;
            int atomNum = Integer.parseInt(line.substring(6, 11).trim());
            String atomName = line.substring(12, 16).trim();
            char alt = line.charAt(16);
            String resName = PDBIO.trimRight(line.substring(17, 27));
            double x = Double.parseDouble(line.substring(30, 38).trim());
            double y = Double.parseDouble(line.substring(38, 46).trim());
            double z = Double.parseDouble(line.substring(46, 54).trim());
            double bFactor = Double.parseDouble(PDBIO.defaultVal("0", line.substring(60, 66).trim()));
            String elem = WordUtils.capitalize((String)line.substring(76, 78).trim().toLowerCase());
            if (!resName.equals(resInfo.name)) {
                resInfo.flush(mol);
                resInfo.name = resName;
            }
            Atom atom = elem.isEmpty() ? new Atom(atomName) : new Atom(atomName, elem);
            if (atom.elementType.equalsIgnoreCase("du")) {
                System.out.println(String.format("WARNING: Can't detect atom element: residue=%s, name=%s, element=%s\n\nPlease include element types in the PDB file to avoid this problem.", resInfo.name, atomName, elem));
            }
            atom.BFactor = bFactor;
            atom.modelAtomNumber = atomNum;
            resInfo.addAtom(atom, x, y, z, alt);
        }
        resInfo.flush(mol);
        return mols;
    }

    private static String padLine(String line) {
        int Len = 80;
        if (line.length() >= 80) {
            return line;
        }
        StringBuilder buf = new StringBuilder(80);
        buf.append(line);
        while (buf.length() < 80) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private static boolean isLine(String line, String type) {
        return line.regionMatches(true, 0, type, 0, type.length());
    }

    private static String defaultVal(String defaultVal, String inVal) {
        if (inVal == null || inVal.isEmpty()) {
            return defaultVal;
        }
        return inVal;
    }

    private static void readSecondaryStructure(List<Molecule> mols, String pdbText) {
        for (String line : FileTools.parseLines(pdbText)) {
            String stopResNum;
            String startResNum;
            char chain;
            if (PDBIO.isLine(line = PDBIO.padLine(line), "HELIX")) {
                chain = line.charAt(19);
                startResNum = chain + line.substring(21, 25).trim();
                stopResNum = chain + line.substring(33, 37).trim();
                for (Molecule mol : mols) {
                    for (Residue res : mol.getResRangeByPDBResNumber(startResNum, stopResNum)) {
                        if (res.getChainId() != chain) continue;
                        res.secondaryStruct = Residue.SecondaryStructure.HELIX;
                    }
                }
                continue;
            }
            if (!PDBIO.isLine(line, "SHEET")) continue;
            chain = line.charAt(21);
            startResNum = chain + line.substring(22, 26).trim();
            stopResNum = chain + line.substring(33, 37).trim();
            for (Molecule mol : mols) {
                for (Residue res : mol.getResRangeByPDBResNumber(startResNum, stopResNum)) {
                    if (res.getChainId() != chain) continue;
                    res.secondaryStruct = Residue.SecondaryStructure.SHEET;
                }
            }
        }
    }

    public static void writeFile(EnergyCalculator.EnergiedParametricMolecule epmol, String path2) {
        PDBIO.writeFile(epmol, null, path2);
    }

    public static void writeFile(EnergyCalculator.EnergiedParametricMolecule epmol, File file) {
        PDBIO.writeFile(epmol, null, file);
    }

    public static void writeFile(EnergyCalculator.EnergiedParametricMolecule epmol, String comment, String path2) {
        FileTools.writeFile(PDBIO.write(epmol, comment), path2);
    }

    public static void writeFile(EnergyCalculator.EnergiedParametricMolecule epmol, String comment, File file) {
        FileTools.writeFile(PDBIO.write(epmol, comment), file);
    }

    public static void writeFile(Molecule mol, String path2) {
        FileTools.writeFile(PDBIO.write(mol), path2);
    }

    public static void writeFile(Molecule mol, File file) {
        FileTools.writeFile(PDBIO.write(mol), file);
    }

    public static void writeFile(Molecule mol, String comment, Double energy, String path2) {
        FileTools.writeFile(PDBIO.write(mol, comment, energy, false), path2);
    }

    public static void writeFile(Molecule mol, String comment, Double energy, File file) {
        FileTools.writeFile(PDBIO.write(mol, comment, energy, false), file);
    }

    public static String write(EnergyCalculator.EnergiedParametricMolecule epmol) {
        return PDBIO.write(epmol, null);
    }

    public static String write(EnergyCalculator.EnergiedParametricMolecule epmol, String comment) {
        return PDBIO.write(epmol.pmol.mol, comment, epmol.energy, false);
    }

    public static String write(Molecule mol) {
        return PDBIO.write(mol, null, null, false);
    }

    public static String write(Molecule mol, String comment, Double energy, boolean includeTer) {
        return PDBIO.write(mol, comment, energy, includeTer, false);
    }

    public static String write(Molecule mol, String comment, Double energy, boolean includeTer, boolean includeSSBondConect) {
        StringBuilder buf = new StringBuilder();
        buf.append("REMARK   3\n");
        buf.append("REMARK   3 Generated by OSPREY ");
        buf.append(Main.Version);
        buf.append("\n");
        buf.append("REMARK   3\n");
        if (comment != null) {
            buf.append("REMARK   3 COMMENT : ");
            buf.append(comment);
            buf.append("\n");
        }
        if (energy != null) {
            buf.append(String.format("REMARK   3 ENERGY  : %.6f\n", energy));
        }
        if (comment != null || energy != null) {
            buf.append("REMARK   3\n");
        }
        PDBIO.appendMol(buf, mol, includeTer, includeSSBondConect);
        buf.append("END\n");
        return buf.toString();
    }

    private static void appendMol(StringBuilder buf, Molecule mol, boolean includeTer, boolean includeSSBondConect) {
        char[] line = new char[80];
        int atomCounter = 1;
        IdentityHashMap<Atom, Integer> atomIndices = new IdentityHashMap<Atom, Integer>();
        for (Residue res2 : mol.residues) {
            for (Atom atom : res2.atoms) {
                Arrays.fill(line, ' ');
                PDBIO.setField(line, "ATOM", 0, 5, Justify.Left);
                PDBIO.setField(line, res2.fullName, 17, 26, Justify.Left);
                PDBIO.setField(line, "1.00", 56, 59, Justify.Left);
                PDBIO.setField(line, "0.00", 62, 65, Justify.Left);
                atomIndices.put(atom, atomCounter);
                PDBIO.setField(line, atomCounter++, 6, 10, Justify.Right);
                if (atom.name.length() >= 4 || Character.isDigit(atom.name.charAt(0))) {
                    PDBIO.setField(line, atom.name, 12, 15, Justify.Left);
                } else {
                    PDBIO.setField(line, atom.name, 13, 15, Justify.Left);
                }
                PDBIO.setField(line, atom.getCoords()[0], 3, 30, 37, Justify.Right);
                PDBIO.setField(line, atom.getCoords()[1], 3, 38, 45, Justify.Right);
                PDBIO.setField(line, atom.getCoords()[2], 3, 46, 53, Justify.Right);
                PDBIO.setField(line, atom.elementType.toUpperCase(), 76, 77, Justify.Right);
                buf.append(line);
                buf.append("\n");
            }
            if (!includeTer || res2.indexInMolecule >= mol.residues.size() - 1 || res2.isBondedTo((Residue)mol.residues.get(res2.indexInMolecule + 1))) continue;
            buf.append("TER\n");
        }
        if (includeSSBondConect) {
            class SSBond {
                final Residue resa;
                final Atom atoma;
                final Residue resb;
                final Atom atomb;

                SSBond(Residue resa, Atom atoma, Residue resb, Atom atomb) {
                    this.resa = resa;
                    this.atoma = atoma;
                    this.resb = resb;
                    this.atomb = atomb;
                }

                public int hashCode() {
                    return HashCalculator.combineHashesCommutative(HashCalculator.combineObjHashes(this.resa, this.atoma), HashCalculator.combineObjHashes(this.resb, this.atomb));
                }

                public boolean equals(Object other) {
                    return other instanceof SSBond && this.equals((SSBond)other);
                }

                public boolean equals(SSBond other) {
                    return this.resa == other.resa && this.atoma == other.atoma && this.resb == other.resb && this.atomb == other.atomb || this.resa == other.resb && this.atoma == other.atomb && this.resb == other.resa && this.atomb == other.atoma;
                }
            }
            List cysteines = mol.residues.stream().filter(res -> res.getType().equals("CYS") || res.getType().equals("CYX")).collect(Collectors.toList());
            List ssbonds = cysteines.stream().flatMap(resa -> resa.atoms.stream().filter(Atom::isSulfur).flatMap(atoma -> atoma.bonds.stream().filter(Atom::isSulfur).map(atomb -> new SSBond((Residue)resa, (Atom)atoma, atomb.res, (Atom)atomb)))).distinct().sorted(Comparator.comparing(ssbond -> ssbond.resa.fullName)).collect(Collectors.toList());
            int ssbondCounter = 0;
            for (SSBond ssbond2 : ssbonds) {
                Function<Residue, String> resname = res -> {
                    Object name = res.fullName.substring(5);
                    if (((String)name).length() == 4) {
                        name = (String)name + " ";
                    }
                    return name;
                };
                Arrays.fill(line, ' ');
                PDBIO.setField(line, "SSBOND", 0, 5, Justify.Left);
                PDBIO.setField(line, ssbondCounter++, 7, 9, Justify.Right);
                PDBIO.setField(line, ssbond2.resa.getType(), 11, 13, Justify.Left);
                PDBIO.setField(line, ssbond2.resa.getChainId(), 15);
                PDBIO.setField(line, resname.apply(ssbond2.resa), 17, 21, Justify.Right);
                PDBIO.setField(line, ssbond2.resb.getType(), 25, 27, Justify.Left);
                PDBIO.setField(line, ssbond2.resb.getChainId(), 29);
                PDBIO.setField(line, resname.apply(ssbond2.resb), 31, 35, Justify.Right);
                PDBIO.setField(line, 1555, 59, 64, Justify.Right);
                PDBIO.setField(line, 1555, 66, 71, Justify.Right);
                double dist = VectorAlgebra.distance(ssbond2.resa.coords, ssbond2.atoma.indexInRes, ssbond2.resb.coords, ssbond2.atomb.indexInRes);
                PDBIO.setField(line, dist, 2, 73, 77, Justify.Right);
                buf.append(line);
                buf.append("\n");
                Arrays.fill(line, ' ');
                PDBIO.setField(line, "CONECT", 0, 5, Justify.Left);
                PDBIO.setField(line, (Integer)atomIndices.get(ssbond2.atoma), 6, 10, Justify.Right);
                PDBIO.setField(line, (Integer)atomIndices.get(ssbond2.atomb), 11, 15, Justify.Right);
                buf.append(line);
                buf.append("\n");
                Arrays.fill(line, ' ');
                PDBIO.setField(line, "CONECT", 0, 5, Justify.Left);
                PDBIO.setField(line, (Integer)atomIndices.get(ssbond2.atomb), 6, 10, Justify.Right);
                PDBIO.setField(line, (Integer)atomIndices.get(ssbond2.atoma), 11, 15, Justify.Right);
                buf.append(line);
                buf.append("\n");
            }
        }
    }

    private static void setField(char[] line, char value2, int pos) {
        line[pos] = value2;
    }

    private static void setField(char[] line, int field, int start, int stop, Justify justify) {
        PDBIO.setField(line, Integer.toString(field), start, stop, justify);
    }

    private static void setField(char[] line, double field, int precision, int start, int stop, Justify justify) {
        PDBIO.setField(line, String.format("%." + precision + "f", field), start, stop, justify);
    }

    private static void setField(char[] line, String field, int start, int stop, Justify justify) {
        int size = stop - start + 1;
        if (field.length() > size) {
            throw new IllegalArgumentException(String.format("value (%s) is too large for for field [%d,%d]", field, start, stop));
        }
        if (field.length() != size) {
            field = justify.apply(field, size);
        }
        field.getChars(0, size, line, start);
    }

    private static String trimRight(String str) {
        int len;
        for (len = str.length(); len > 0 && str.charAt(len - 1) <= ' '; --len) {
        }
        return len < str.length() ? str.substring(0, len) : str;
    }

    public static void writeEnsemble(List<EnergyCalculator.EnergiedParametricMolecule> epmols, String filePattern) {
        if (epmols.isEmpty()) {
            return;
        }
        if (filePattern.indexOf(42) < 0) {
            throw new IllegalArgumentException("filePattern (which is '" + filePattern + "') has no wildcard character (which is *)");
        }
        new File(filePattern).getParentFile().mkdirs();
        int indexSize = 1 + (int)Math.log10(epmols.size());
        String indexFormat = "%0" + indexSize + "d";
        for (int i = 0; i < epmols.size(); ++i) {
            String filename = filePattern.replace("*", String.format(indexFormat, i + 1));
            PDBIO.writeFile(epmols.get(i), filename);
        }
    }

    public static String write(List<Molecule> mols, List<Double> energies, String comment) {
        StringBuilder buf = new StringBuilder();
        buf.append("REMARK   3\n");
        buf.append("REMARK   3 Generated by OSPREY ");
        buf.append(Main.Version);
        buf.append("\n");
        buf.append("REMARK   3\n");
        if (comment != null) {
            buf.append("REMARK   3 COMMENT : ");
            buf.append(comment);
            buf.append("\n");
        }
        for (double energy : energies) {
            buf.append(String.format("REMARK   3 ENERGY  : %.6f\n", energy));
        }
        buf.append("REMARK   3\n");
        int modelNum = 1;
        for (Molecule mol : mols) {
            buf.append(String.format("MODEL %4d\n", modelNum++));
            PDBIO.appendMol(buf, mol, false, false);
            buf.append("ENDMDL\n");
        }
        buf.append("END\n");
        return buf.toString();
    }

    public static String write(List<EnergyCalculator.EnergiedParametricMolecule> epmols, String comment) {
        return PDBIO.write(epmols.stream().map(epmol -> epmol.pmol.mol).collect(Collectors.toList()), epmols.stream().map(epmol -> epmol.energy).collect(Collectors.toList()), comment);
    }

    public static void writeFile(List<EnergyCalculator.EnergiedParametricMolecule> epmols, String path2, String comment) {
        PDBIO.writeFile(epmols, new File(path2), comment);
    }

    public static void writeFile(List<EnergyCalculator.EnergiedParametricMolecule> epmols, File file, String comment) {
        FileTools.writeFile(PDBIO.write(epmols, comment), file);
    }

    public static String writeEcoords(List<ConfEnergyCalculator.EnergiedCoords> ecoords, String comment) {
        return PDBIO.write(ecoords.stream().map(ecoord -> ecoord.coords.toMol()).collect(Collectors.toList()), ecoords.stream().map(ecoord -> ecoord.energy).collect(Collectors.toList()), comment);
    }

    public static void writeFileEcoords(List<ConfEnergyCalculator.EnergiedCoords> ecoords, String path2, String comment) {
        PDBIO.writeFileEcoords(ecoords, new File(path2), comment);
    }

    public static void writeFileEcoords(List<ConfEnergyCalculator.EnergiedCoords> ecoords, File file, String comment) {
        FileTools.writeFile(PDBIO.writeEcoords(ecoords, comment), file);
    }

    private static class ResInfo {
        public String name = null;
        private ArrayList<Atom> atoms = new ArrayList();
        private ArrayList<double[]> coords = new ArrayList();
        private ArrayList<Character> alts = new ArrayList();

        private ResInfo() {
        }

        public void clear() {
            this.name = null;
            this.atoms.clear();
            this.coords.clear();
            this.alts.clear();
        }

        public void addAtom(Atom atom, double x, double y, double z, char alt) {
            this.atoms.add(atom);
            this.coords.add(new double[]{x, y, z});
            this.alts.add(Character.valueOf(alt));
        }

        public void flush(Molecule mol) {
            char mainAlt;
            assert (this.atoms.size() == this.coords.size());
            assert (this.atoms.size() == this.alts.size());
            if (this.atoms.isEmpty()) {
                this.clear();
                return;
            }
            TreeSet<Character> altNames = new TreeSet<Character>(this.alts);
            altNames.remove(Character.valueOf(' '));
            if (altNames.isEmpty()) {
                mainAlt = ' ';
            } else {
                mainAlt = altNames.first().charValue();
                altNames.remove(Character.valueOf(mainAlt));
            }
            Residue mainRes = this.makeResidue(mainAlt, mol);
            mol.appendResidue(mainRes);
            for (Character alt : altNames) {
                mol.addAlternate(mainRes.indexInMolecule, this.makeResidue(alt.charValue(), mol));
            }
            this.clear();
        }

        private Residue makeResidue(char alt, Molecule mol) {
            ArrayList<Atom> resAtoms = new ArrayList<Atom>();
            ArrayList<double[]> resCoords = new ArrayList<double[]>();
            for (int i = 0; i < this.atoms.size(); ++i) {
                char atomAlt = this.alts.get(i).charValue();
                if (atomAlt != ' ' && atomAlt != alt) continue;
                resAtoms.add(this.atoms.get(i).copy());
                resCoords.add(this.coords.get(i));
            }
            return new Residue(resAtoms, resCoords, this.name, mol);
        }
    }

    private static enum Justify {
        Left{

            @Override
            public String apply(String in, int size) {
                StringBuilder buf = new StringBuilder();
                buf.append(in);
                int pad = size - in.length();
                for (int i = 0; i < pad; ++i) {
                    buf.append(' ');
                }
                return buf.toString();
            }
        }
        ,
        Right{

            @Override
            public String apply(String in, int size) {
                StringBuilder buf = new StringBuilder();
                int pad = size - in.length();
                for (int i = 0; i < pad; ++i) {
                    buf.append(' ');
                }
                buf.append(in);
                return buf.toString();
            }
        };


        public abstract String apply(String var1, int var2);
    }
}

