/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import edu.duke.cs.osprey.structure.analysis.SmallAngleVoxel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VisIt {
    public static void writeVoxels(List<SmallAngleVoxel> voxels, int d1, int d2, File file) {
        ArrayList<double[]> corners = new ArrayList<double[]>();
        for (SmallAngleVoxel voxel : voxels) {
            corners.add(new double[]{voxel.intervals[d1].min(), voxel.intervals[d2].min()});
            corners.add(new double[]{voxel.intervals[d1].min(), voxel.intervals[d2].max()});
            corners.add(new double[]{voxel.intervals[d1].max(), voxel.intervals[d2].min()});
            corners.add(new double[]{voxel.intervals[d1].max(), voxel.intervals[d2].max()});
        }
        VisIt.writeAngles2D(corners, d1, d2, file);
    }

    public static void writeAngles2D(Collection<double[]> points, int d1, int d2, File file) {
        try (FileWriter out = new FileWriter(file);){
            out.write("# vtk DataFile Version 3.0\n");
            out.write("whatever\n");
            out.write("ASCII\n");
            out.write("DATASET POLYDATA\n");
            out.write(String.format("POINTS %d float\n", points.size()));
            for (double[] p : points) {
                for (int i = 0; i < 3; ++i) {
                    if (i > 0) {
                        out.write(" ");
                    }
                    if (i < 2) {
                        double pd;
                        for (pd = p[i == 0 ? d1 : d2]; pd < 0.0; pd += 360.0) {
                        }
                        while (pd >= 360.0) {
                            pd -= 360.0;
                        }
                        assert (Double.isFinite(pd));
                        out.write(String.format("%.4f", pd));
                        continue;
                    }
                    out.write("0");
                }
                out.write("\n");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeGrid2D(double[] x, double[] y, double[][] values2, File file) {
        try (FileWriter out = new FileWriter(file);){
            int i;
            out.write("# vtk DataFile Version 3.0\n");
            out.write("whatever\n");
            out.write("ASCII\n");
            out.write("DATASET RECTILINEAR_GRID\n");
            out.write(String.format("DIMENSIONS %d %d %d\n", x.length, y.length, 1));
            out.write(String.format("X_COORDINATES %d float\n", x.length));
            for (i = 0; i < x.length; ++i) {
                if (i % 10 > 0) {
                    out.write(" ");
                } else if (i > 0) {
                    out.write("\n");
                }
                out.write(String.format("%.4f", x[i]));
            }
            out.write("\n");
            out.write(String.format("Y_COORDINATES %d float\n", y.length));
            for (i = 0; i < y.length; ++i) {
                if (i % 10 > 0) {
                    out.write(" ");
                } else if (i > 0) {
                    out.write("\n");
                }
                out.write(String.format("%.4f", y[i]));
            }
            out.write("\n");
            out.write("Z_COORDINATES 1 float\n");
            out.write("0\n");
            out.write(String.format("POINT_DATA %d\n", x.length * y.length));
            out.write("FIELD fieldDelta 1\n");
            out.write(String.format("delta 1 %d float\n", x.length * y.length));
            for (int iy = 0; iy < y.length; ++iy) {
                for (int ix = 0; ix < x.length; ++ix) {
                    if (ix % 10 > 0) {
                        out.write(" ");
                    } else if (ix > 0) {
                        out.write("\n");
                    }
                    out.write(String.format("%.4f", values2[iy][ix]));
                }
                out.write("\n");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

