/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tests;

import edu.duke.cs.osprey.bbfree.BBFreeDOF;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.deeper.RamachandranChecker;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.File;
import java.util.ArrayList;

public class CatPark {
    public static void main(String[] args) {
        ConfigFileParser cfp = ConfigFileParser.makeFromFilePaths(args[1], args[3], args[4]);
        cfp.loadData();
        SearchProblem sp = cfp.getSearchProblem();
        double bbBound = Double.NaN;
        RC rc = sp.confSpace.posFlex.get((int)0).RCs.get(0);
        ArrayList<BBFreeDOF> bbDOFs = new ArrayList<BBFreeDOF>();
        for (int dofCount = 0; dofCount < rc.DOFs.size(); ++dofCount) {
            DegreeOfFreedom dof = rc.DOFs.get(dofCount);
            if (!(dof instanceof BBFreeDOF)) continue;
            bbDOFs.add((BBFreeDOF)dof);
            bbBound = rc.DOFmax.get(dofCount);
        }
        System.out.println("bbBound: " + bbBound);
        System.out.println("Number of CATS DOFs: " + bbDOFs.size());
        PDBIO.writeFile(sp.confSpace.m, "proj_00.pdb");
        ((BBFreeDOF)bbDOFs.get(0)).apply(bbBound);
        PDBIO.writeFile(sp.confSpace.m, "proj_10.pdb");
        ((BBFreeDOF)bbDOFs.get(1)).apply(bbBound);
        PDBIO.writeFile(sp.confSpace.m, "proj_11.pdb");
        Residue midRes = sp.confSpace.m.getResByPDBResNumber("856");
        System.out.println("Going around the border of the 2-D projection of the voxel. Columns: bbdof 1, bbdof 2, (phi,psi,N x coord, CA x coord) for res 856");
        double[][] voxCorners = new double[][]{{-bbBound, -bbBound}, {-bbBound, bbBound}, {bbBound, bbBound}, {bbBound, -bbBound}};
        for (int edge = 0; edge < 4; ++edge) {
            for (double step = 0.0; step < 1.0; step += 0.01) {
                for (int d = 0; d < 2; ++d) {
                    double val = (1.0 - step) * voxCorners[edge][d] + step * voxCorners[(edge + 1) % 4][d];
                    System.out.print(val + " ");
                    ((BBFreeDOF)bbDOFs.get(d)).apply(val);
                }
                double[] phiPsi = RamachandranChecker.getPhiPsi(midRes);
                double xn = midRes.getCoordsByAtomName("N")[0];
                double can = midRes.getCoordsByAtomName("CA")[0];
                System.out.println(phiPsi[0] + " " + phiPsi[1] + " " + xn + " " + can);
            }
        }
        for (BBFreeDOF bbDOF : bbDOFs) {
            bbDOF.apply(bbBound);
        }
        PDBIO.writeFile(sp.confSpace.m, "corner+.pdb");
        for (BBFreeDOF bbDOF : bbDOFs) {
            bbDOF.apply(-bbBound);
        }
        PDBIO.writeFile(sp.confSpace.m, "corner-.pdb");
    }

    public static double[] segmentRMSD(String struct1, String struct2) {
        Molecule m1 = new Strand.Builder((Molecule)PDBIO.readFile((String)struct1)).setTemplateLibrary((ResidueTemplateLibrary)EnvironmentVars.resTemplates).build().mol;
        Molecule m2 = new Strand.Builder((Molecule)PDBIO.readFile((String)struct2)).setTemplateLibrary((ResidueTemplateLibrary)EnvironmentVars.resTemplates).build().mol;
        int numRes = m1.residues.size();
        if (numRes != m2.residues.size()) {
            throw new RuntimeException("ERROR: Molecules have different numbers of residues!");
        }
        double msd = 0.0;
        double maxResMSD = 0.0;
        int atCount = 0;
        for (int resNum = 0; resNum < numRes; ++resNum) {
            Residue res1 = (Residue)m1.residues.get(resNum);
            Residue res2 = (Residue)m2.residues.get(resNum);
            double resMSD = 0.0;
            int resAtCount = 0;
            for (String name : HardCodedResidueInfo.possibleBBAtoms) {
                double[] atCoords1 = res1.getCoordsByAtomName(name);
                if (atCoords1 == null) continue;
                double[] atCoords2 = res2.getCoordsByAtomName(name);
                if (atCoords2 == null) {
                    throw new RuntimeException("ERROR: Molecules have different backbone atoms");
                }
                double dist = VectorAlgebra.distance(atCoords1, atCoords2);
                resMSD += dist * dist;
                ++resAtCount;
            }
            if (!(resMSD / (double)resAtCount > 1.0E-6)) continue;
            msd += resMSD;
            atCount += resAtCount;
            maxResMSD = Math.max(resMSD /= (double)resAtCount, maxResMSD);
        }
        return new double[]{Math.sqrt(msd /= (double)atCount), Math.sqrt(maxResMSD)};
    }

    static void calcRMSDs(String[] args) {
        String[] systems;
        EnvironmentVars.assignTemplatesToStruct = false;
        for (String sysName : systems = new String[]{"1AHO_N", "1C75_N", "1CC8_L", "1F94_M", "1FK5_N", "1I27_N", "1IQZ_M", "1l6w_N", "1l7a_N", "1l7l_L", "1l7m_N", "1l8n_L", "1l8r_L", "1l9l_N", "1l9x_M", "1lb3_N", "1M1Q_L", "1MJ4_M", "2CS7_L2", "2O9S_L2", "2P5K_L2", "2QSK_L2", "2R2Z_L2", "2RH2_M2", "2RIL_M2", "2WJ5_M2", "2ZXY_M2", "3A38_M2"}) {
            String fileName1 = CatPark.makeSysFileName(args[0], sysName);
            File file1 = new File(fileName1);
            if (file1.exists()) {
                String fileName2 = CatPark.makeSysFileName(args[1], sysName);
                double[] rmsds = CatPark.segmentRMSD(fileName1, fileName2);
                System.out.println(sysName + " " + rmsds[0] + " " + rmsds[1]);
                continue;
            }
            System.out.println(sysName);
        }
    }

    private static String makeSysFileName(String folder, String sysName) {
        if (sysName.endsWith("2")) {
            return folder + "/" + sysName + "/" + sysName + ".GMEC.pdb";
        }
        return folder + "/" + sysName + "/" + sysName.substring(0, 4) + ".GMEC.pdb";
    }
}

