/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class ExpFunction
implements Serializable {
    public static final BigDecimal exp = new BigDecimal("2.71828182845904523536");
    public static MathContext mc = new MathContext(100, RoundingMode.HALF_EVEN);
    public final int maxPrecision;
    private final MathContext mathContext;

    public ExpFunction() {
        this.mathContext = null;
        this.maxPrecision = 8;
    }

    public ExpFunction(MathContext mathContext) {
        this.mathContext = mathContext;
        this.maxPrecision = mathContext.getPrecision();
    }

    public BigDecimal exp(double x) {
        double minX = 0.0;
        BigDecimal expX = null;
        if (x < 0.0) {
            expX = new BigDecimal(Math.exp(x));
        } else {
            int integerPart = (int)Math.floor(x);
            double fractionPart = x - (double)integerPart;
            BigDecimal intPartExp = this.pow(exp, integerPart);
            BigDecimal fractPartExp = new BigDecimal(Math.exp(fractionPart));
            expX = intPartExp.multiply(fractPartExp);
        }
        expX = expX.setScale(this.maxPrecision, 4);
        return expX;
    }

    BigDecimal pow(BigDecimal num, int a) {
        return num.pow(a);
    }

    public BigDecimal log(BigDecimal num) {
        if (num.compareTo(new BigDecimal("0.0")) < 0) {
            throw new IllegalArgumentException("log of a negative number: " + String.valueOf(num));
        }
        BigDecimal sum = new BigDecimal("0.0");
        BigDecimal x = num;
        if (num.compareTo(new BigDecimal(Math.pow(10.0, 38.0))) < 0) {
            sum = num.compareTo(new BigDecimal("0.00001")) < 0 ? new BigDecimal("0.0") : new BigDecimal(Math.log(num.doubleValue()));
        } else {
            double t = 0.0;
            boolean done = false;
            while (!done) {
                if (x.compareTo(exp) > 0) {
                    t += 1.0;
                } else {
                    sum = sum.add(new BigDecimal(t + Math.log(x.doubleValue())));
                    done = true;
                }
                x = x.divide(exp, 4);
            }
        }
        return sum;
    }

    public double logToDouble(BigDecimal num) {
        double eDoub = Math.E;
        double log10ofE = Math.log10(eDoub);
        if (num.compareTo(new BigDecimal("0.0")) < 0) {
            throw new IllegalArgumentException("log of a negative number: " + String.valueOf(num));
        }
        int powerOfTen = num.round(mc).scale() * -1;
        double fract = num.movePointLeft(powerOfTen).doubleValue();
        double returnVal = ((double)powerOfTen + Math.log10(fract)) / log10ofE;
        return returnVal;
    }

    public double log10(BigDecimal num) {
        if (num.compareTo(new BigDecimal("0.0")) < 0) {
            throw new IllegalArgumentException("log of a negative number: " + String.valueOf(num));
        }
        int powerOfTen = num.round(mc).scale() * -1;
        double fract = num.movePointLeft(powerOfTen).doubleValue();
        double returnVal = (double)powerOfTen + Math.log10(fract);
        return returnVal;
    }
}

