/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.sofea.BigDecimalIO;
import edu.duke.cs.osprey.tools.BigExp;
import edu.duke.cs.osprey.tools.IntEncoding;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Streams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.GroupSerializerObjectArray;

public class MapDBTools {

    public static class BigExpSerializer
    extends SimpleSerializer<BigExp> {
        public BigExpSerializer() {
            super(12);
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull BigExp value2) throws IOException {
            out.writeDouble(value2.fp);
            out.writeInt(value2.exp);
        }

        public BigExp deserialize(@NotNull DataInput2 input, int available) throws IOException {
            return new BigExp(input.readDouble(), input.readInt());
        }

        public int compare(BigExp a, BigExp b) {
            return a.compareTo(b);
        }

        public boolean equals(BigExp a, BigExp b) {
            return a.equals(b);
        }
    }

    public static class BigDecimalBoundsSerializer
    extends SimpleSerializer<MathTools.BigDecimalBounds> {
        private final BigDecimalSerializer s = new BigDecimalSerializer();

        public void serialize(@NotNull DataOutput2 out, @NotNull MathTools.BigDecimalBounds data) throws IOException {
            this.s.serialize(out, data.lower);
            this.s.serialize(out, data.upper);
        }

        public MathTools.BigDecimalBounds deserialize(@NotNull DataInput2 in, int available) throws IOException {
            return new MathTools.BigDecimalBounds(this.s.deserialize(in, available), this.s.deserialize(in, available));
        }

        public int compare(MathTools.BigDecimalBounds a, MathTools.BigDecimalBounds b) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(MathTools.BigDecimalBounds a, MathTools.BigDecimalBounds b) {
            return a.equals(b);
        }

        public int hashCode(@NotNull MathTools.BigDecimalBounds data, int seed) {
            return DataIO.intHash((int)(data.hashCode() + seed));
        }
    }

    public static class BigDecimalSerializer
    extends SimpleSerializer<BigDecimal> {
        private final BigDecimalIO io = new BigDecimalIO.Variable();

        public void serialize(@NotNull DataOutput2 out, @NotNull BigDecimal data) throws IOException {
            this.io.write((DataOutput)out, data);
        }

        public BigDecimal deserialize(@NotNull DataInput2 in, int available) throws IOException {
            return this.io.read((DataInput)in);
        }

        public int compare(BigDecimal a, BigDecimal b) {
            return MathTools.compare(a, b);
        }

        public boolean equals(BigDecimal a, BigDecimal b) {
            return MathTools.isSameValue(a, b);
        }

        public int hashCode(@NotNull BigDecimal data, int seed) {
            return DataIO.intHash((int)(data.hashCode() + seed));
        }
    }

    public static class SequenceSerializer
    extends SimpleSerializer<Sequence> {
        public final SeqSpace seqSpace;

        public SequenceSerializer(SeqSpace seqSpace) {
            super(-1);
            this.seqSpace = seqSpace;
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull Sequence sequence) throws IOException {
            out.writeUTF(this.getSequenceId(sequence));
        }

        public Sequence deserialize(@NotNull DataInput2 in, int available) throws IOException {
            return this.makeSequenceFromId(in.readUTF());
        }

        public int compare(Sequence a, Sequence b) {
            if (a == b) {
                return 0;
            }
            for (SeqSpace.Position pos : this.seqSpace.positions) {
                SeqSpace.ResType aResType = a.get(pos);
                SeqSpace.ResType bResType = b.get(pos);
                if (aResType != null && bResType != null) {
                    int val = aResType.compareTo(bResType);
                    if (val == 0) continue;
                    return val;
                }
                if (aResType == null && bResType != null) {
                    return -1;
                }
                if (aResType == null) continue;
                return 1;
            }
            return 0;
        }

        public String getSequenceId(Sequence sequence) {
            return Streams.joinToString(sequence.seqSpace.positions, ":", pos -> sequence.get((SeqSpace.Position)pos).name);
        }

        public Sequence makeSequenceFromId(String id) {
            Sequence sequence = this.seqSpace.makeUnassignedSequence();
            String[] resTypes = id.split(":");
            for (SeqSpace.Position pos : this.seqSpace.positions) {
                sequence.set(pos.resNum, resTypes[pos.index]);
            }
            return sequence;
        }
    }

    public static class ValuesSerializer<T>
    extends SimpleSerializer<List<T>> {
        private final GroupSerializer<T> valueSerializer;

        public ValuesSerializer(GroupSerializer<T> valueSerializer) {
            this.valueSerializer = valueSerializer;
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull List<T> data) throws IOException {
            out.writeInt(data.size());
            for (T value2 : data) {
                this.valueSerializer.serialize(out, value2);
            }
        }

        public List<T> deserialize(@NotNull DataInput2 in, int available) throws IOException {
            int size = in.readInt();
            ArrayList<Object> data = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                data.add(this.valueSerializer.deserialize(in, available));
            }
            return data;
        }
    }

    public static class IntArraySerializer
    extends SimpleSerializer<int[]> {
        private final IntEncoding encoding;
        private final int numPos;

        public IntArraySerializer(int maxVal, int numPos) {
            this(IntEncoding.get(maxVal + 1), numPos);
        }

        private IntArraySerializer(IntEncoding encoding, int numPos) {
            super(encoding.numBytes * numPos);
            this.encoding = encoding;
            this.numPos = numPos;
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull int[] data) throws IOException {
            assert (data.length == this.numPos);
            for (int i = 0; i < this.numPos; ++i) {
                this.encoding.write((DataOutput)out, data[i] + 1);
            }
        }

        public int[] deserialize(@NotNull DataInput2 in, int available) throws IOException {
            int[] data = new int[this.numPos];
            for (int i = 0; i < this.numPos; ++i) {
                data[i] = this.encoding.read((DataInput)in) - 1;
            }
            return data;
        }

        public int compare(int[] a, int[] b) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(int[] a, int[] b) {
            return Arrays.equals(a, b);
        }

        public int hashCode(@NotNull int[] data, int seed) {
            return DataIO.intHash((int)(Arrays.hashCode(data) + seed));
        }
    }

    public static abstract class SimpleSerializer<T>
    extends GroupSerializerObjectArray<T> {
        public static final int DynamicSize = -1;
        public final int fixedSize;

        protected SimpleSerializer() {
            this(-1);
        }

        protected SimpleSerializer(int fixedSize) {
            this.fixedSize = fixedSize;
        }

        public boolean isTrusted() {
            return true;
        }

        public int fixedSize() {
            return this.fixedSize;
        }
    }
}

