/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.SVG;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SVGPlot {

    public static class Boxes {
        public double axisTicksOn = 10.0;
        public SVG.StyleClass boxStyle = new SVG.StyleClass("plot-boxes-box");
        public double xmin = 0.0;
        public double xmax = 0.0;
        public double ymin = 0.0;
        public double ymax = 0.0;
        public BottomAxis xaxis = null;
        public LeftAxis yaxis = null;
        private List<Box> boxes = new ArrayList<Box>();

        public Boxes() {
            this.boxStyle.setStrokeWidth(0.2);
            this.boxStyle.setStrokeColor(0x666666);
            this.boxStyle.setFillColor(0xCCCCCC);
        }

        public Box addBox(double xmin, double xmax, double ymin, double ymax) {
            Box box = new Box(xmin, xmax, ymin, ymax);
            this.boxes.add(box);
            this.xmax = Math.max(this.xmax, xmax);
            this.ymax = Math.max(this.ymax, ymax);
            return box;
        }

        public BottomAxis makeXAxis() {
            BottomAxis axis = new BottomAxis();
            axis.min = 0.0;
            axis.max = Math.ceil(this.xmax / this.axisTicksOn) * this.axisTicksOn;
            axis.addTicksOn(this.axisTicksOn);
            return axis;
        }

        public LeftAxis makeYAxis() {
            LeftAxis axis = new LeftAxis();
            axis.min = 0.0;
            axis.max = Math.ceil(this.ymax / this.axisTicksOn) * this.axisTicksOn;
            axis.addTicksOn(this.axisTicksOn);
            return axis;
        }

        public void draw(SVG svg) {
            svg.putStyleClasses(this.boxStyle);
            for (Box box : this.boxes) {
                if (Double.isInfinite(box.xmin) || Double.isInfinite(box.xmax) || Double.isInfinite(box.ymin) || Double.isInfinite(box.ymax)) {
                    System.err.println(String.format("WARNING: box [%f,%f]x[%f,%f] is infinite and will not be drawn", box.xmin, box.xmax, box.ymin, box.ymax));
                    continue;
                }
                SVG.ShapeDrawable d = box.getDX() == 0.0 && box.getDY() == 0.0 ? svg.makePoint(box.xmin, box.ymin, 0.01) : svg.makeRect(box.xmin, box.xmax, box.ymin, box.ymax);
                d.setStyleClasses(this.boxStyle, box.extraStyle).setId(box.id).draw();
            }
            if (this.xaxis == null) {
                this.xaxis = this.makeXAxis();
            }
            this.xaxis.draw(svg);
            if (this.yaxis == null) {
                this.yaxis = this.makeYAxis();
            }
            this.yaxis.draw(svg);
        }

        public void setBounds(SVG svg, double margin, double tickMargin) {
            svg.setBounds(this.xmin - margin - tickMargin, this.xmax + margin, this.ymin - margin - tickMargin, this.ymax + margin);
        }

        public static class Box {
            public double xmin;
            public double xmax;
            public double ymin;
            public double ymax;
            public String id;
            public SVG.StyleClass extraStyle;

            public Box(double xmin, double xmax, double ymin, double ymax) {
                this.xmin = xmin;
                this.xmax = xmax;
                this.ymin = ymin;
                this.ymax = ymax;
                this.id = null;
                this.extraStyle = null;
            }

            public double getDX() {
                return this.xmax - this.xmin;
            }

            public double getDY() {
                return this.ymax - this.ymin;
            }
        }
    }

    public static class Intervals {
        public double intervalWidth = 8.0;
        public double intervalSpacing = 2.0;
        public double axisTicksOn = 10.0;
        public double minRectHeight = 0.2;
        public SVG.StyleClass intervalStyle = new SVG.StyleClass("plot-intervals-bar");
        public double xmin = 0.0;
        public double xmax = 0.0;
        public double ymin = 0.0;
        public double ymax = 0.0;
        public LeftAxis axis = null;
        private List<Interval> intervals = new ArrayList<Interval>();

        public Intervals() {
            this.intervalStyle.setStrokeWidth(0.2);
            this.intervalStyle.setStrokeColor(0x666666);
            this.intervalStyle.setFillColor(0xCCCCCC);
        }

        public Interval addInterval(double min, double max) {
            Interval interval = new Interval(min, max);
            this.intervals.add(interval);
            this.xmax = (double)this.intervals.size() * (this.intervalSpacing + this.intervalWidth);
            this.ymax = Math.max(this.ymax, max);
            return interval;
        }

        public LeftAxis makeAxis() {
            LeftAxis axis = new LeftAxis();
            axis.min = 0.0;
            axis.max = Math.ceil(this.ymax / this.axisTicksOn) * this.axisTicksOn;
            axis.addTicksOn(this.axisTicksOn);
            return axis;
        }

        public void draw(SVG svg) {
            svg.putStyleClasses(this.intervalStyle);
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval interval = this.intervals.get(i);
                double x = (double)(i + 1) * this.intervalSpacing + (double)i * this.intervalWidth;
                double y1 = interval.min;
                double y2 = interval.max;
                if (Double.isInfinite(y1) || Double.isInfinite(y2)) {
                    System.err.println(String.format("WARNING: interval [%f,%f] is infinite and will not be drawn", y1, y2));
                    continue;
                }
                svg.makeRect(x, x + this.intervalWidth, y1, y2).setStyleClasses(this.intervalStyle, interval.extraStyle).setId(interval.id).draw();
            }
            if (this.axis == null) {
                this.axis = this.makeAxis();
            }
            this.axis.draw(svg);
        }

        public void setBounds(SVG svg, double margin, double tickMargin) {
            svg.setBounds(this.xmin - margin - tickMargin, this.xmax + margin, this.ymin - margin, this.ymax + margin);
        }

        public static class Interval {
            public double min;
            public double max;
            public String id;
            public SVG.StyleClass extraStyle;

            public Interval(double min, double max) {
                this.min = min;
                this.max = max;
                this.id = null;
                this.extraStyle = null;
            }
        }
    }

    public static class BottomAxis
    extends Axis {
        public int tickTextHeight = 5;

        public BottomAxis() {
            this.tickTextStyle.setTextAnchor(SVG.StyleClass.TextAnchor.Middle);
        }

        public void draw(SVG svg) {
            super.preDraw(svg);
            svg.makeLine(this.x + this.min, this.y, this.x + this.max, this.y).setStyleClasses(this.lineStyle).draw();
            this.drawTick(svg, this.min);
            Iterator iterator2 = this.ticks.iterator();
            while (iterator2.hasNext()) {
                double x = (Double)iterator2.next();
                this.drawTick(svg, x);
            }
            this.drawTick(svg, this.max);
        }

        private void drawTick(SVG svg, double x) {
            svg.makeLine(x, this.y, x, this.y - this.tickLength).setStyleClasses(this.lineStyle).draw();
            svg.makeText(String.format(this.tickFormat, x)).setPos(x, this.y - this.tickLength - this.tickTextMargin - (double)this.tickTextHeight).setStyleClasses(this.tickTextStyle).draw();
        }
    }

    public static class LeftAxis
    extends Axis {
        public double tickTextDy = -2.0;

        public LeftAxis() {
            this.tickTextStyle.setTextAnchor(SVG.StyleClass.TextAnchor.End);
        }

        public void draw(SVG svg) {
            this.preDraw(svg);
            svg.makeLine(this.x, this.y + this.min, this.x, this.y + this.max).setStyleClasses(this.lineStyle).draw();
            this.drawTick(svg, this.min);
            Iterator iterator2 = this.ticks.iterator();
            while (iterator2.hasNext()) {
                double y = (Double)iterator2.next();
                this.drawTick(svg, y);
            }
            this.drawTick(svg, this.max);
        }

        private void drawTick(SVG svg, double y) {
            svg.makeLine(this.x, y, this.x - this.tickLength, y).setStyleClasses(this.lineStyle).draw();
            svg.makeText(String.format(this.tickFormat, y)).setPos(this.x - this.tickLength - this.tickTextMargin, y).setDY(this.tickTextDy, SVG.LengthUnit.px).setStyleClasses(this.tickTextStyle).draw();
        }
    }

    public static abstract class Axis {
        public double x = 0.0;
        public double y = 0.0;
        public double min = 0.0;
        public double max = 100.0;
        public List<Double> ticks = new ArrayList<Double>();
        public double tickLength = 4.0;
        public String tickFormat = "%.1f";
        public double tickTextMargin = 2.0;
        public SVG.StyleClass lineStyle = new SVG.StyleClass("plot-axis-line");
        public SVG.StyleClass tickTextStyle = new SVG.StyleClass("plot-axis-text");

        public Axis() {
            this.lineStyle.setStrokeColor(0);
            this.lineStyle.setStrokeWidth(0.5);
            this.tickTextStyle.setFillColor(0);
            this.tickTextStyle.setFontSize(5.0, SVG.LengthUnit.px);
            this.tickTextStyle.setNoStroke();
        }

        public void addTicksOn(double multiple) {
            for (double val = Math.floor(this.min / multiple) * multiple + multiple; val < this.max; val += multiple) {
                this.ticks.add(val);
            }
        }

        protected void preDraw(SVG svg) {
            svg.putStyleClasses(this.lineStyle, this.tickTextStyle);
        }
    }
}

