/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools.resultdoc;

import edu.duke.cs.osprey.tools.Streams;
import edu.duke.cs.osprey.tools.resultdoc.Plot;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;

public class ResultDoc
implements AutoCloseable {
    private final OutputStream out;
    private final Writer writer;
    public final Image image = new Image();
    public final File file = new File();
    private final String tableSeparator = " | ";
    public PlotType defaultPlotType = PlotType.PNG;

    public ResultDoc(OutputStream out) {
        this.out = out;
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ResultDoc() {
        this(System.out);
    }

    private static OutputStream pathToStream(Path path2) {
        try {
            return Files.newOutputStream(path2, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("can't open Path: " + String.valueOf(path2), ex);
        }
    }

    public ResultDoc(Path path2) {
        this(ResultDoc.pathToStream(path2));
    }

    public ResultDoc(java.io.File file) {
        this(file.toPath());
    }

    public ResultDoc(String path2) {
        this(Paths.get(path2, new String[0]));
    }

    public void print(String text) {
        try {
            this.writer.write(text);
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("can't write to ResultDoc", ex);
        }
    }

    public void println() {
        this.print("\n");
    }

    public void println(String text) {
        this.print(text);
        this.println();
    }

    public void h1(String text) {
        this.print("# ");
        this.println(text);
    }

    public void h2(String text) {
        this.print("## ");
        this.println(text);
    }

    public void h3(String text) {
        this.print("### ");
        this.println(text);
    }

    public void h4(String text) {
        this.print("#### ");
        this.println(text);
    }

    public void h5(String text) {
        this.print("##### ");
        this.println(text);
    }

    public void h6(String text) {
        this.print("###### ");
        this.println(text);
    }

    public void ul(String text) {
        this.print(" * ");
        this.println(text);
    }

    public void ol(String text) {
        this.print(" 1. ");
        this.println(text);
    }

    private static String urlEncodeBinary(byte[] data) {
        return Base64.getEncoder().encodeToString(data).replace("\n", "");
    }

    private static String urlEncodeText(String data) {
        return data.replace("%", "%25").replace("\n", "%0A").replace("\t", "%09").replace(" ", "%20").replace("\"", "%22").replace("(", "%28").replace(")", "%29").replace("#", "%23").replace("|", "%7C").replace("[", "%5B").replace("]", "%5D");
    }

    private static String escapeText(String text) {
        return text.replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]");
    }

    public void tableHeader(String ... text) {
        this.println(Streams.joinToString(text, " | "));
        this.println(Streams.joinToString(text, " | ", t -> "---"));
    }

    public void tableRow(String ... text) {
        this.println(Streams.joinToString(text, " | "));
    }

    public void hr() {
        this.println("---");
    }

    public void plot(Plot plot, PlotType plotType) {
        plotType.plot(this, plot);
    }

    public void plot(Plot plot) {
        this.plot(plot, this.defaultPlotType);
    }

    public class Image {
        public void embed(byte[] data, String type) {
            ResultDoc.this.print("![](data:");
            ResultDoc.this.print(type);
            ResultDoc.this.print(";base64,");
            ResultDoc.this.print(ResultDoc.urlEncodeBinary(data));
            ResultDoc.this.println(")");
        }

        public void embed(String data, String type) {
            ResultDoc.this.print("![](data:");
            ResultDoc.this.print(type);
            ResultDoc.this.print(";utf8,");
            ResultDoc.this.print(ResultDoc.urlEncodeText(data));
            ResultDoc.this.println(")");
        }

        public void png(byte[] data) {
            this.embed(data, "image/png");
        }

        public void svg(String data) {
            this.embed(data, "image/svg+xml");
        }
    }

    public class File {
        public void embed(byte[] data, String type, String link) {
            ResultDoc.this.print("[");
            ResultDoc.this.print(ResultDoc.escapeText(link));
            ResultDoc.this.print("](data:");
            ResultDoc.this.print(type);
            ResultDoc.this.print(";base64,");
            ResultDoc.this.print(ResultDoc.urlEncodeBinary(data));
            ResultDoc.this.println(")");
        }

        public void embed(String data, String type, String link) {
            ResultDoc.this.print("[");
            ResultDoc.this.print(ResultDoc.escapeText(link));
            ResultDoc.this.print("](data:");
            ResultDoc.this.print(type);
            ResultDoc.this.print(";utf8,");
            ResultDoc.this.print(ResultDoc.urlEncodeText(data));
            ResultDoc.this.println(")");
        }

        public void csv(String data, String link) {
            this.embed(data, "text/csv", link);
        }

        public void tsv(String data, String link) {
            this.embed(data, "text/tab-separated-values", link);
        }
    }

    public static enum PlotType {
        PNG{

            @Override
            public void plot(ResultDoc doc, Plot plot) {
                doc.image.png(plot.renderPng());
            }
        }
        ,
        SVG{

            @Override
            public void plot(ResultDoc doc, Plot plot) {
                doc.image.svg(plot.renderSvg());
            }
        };


        abstract void plot(ResultDoc var1, Plot var2);
    }
}

