/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.TupleMatrixGeneric;
import java.util.ArrayList;

public class TupleIndexMatrix
extends TupleMatrixGeneric<Integer> {
    public TupleIndexMatrix(int numPos, int[] numRCsAtPos, double pruningInterval) {
        super(numPos, numRCsAtPos, pruningInterval, -1);
    }

    public ArrayList<Integer> calcSampleTuples(int[] sample) {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        int numPos = sample.length;
        for (int pos = 0; pos < numPos; ++pos) {
            int RCNum = sample[pos];
            int oneBodyIndex = (Integer)this.getOneBody(pos, RCNum);
            if (oneBodyIndex != -1) {
                ans.add(oneBodyIndex);
            }
            for (int pos2 = 0; pos2 < pos; ++pos2) {
                HigherTupleFinder<Integer> htf;
                int rc2 = sample[pos2];
                int pairwiseIndex = (Integer)this.getPairwise(pos, RCNum, pos2, rc2);
                if (pairwiseIndex != -1) {
                    ans.add(pairwiseIndex);
                }
                if ((htf = this.getHigherOrderTerms(pos, RCNum, pos2, rc2)) == null) continue;
                this.calcHigherOrderTuples(ans, sample, pos2, htf);
            }
        }
        return ans;
    }

    void calcHigherOrderTuples(ArrayList<Integer> sampleTuples, int[] sample, int maxPos, HigherTupleFinder<Integer> htf) {
        ArrayList<Integer> interactingPos = htf.getInteractingPos();
        for (int ipos : interactingPos) {
            HigherTupleFinder<Integer> htf2;
            if (ipos >= maxPos) continue;
            int iTupIndex = htf.getInteraction(ipos, sample[ipos]);
            if (iTupIndex != -1) {
                sampleTuples.add(iTupIndex);
            }
            if ((htf2 = htf.getHigherInteractions(ipos, sample[ipos])) == null) continue;
            this.calcHigherOrderTuples(sampleTuples, sample, ipos, htf2);
        }
    }
}

