/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar;

import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.UnpossibleError;

public interface OptimizableAStarNode {
    public double getGScore();

    public void setGScore(double var1);

    public double getHScore();

    public void setHScore(double var1);

    public int getLevel();

    default public double getScore() {
        return this.getGScore() + this.getHScore();
    }

    default public double getGScore(MathTools.Optimizer optimizer) {
        return Tools.optimizeScore(this.getGScore(), optimizer);
    }

    default public void setGScore(double val, MathTools.Optimizer optimizer) {
        this.setGScore(Tools.optimizeScore(val, optimizer));
    }

    default public double getHScore(MathTools.Optimizer optimizer) {
        return Tools.optimizeScore(this.getHScore(), optimizer);
    }

    default public void setHScore(double val, MathTools.Optimizer optimizer) {
        this.setHScore(Tools.optimizeScore(val, optimizer));
    }

    default public double getScore(MathTools.Optimizer optimizer) {
        return Tools.optimizeScore(this.getScore(), optimizer);
    }

    public static class Tools {
        public static double optimizeScore(double score, MathTools.Optimizer optimizer) {
            switch (optimizer) {
                case Minimize: {
                    return score;
                }
                case Maximize: {
                    return -score;
                }
            }
            throw new UnpossibleError();
        }
    }
}

