/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.comets;

import java.io.Serializable;
import java.util.StringTokenizer;

public class LME
implements Serializable {
    double[] coeffs;
    double constTerm;

    public LME(String s, int numStates) {
        StringTokenizer st = new StringTokenizer(s);
        if (st.countTokens() != numStates + 1) {
            throw new RuntimeException("ERROR: SeqTree has " + numStates + " states but GMECLinFunc specified with " + st.countTokens() + " coefficients: " + s);
        }
        this.coeffs = new double[numStates];
        for (int state = 0; state < numStates; ++state) {
            this.coeffs[state] = Double.valueOf(st.nextToken());
        }
        this.constTerm = Double.valueOf(st.nextToken());
    }

    public double[] getCoeffs() {
        return this.coeffs;
    }

    public double getConstTerm() {
        return this.constTerm;
    }

    public double eval(double[] stateGMECVals) {
        if (stateGMECVals.length != this.coeffs.length) {
            throw new RuntimeException("ERROR: Wrong number of state GMECs");
        }
        double ans = 0.0;
        for (int c = 0; c < this.coeffs.length; ++c) {
            if (this.coeffs[c] == 0.0) continue;
            ans += this.coeffs[c] * stateGMECVals[c];
        }
        if (Double.isNaN(ans += this.constTerm)) {
            return Double.POSITIVE_INFINITY;
        }
        return ans;
    }
}

