/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf;

import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RCs {
    private PruningMatrix pruneMat = null;
    private final int[][] unprunedRCsAtPos;

    @Deprecated
    public RCs(SimpleConfSpace confSpace) {
        this(confSpace, (SimpleConfSpace.Position pos, SimpleConfSpace.ResidueConf resConf) -> true);
    }

    @Deprecated
    public RCs(SimpleConfSpace confSpace, BiPredicate<SimpleConfSpace.Position, SimpleConfSpace.ResidueConf> filter) {
        this.unprunedRCsAtPos = new int[confSpace.positions.size()][];
        for (SimpleConfSpace.Position pos : confSpace.positions) {
            this.unprunedRCsAtPos[pos.index] = pos.resConfs.stream().filter(resConf -> filter.test(pos, (SimpleConfSpace.ResidueConf)resConf)).mapToInt(resConf -> resConf.index).toArray();
        }
    }

    public RCs(ConfSpaceIteration confSpace) {
        this(confSpace, (Integer posi, Integer confi) -> true);
    }

    public RCs(ConfSpaceIteration confSpace, BiPredicate<Integer, Integer> filter) {
        this.unprunedRCsAtPos = new int[confSpace.numPos()][];
        for (int posi = 0; posi < confSpace.numPos(); ++posi) {
            int fposi = posi;
            this.unprunedRCsAtPos[posi] = IntStream.range(0, confSpace.numConf(posi)).filter(confi -> filter.test(fposi, confi)).toArray();
        }
    }

    public RCs(List<List<Integer>> rcsAtPos) {
        int n = rcsAtPos.size();
        this.unprunedRCsAtPos = new int[n][];
        for (int pos = 0; pos < n; ++pos) {
            this.unprunedRCsAtPos[pos] = rcsAtPos.get(pos).stream().mapToInt(i -> i).toArray();
        }
    }

    public RCs(int[][] rcsAtPos) {
        this.unprunedRCsAtPos = new int[rcsAtPos.length][];
        for (int posi = 0; posi < rcsAtPos.length; ++posi) {
            this.unprunedRCsAtPos[posi] = (int[])rcsAtPos[posi].clone();
        }
    }

    public RCs(PruningMatrix pruneMat) {
        this.pruneMat = pruneMat;
        int n = pruneMat.getNumPos();
        this.unprunedRCsAtPos = new int[n][];
        for (int pos = 0; pos < n; ++pos) {
            this.unprunedRCsAtPos[pos] = pruneMat.unprunedRCsAtPos(pos).stream().mapToInt(i -> i).toArray();
        }
    }

    public RCs(RCs other, PruningMatrix pmat) {
        this(other, (Integer pos, Integer rc) -> !pmat.isSinglePruned((int)pos, (int)rc));
        this.pruneMat = pmat;
    }

    public RCs(RCs other) {
        this(other, (Integer pos, Integer resConf) -> true);
    }

    public RCs(RCs other, BiPredicate<Integer, Integer> filter) {
        this.pruneMat = other.pruneMat;
        this.unprunedRCsAtPos = new int[other.unprunedRCsAtPos.length][];
        for (int i = 0; i < this.unprunedRCsAtPos.length; ++i) {
            int fi = i;
            this.unprunedRCsAtPos[i] = IntStream.of(other.unprunedRCsAtPos[i]).filter(rc -> filter.test(fi, rc)).toArray();
        }
    }

    public PruningMatrix getPruneMat() {
        return this.pruneMat;
    }

    public boolean hasConfs() {
        if (this.unprunedRCsAtPos.length <= 0) {
            return true;
        }
        for (int[] rcs : this.unprunedRCsAtPos) {
            if (rcs.length <= 0) continue;
            return true;
        }
        return false;
    }

    public int getNumPos() {
        return this.unprunedRCsAtPos.length;
    }

    public int getNumTrivialPos() {
        int count = 0;
        for (int[] rcs : this.unprunedRCsAtPos) {
            if (rcs.length != 1) continue;
            ++count;
        }
        return count;
    }

    public BigInteger getNumConformations() {
        if (!this.hasConfs()) {
            return BigInteger.ZERO;
        }
        BigInteger count = BigInteger.ONE;
        for (int[] rcs : this.unprunedRCsAtPos) {
            count = count.multiply(BigInteger.valueOf(rcs.length));
        }
        return count;
    }

    public int[] get(int pos) {
        return this.unprunedRCsAtPos[pos];
    }

    public void set(int pos, int[] rcs) {
        this.unprunedRCsAtPos[pos] = rcs;
    }

    public int getNum(int pos) {
        return this.unprunedRCsAtPos[pos].length;
    }

    public int get(int pos, int rci) {
        return this.unprunedRCsAtPos[pos][rci];
    }

    public boolean contains(int pos, int rc) {
        for (int i : this.get(pos)) {
            if (i != rc) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + String.join((CharSequence)",", Arrays.stream(this.unprunedRCsAtPos).map(rcs -> Integer.toString(((int[])rcs).length)).collect(Collectors.toList())) + "]";
    }
}

