/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.order;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class StaticScoreHMeanAStarOrder
implements AStarOrder {
    private AStarScorer gscorer;
    private AStarScorer hscorer;
    private List<Integer> posOrder = null;

    @Override
    public void setScorers(AStarScorer gscorer, AStarScorer hscorer) {
        this.gscorer = gscorer;
        this.hscorer = hscorer;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public int getNextPos(ConfIndex confIndex, RCs rcs) {
        if (this.posOrder == null) {
            this.posOrder = this.calcPosOrder(confIndex, rcs);
        }
        return this.posOrder.get(confIndex.node.getLevel());
    }

    private List<Integer> calcPosOrder(ConfIndex confIndex, RCs rcs) {
        ArrayList<Integer> undefinedOrder = new ArrayList<Integer>();
        final TreeMap<Integer, Double> scores = new TreeMap<Integer, Double>();
        for (int posi = 0; posi < confIndex.numUndefined; ++posi) {
            int pos = confIndex.undefinedPos[posi];
            undefinedOrder.add(pos);
            scores.put(pos, this.scorePos(confIndex, rcs, pos));
        }
        Collections.sort(undefinedOrder, new Comparator<Integer>(){

            @Override
            public int compare(Integer pos1, Integer pos2) {
                double score1 = (Double)scores.get(pos1);
                double score2 = (Double)scores.get(pos2);
                return Double.compare(score2, score1);
            }
        });
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int posi = 0; posi < confIndex.numDefined; ++posi) {
            int pos = confIndex.definedPos[posi];
            order.add(pos);
        }
        order.addAll(undefinedOrder);
        return order;
    }

    double scorePos(ConfIndex confIndex, RCs rcs, int pos) {
        double parentScore = confIndex.node.getScore();
        double reciprocalSum = 0.0;
        for (int rc : rcs.get(pos)) {
            double childScore = this.gscorer.calcDifferential(confIndex, rcs, pos, rc) + this.hscorer.calcDifferential(confIndex, rcs, pos, rc);
            reciprocalSum += 1.0 / (childScore - parentScore);
        }
        return 1.0 / reciprocalSum;
    }
}

