/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.scoring;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;

public class NaiveTraditionalPairwiseHScorer
implements AStarScorer {
    private EnergyMatrix emat;

    public NaiveTraditionalPairwiseHScorer(EnergyMatrix emat) {
        this.emat = emat;
    }

    @Override
    public NaiveTraditionalPairwiseHScorer make() {
        return new NaiveTraditionalPairwiseHScorer(this.emat);
    }

    @Override
    public double calc(ConfIndex index, RCs rcs) {
        double hscore = 0.0;
        for (int i = 0; i < index.numUndefined; ++i) {
            int pos1 = index.undefinedPos[i];
            double pos1Score = Double.POSITIVE_INFINITY;
            for (int rc1 : rcs.get(pos1)) {
                int pos2;
                int j;
                double rcContrib = this.emat.getOneBody(pos1, rc1);
                for (j = 0; j < index.numDefined; ++j) {
                    pos2 = index.definedPos[j];
                    int rc2 = index.definedRCs[j];
                    rcContrib += this.emat.getPairwise(pos1, rc1, pos2, rc2).doubleValue();
                }
                for (j = 0; j < index.numUndefined && (pos2 = index.undefinedPos[j]) < pos1; ++j) {
                    double minEnergy = Double.POSITIVE_INFINITY;
                    for (int rc2 : rcs.get(pos2)) {
                        double pairwiseEnergy = this.emat.getPairwise(pos1, rc1, pos2, rc2);
                        minEnergy = Math.min(minEnergy, pairwiseEnergy);
                    }
                    rcContrib += minEnergy;
                }
                pos1Score = Math.min(pos1Score, rcContrib);
            }
            hscore += pos1Score;
        }
        return hscore;
    }
}

