/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.smastar;

import edu.duke.cs.osprey.astar.conf.smastar.ConfSMAStarNode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class ConfSMAStarQueue {
    private final TreeMap<Double, Nodes> nodesByScore = new TreeMap();

    public boolean add(ConfSMAStarNode node) {
        assert (Double.isFinite(node.getScore()));
        Nodes nodes = this.getOrMakeNodes(node.getScore());
        if (nodes.nodesByDepth.containsKey(node.depth)) {
            return false;
        }
        nodes.nodesByDepth.put(node.depth, node);
        return true;
    }

    public void addOrAssert(ConfSMAStarNode node) {
        boolean wasAdded = this.add(node);
        assert (wasAdded);
    }

    private Nodes getOrMakeNodes(double score) {
        Nodes nodes = this.nodesByScore.get(score);
        if (nodes == null) {
            nodes = new Nodes(score);
            this.nodesByScore.put(score, nodes);
        }
        return nodes;
    }

    public boolean remove(ConfSMAStarNode node) {
        Nodes nodes = this.nodesByScore.get(node.getScore());
        if (nodes == null) {
            return false;
        }
        if (nodes.nodesByDepth.get(node.depth) != node) {
            return false;
        }
        ConfSMAStarNode removedNode = nodes.nodesByDepth.remove(node.depth);
        assert (removedNode == node);
        if (nodes.nodesByDepth.isEmpty()) {
            this.nodesByScore.remove(nodes.score);
        }
        return true;
    }

    public void removeOrAssert(ConfSMAStarNode node) {
        boolean wasRemoved = this.remove(node);
        assert (wasRemoved);
    }

    public boolean isEmpty() {
        return this.nodesByScore.isEmpty();
    }

    public ConfSMAStarNode getLowestDeepest() {
        if (this.isEmpty()) {
            return null;
        }
        Nodes lowestNodes = this.nodesByScore.firstEntry().getValue();
        return lowestNodes.nodesByDepth.lastEntry().getValue();
    }

    public ConfSMAStarNode removeHighestShallowestLeaf() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty");
        }
        Nodes highestNodes = this.nodesByScore.lastEntry().getValue();
        ConfSMAStarNode leaf = null;
        Iterator<ConfSMAStarNode> iter = highestNodes.nodesByDepth.values().iterator();
        while (iter.hasNext()) {
            ConfSMAStarNode node = iter.next();
            if (node.hasSpawnedChildren()) continue;
            leaf = node;
            iter.remove();
            break;
        }
        if (highestNodes.nodesByDepth.isEmpty()) {
            this.nodesByScore.remove(highestNodes.score);
        }
        return leaf;
    }

    private static class Nodes {
        final double score;
        final TreeMap<Integer, ConfSMAStarNode> nodesByDepth = new TreeMap();

        Nodes(double score) {
            this.score = score;
        }
    }
}

