/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.seq.nodes;

import edu.duke.cs.osprey.astar.OptimizableAStarNode;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import java.util.Arrays;

public interface SeqAStarNode
extends OptimizableAStarNode,
Comparable<SeqAStarNode> {
    public SeqAStarNode assign(int var1, int var2);

    public void getAssignments(Assignments var1);

    public void getSequence(Sequence var1);

    public Object getData();

    public void setData(Object var1);

    @Override
    default public int compareTo(SeqAStarNode other) {
        return Double.compare(this.getScore(), other.getScore());
    }

    default public Sequence makeSequence(SeqSpace seqSpace) {
        Sequence seq = seqSpace.makeUnassignedSequence();
        this.getSequence(seq);
        return seq;
    }

    public static class Assignments {
        public final int numPos;
        public final int[] assignedPos;
        public final int[] assignedRTs;
        public int numAssigned;
        public final int[] unassignedPos;
        public int numUnassigned;

        public Assignments(int numPos) {
            this.numPos = numPos;
            this.assignedPos = new int[numPos];
            this.assignedRTs = new int[numPos];
            this.numAssigned = 0;
            this.unassignedPos = new int[numPos];
            for (int i = 0; i < numPos; ++i) {
                this.unassignedPos[i] = i;
            }
            this.numUnassigned = numPos;
        }

        public void sortAssigned() {
            for (int i = 1; i < this.numAssigned; ++i) {
                int tempPos = this.assignedPos[i];
                int tempRT = this.assignedRTs[i];
                for (int j = i; j >= 1 && tempPos < this.assignedPos[j - 1]; --j) {
                    this.assignedPos[j] = this.assignedPos[j - 1];
                    this.assignedRTs[j] = this.assignedRTs[j - 1];
                }
                this.assignedPos[j] = tempPos;
                this.assignedRTs[j] = tempRT;
            }
        }

        public Integer getAssignment(int pos) {
            int i = Arrays.binarySearch(this.assignedPos, 0, this.numAssigned, pos);
            if (i >= 0) {
                return this.assignedRTs[i];
            }
            return null;
        }

        public boolean isAssigned(int pos) {
            return this.getAssignment(pos) != null;
        }

        public Assignments updateUnassigned() {
            this.numUnassigned = 0;
            for (int pos = 0; pos < this.numPos; ++pos) {
                if (this.isAssigned(pos)) continue;
                this.unassignedPos[this.numUnassigned++] = pos;
            }
            return this;
        }

        public Assignments assign(int pos, int rt) {
            int i = Arrays.binarySearch(this.unassignedPos, 0, this.numUnassigned, pos);
            if (i < 0) {
                throw new IllegalArgumentException("position " + pos + " is already assigned");
            }
            --this.numUnassigned;
            System.arraycopy(this.unassignedPos, i + 1, this.unassignedPos, i, this.numUnassigned - i);
            i = Arrays.binarySearch(this.assignedPos, 0, this.numAssigned, pos);
            assert (i < 0);
            i = -i - 1;
            System.arraycopy(this.assignedPos, i, this.assignedPos, i + 1, this.numAssigned - i);
            System.arraycopy(this.assignedRTs, i, this.assignedRTs, i + 1, this.numAssigned - i);
            ++this.numAssigned;
            this.assignedPos[i] = pos;
            this.assignedRTs[i] = rt;
            return this;
        }

        public Assignments unassign(int pos) {
            int i = Arrays.binarySearch(this.assignedPos, 0, this.numAssigned, pos);
            if (i < 0) {
                throw new IllegalArgumentException("position " + pos + " is not assigned");
            }
            --this.numAssigned;
            System.arraycopy(this.assignedPos, i + 1, this.assignedPos, i, this.numAssigned - i);
            System.arraycopy(this.assignedRTs, i + 1, this.assignedRTs, i, this.numAssigned - i);
            i = Arrays.binarySearch(this.unassignedPos, 0, this.numUnassigned, pos);
            assert (i < 0);
            i = -i - 1;
            System.arraycopy(this.unassignedPos, i, this.unassignedPos, i + 1, this.numUnassigned - i);
            ++this.numUnassigned;
            this.unassignedPos[i] = pos;
            return this;
        }

        public RCs makeRCs(SeqSpace seqSpace, SimpleConfSpace confSpace) {
            return new RCs(confSpace, (confPos, resConf) -> {
                if (!confPos.hasMutations()) {
                    return true;
                }
                SeqSpace.Position seqPos = seqSpace.getPosition(confPos.resNum);
                Integer assignment = this.getAssignment(seqPos.index);
                if (assignment == null) {
                    return true;
                }
                SeqSpace.ResType resType = seqPos.resTypes.get(assignment);
                return resType.name.equals(resConf.template.name);
            });
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.numAssigned; ++i) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(this.assignedPos[i]);
                buf.append("=");
                buf.append(this.assignedRTs[i]);
            }
            return buf.toString();
        }

        public String toString(SeqSpace seqSpace) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.numAssigned; ++i) {
                SeqSpace.Position pos = seqSpace.positions.get(this.assignedPos[i]);
                SeqSpace.ResType rt = pos.resTypes.get(this.assignedRTs[i]);
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(pos.toString());
                buf.append("=");
                buf.append(rt.toString());
            }
            return buf.toString();
        }
    }
}

