/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.bbfree;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.bbfree.BBFreeBlock;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;

public class BBFreeDOF
extends DegreeOfFreedom {
    DoubleMatrix1D coeffs;
    BBFreeBlock block;
    int indexInBlock;

    public BBFreeDOF(DoubleMatrix1D coeffs, BBFreeBlock block, int indexInBlock) {
        this.coeffs = coeffs;
        this.block = block;
        this.indexInBlock = indexInBlock;
    }

    @Override
    public void apply(double paramVal) {
        double[] newDOFVals = (double[])this.block.curFreeDOFVals.clone();
        newDOFVals[this.indexInBlock] = paramVal;
        this.block.setDOFs(DoubleFactory1D.dense.make(newDOFVals));
    }

    public double evalAtFullDOFs(DoubleMatrix1D fullDOFVals) {
        return fullDOFVals.zDotProduct(this.coeffs);
    }

    @Override
    public DOFBlock getBlock() {
        return this.block;
    }

    @Override
    public String getName() {
        return "CATS" + this.block.residues.get(0).getPDBResNumber() + "." + this.indexInBlock;
    }
}

