/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.bbfree;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.Serializable;

public class PepPlaneLinModel
implements Serializable {
    private DoubleMatrix1D CCoeffs;
    private DoubleMatrix1D HCoeffs;
    private DoubleMatrix1D OCoeffs;

    public PepPlaneLinModel(Residue res1, Residue res2) {
        if (res1.template.name.equalsIgnoreCase("PRO") || res2.template.name.equalsIgnoreCase("PRO")) {
            throw new RuntimeException("ERROR: CATS doesn't handle proline");
        }
        double[] CA1 = res1.getCoordsByAtomName("CA");
        double[] CA2 = res2.getCoordsByAtomName("CA");
        double[] N = res2.getCoordsByAtomName("N");
        double[] C = res1.getCoordsByAtomName("C");
        double[] O = res1.getCoordsByAtomName("O");
        double[] H = res2.getCoordsByAtomName("H");
        DoubleMatrix2D M = this.makeAxisMatrix(CA1, N, CA2);
        DoubleMatrix2D vec = DoubleFactory2D.dense.make(3, 1);
        vec.viewColumn(0).assign(VectorAlgebra.subtract(C, CA1));
        this.CCoeffs = Algebra.DEFAULT.solve(M, vec).viewColumn(0);
        vec.viewColumn(0).assign(VectorAlgebra.subtract(O, CA1));
        this.OCoeffs = Algebra.DEFAULT.solve(M, vec).viewColumn(0);
        vec.viewColumn(0).assign(VectorAlgebra.subtract(H, CA1));
        this.HCoeffs = Algebra.DEFAULT.solve(M, vec).viewColumn(0);
    }

    private DoubleMatrix2D makeAxisMatrix(double[] CA1, double[] N, double[] CA2) {
        double[] axis1 = VectorAlgebra.subtract(N, CA1);
        double[] axis2 = VectorAlgebra.subtract(CA2, CA1);
        double[] axis3 = VectorAlgebra.cross(axis1, axis2);
        DoubleMatrix2D M = DoubleFactory2D.dense.make((double[][])new double[][]{axis1, axis2, axis3});
        return Algebra.DEFAULT.transpose(M);
    }

    double[] calcCCoords(double[] CA1, double[] N, double[] CA2, boolean projIntoPlane) {
        if (projIntoPlane) {
            return this.calcCoordsProj(CA1, N, CA2, this.CCoeffs.viewPart(0, 2));
        }
        return this.calcCoords(CA1, N, CA2, this.CCoeffs);
    }

    double[] calcOCoords(double[] CA1, double[] N, double[] CA2) {
        return this.calcCoords(CA1, N, CA2, this.OCoeffs);
    }

    double[] calcHCoords(double[] CA1, double[] N, double[] CA2) {
        return this.calcCoords(CA1, N, CA2, this.HCoeffs);
    }

    private double[] calcCoords(double[] CA1, double[] N, double[] CA2, DoubleMatrix1D coeffs) {
        DoubleMatrix2D M = this.makeAxisMatrix(CA1, N, CA2);
        return VectorAlgebra.add(CA1, Algebra.DEFAULT.mult(M, coeffs).toArray());
    }

    private double[] calcCoordsProj(double[] CA1, double[] N, double[] CA2, DoubleMatrix1D coeffs) {
        DoubleMatrix2D M = this.makeAxisMatrix(CA1, N, CA2).viewPart(0, 0, 3, 2);
        return VectorAlgebra.add(CA1, Algebra.DEFAULT.mult(M, coeffs).toArray());
    }

    public double[] getProjCAtomCoeffs() {
        double[] ans = new double[]{1.0 - this.CCoeffs.get(0) - this.CCoeffs.get(1), this.CCoeffs.get(0), this.CCoeffs.get(1)};
        return ans;
    }
}

