/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.PosMatrix;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import java.io.Serializable;
import java.util.Iterator;

public abstract class AbstractPosMatrix<T>
implements PosMatrix<T>,
Serializable {
    private int numPos;
    private int numPairs;

    protected AbstractPosMatrix(SimpleConfSpace confSpace) {
        this(confSpace.positions.size());
    }

    protected AbstractPosMatrix(int numPos) {
        this.numPos = numPos;
        this.numPairs = numPos * (numPos - 1) / 2;
        this.allocate(this.numPairs);
    }

    protected abstract void allocate(int var1);

    @Override
    public int getNumPos() {
        return this.numPos;
    }

    @Override
    public int getNumPairs() {
        return this.numPairs;
    }

    private int getIndexNoCheck(int pos1, int pos2) {
        return pos1 * (pos1 - 1) / 2 + pos2;
    }

    protected int getIndex(int pos1, int pos2) {
        if (pos2 > pos1) {
            int swap = pos1;
            pos1 = pos2;
            pos2 = swap;
        } else if (pos1 == pos2) {
            throw new Error("Can't pair residue " + pos1 + " with itself");
        }
        return this.getIndexNoCheck(pos1, pos2);
    }

    @Override
    public void fill(T val) {
        for (int pos1 = 0; pos1 < this.getNumPos(); ++pos1) {
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                this.set(pos1, pos2, val);
            }
        }
    }

    @Override
    public void fill(Iterator<T> val) {
        for (int pos1 = 0; pos1 < this.getNumPos(); ++pos1) {
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                this.set(pos1, pos2, val.next());
            }
        }
    }
}

