/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.structure.Molecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class ParameterizedMoleculeCopy {
    private Molecule copiedMol = null;
    private final LinkedHashMap<DegreeOfFreedom, DegreeOfFreedom> original2CopiedDOF = new LinkedHashMap();

    public ParameterizedMoleculeCopy(ConfSpace confSpace) {
        this.copiedMol = new Molecule(confSpace.m);
        ArrayList<DegreeOfFreedom> origDOFs = confSpace.listAllDOFs();
        HashMap<DOFBlock, DOFBlock> newBlocks = new HashMap<DOFBlock, DOFBlock>();
        for (DegreeOfFreedom dof : origDOFs) {
            DOFBlock block = dof.getBlock();
            if (block == null) {
                DegreeOfFreedom copiedDOF = dof.copy();
                copiedDOF.setMolecule(this.copiedMol);
                this.original2CopiedDOF.put(dof, copiedDOF);
                continue;
            }
            if (newBlocks.containsKey(block)) continue;
            DOFBlock copiedBlock = block.copyForNewMolecule(this.copiedMol, this.original2CopiedDOF);
            newBlocks.put(block, copiedBlock);
        }
    }

    private ParameterizedMoleculeCopy() {
    }

    public static ParameterizedMoleculeCopy makeNoCopy(ConfSpace confSpace) {
        ParameterizedMoleculeCopy pmc = new ParameterizedMoleculeCopy();
        pmc.copiedMol = confSpace.m;
        for (DegreeOfFreedom dof : confSpace.listAllDOFs()) {
            pmc.original2CopiedDOF.put(dof, dof);
        }
        return pmc;
    }

    public Molecule getCopiedMolecule() {
        return this.copiedMol;
    }

    public DegreeOfFreedom getCopiedDOF(DegreeOfFreedom origDOF) {
        return this.original2CopiedDOF.get(origDOF);
    }
}

