/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import java.io.Serializable;
import java.util.ArrayList;

public class RC
implements Serializable {
    public String AAType;
    public ResidueTemplate template;
    public int rotNum;
    public ArrayList<DegreeOfFreedom> DOFs;
    public ArrayList<Double> DOFmin;
    public ArrayList<Double> DOFmax;
    public int RCIndex;

    public RC(String AAType, ResidueTemplate template, int rotNum, ArrayList<DegreeOfFreedom> DOFs, ArrayList<Double> DOFmin, ArrayList<Double> DOFmax, int RCIndex) {
        this.AAType = AAType;
        this.template = template;
        this.rotNum = rotNum;
        this.DOFs = DOFs;
        this.DOFmin = DOFmin;
        this.DOFmax = DOFmax;
        this.RCIndex = RCIndex;
    }

    public RC(RC other) {
        this.AAType = other.AAType;
        this.template = other.template;
        this.rotNum = other.rotNum;
        this.DOFs = other.DOFs;
        this.DOFmin = new ArrayList<Double>(other.DOFmin);
        this.DOFmax = new ArrayList<Double>(other.DOFmax);
        this.RCIndex = other.RCIndex;
    }

    public boolean isParametricallyIncompatibleWith(RC rc2) {
        double tol = 1.0E-8;
        for (int dof = 0; dof < this.DOFs.size(); ++dof) {
            for (int dof2 = 0; dof2 < rc2.DOFs.size(); ++dof2) {
                if (this.DOFs.get(dof) != rc2.DOFs.get(dof2)) continue;
                if (Math.abs(this.DOFmin.get(dof) - rc2.DOFmin.get(dof2)) > 1.0E-8) {
                    return true;
                }
                if (!(Math.abs(this.DOFmax.get(dof) - rc2.DOFmax.get(dof2)) > 1.0E-8)) continue;
                return true;
            }
        }
        return false;
    }
}

