/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.tools.HashCalculator;
import java.io.Serializable;
import java.util.ArrayList;

public class RCTuple
implements Serializable {
    private static final long serialVersionUID = 3773470316855163174L;
    public ArrayList<Integer> pos;
    public ArrayList<Integer> RCs;

    public RCTuple() {
        this.pos = new ArrayList();
        this.RCs = new ArrayList();
    }

    public RCTuple(ArrayList<Integer> pos, ArrayList<Integer> RCs2) {
        this.pos = pos;
        this.RCs = RCs2;
    }

    public RCTuple(int pos1, int RC1) {
        this();
        this.set(pos1, RC1);
    }

    public RCTuple(int pos1, int RC1, int pos2, int RC2) {
        this();
        this.set(pos1, RC1, pos2, RC2);
    }

    public RCTuple(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        this();
        this.set(pos1, rc1, pos2, rc2, pos3, rc3);
    }

    public RCTuple(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4) {
        this();
        this.set(pos1, rc1, pos2, rc2, pos3, rc3, pos4, rc4);
    }

    public RCTuple(int[] conf) {
        this();
        this.set(conf);
    }

    public RCTuple(ConfIndex index) {
        this();
        this.set(index);
    }

    public RCTuple set(int pos, int rc) {
        this.pos.clear();
        this.RCs.clear();
        this.pos.add(pos);
        this.RCs.add(rc);
        return this;
    }

    public RCTuple set(int pos1, int rc1, int pos2, int rc2) {
        this.pos.clear();
        this.RCs.clear();
        this.pos.add(pos1);
        this.RCs.add(rc1);
        this.pos.add(pos2);
        this.RCs.add(rc2);
        return this;
    }

    public RCTuple set(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        this.pos.clear();
        this.RCs.clear();
        this.pos.add(pos1);
        this.RCs.add(rc1);
        this.pos.add(pos2);
        this.RCs.add(rc2);
        this.pos.add(pos3);
        this.RCs.add(rc3);
        return this;
    }

    public RCTuple set(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4) {
        this.pos.clear();
        this.RCs.clear();
        this.pos.add(pos1);
        this.RCs.add(rc1);
        this.pos.add(pos2);
        this.RCs.add(rc2);
        this.pos.add(pos3);
        this.RCs.add(rc3);
        this.pos.add(pos4);
        this.RCs.add(rc4);
        return this;
    }

    public void set(int[] conf) {
        this.pos.clear();
        this.RCs.clear();
        for (int posNum = 0; posNum < conf.length; ++posNum) {
            if (conf[posNum] < 0) continue;
            this.pos.add(posNum);
            this.RCs.add(conf[posNum]);
        }
    }

    public void set(RCTuple other) {
        this.pos.clear();
        this.RCs.clear();
        this.pos.addAll(other.pos);
        this.RCs.addAll(other.RCs);
    }

    public void set(ConfIndex index) {
        this.pos.clear();
        this.RCs.clear();
        for (int i = 0; i < index.numDefined; ++i) {
            this.pos.add(index.definedPos[i]);
            this.RCs.add(index.definedRCs[i]);
        }
    }

    public int size() {
        return this.pos.size();
    }

    public boolean isSameTuple(RCTuple tuple2) {
        if (this == tuple2) {
            return true;
        }
        if (this.pos.size() != this.RCs.size() || tuple2.pos.size() != tuple2.RCs.size()) {
            throw new RuntimeException("ERROR: Ill-defined RC tuple");
        }
        if (this.pos.size() != tuple2.pos.size()) {
            return false;
        }
        for (int index = 0; index < this.pos.size(); ++index) {
            if (this.pos.get(index) != tuple2.pos.get(index)) {
                return false;
            }
            if (this.RCs.get(index) == tuple2.RCs.get(index)) continue;
            return false;
        }
        return true;
    }

    public String stringListing() {
        Object ans = "";
        for (int posNum = 0; posNum < this.pos.size(); ++posNum) {
            ans = (String)ans + "Res " + String.valueOf(this.pos.get(posNum)) + " RC " + String.valueOf(this.RCs.get(posNum)) + " ";
        }
        return ans;
    }

    public RCTuple subtractMember(int index) {
        ArrayList<Integer> newPos = new ArrayList<Integer>();
        ArrayList<Integer> newRCs = new ArrayList<Integer>();
        for (int ind = 0; ind < this.pos.size(); ++ind) {
            if (ind == index) continue;
            newPos.add(this.pos.get(ind));
            newRCs.add(this.RCs.get(ind));
        }
        return new RCTuple(newPos, newRCs);
    }

    public RCTuple addRC(int addedPos, int addedRC) {
        ArrayList newPos = (ArrayList)this.pos.clone();
        ArrayList newRCs = (ArrayList)this.RCs.clone();
        newPos.add(addedPos);
        newRCs.add(addedRC);
        return new RCTuple(newPos, newRCs);
    }

    public int hashCode() {
        return HashCalculator.combineHashes(this.pos.hashCode(), this.RCs.hashCode());
    }

    public boolean equals(Object other) {
        return other instanceof RCTuple && this.equals((RCTuple)other);
    }

    public boolean equals(RCTuple other) {
        return this.isSameTuple(other);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.pos.get(i));
            buf.append("=");
            buf.append(this.RCs.get(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public void sortPositions() {
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            int j;
            int tempPos = this.pos.get(i);
            int tempRC = this.RCs.get(i);
            for (j = i; j >= 1 && tempPos < this.pos.get(j - 1); --j) {
                this.pos.set(j, this.pos.get(j - 1));
                this.RCs.set(j, this.RCs.get(j - 1));
            }
            this.pos.set(j, tempPos);
            this.RCs.set(j, tempRC);
        }
    }

    public RCTuple sorted() {
        this.sortPositions();
        return this;
    }

    public void checkSortedPositions() {
        for (int i = 1; i < this.pos.size(); ++i) {
            if (this.pos.get(i) > this.pos.get(i - 1)) continue;
            throw new IllegalStateException("RCTuple positions are not sorted");
        }
    }

    public RCTuple intersect(RCTuple other) {
        return RCTuple.intersect(this, other);
    }

    public static RCTuple intersect(RCTuple first, RCTuple second) {
        RCTuple out = new RCTuple();
        for (int tupIndex = 0; tupIndex < first.size(); ++tupIndex) {
            int firstPos = first.pos.get(tupIndex);
            int firstRC = first.RCs.get(tupIndex);
            if (!second.pos.contains(firstPos) || second.RCs.get(tupIndex) != firstRC) continue;
            out = out.addRC(firstPos, firstRC);
        }
        return out;
    }

    public Integer getRC(int index) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.pos.get(i) != index) continue;
            return this.RCs.get(i);
        }
        return null;
    }
}

