/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.TupleEnumerator;
import edu.duke.cs.osprey.confspace.TupleMatrix;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.EnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.ReferenceEnergies;
import edu.duke.cs.osprey.ematrix.SimpleEnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.epic.EPICMatrix;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.EnergyFunctionGenerator;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.plug.PolytopeMatrix;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tupexp.ConfETupleExpander;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import edu.duke.cs.osprey.tupexp.TupExpChooser;
import edu.duke.cs.osprey.voxq.VoxelGCalculator;
import java.io.Serializable;
import java.util.ArrayList;

public class SearchProblem
implements Serializable {
    private static final long serialVersionUID = 2590525329048496524L;
    public ConfSpace confSpace;
    public EnergyMatrix emat;
    public EPICMatrix epicMat = null;
    public EPICSettings epicSettings = null;
    public LUTESettings luteSettings = null;
    public DEEPerSettings deeperSettings = null;
    public EnergyMatrix tupExpEMat;
    public EnergyFunction fullConfE;
    public ArrayList<Residue> shellResidues;
    public String name;
    public PruningMatrix pruneMat;
    public boolean contSCFlex;
    public boolean useVoxelG = false;
    VoxelGCalculator gCalc = null;
    public PruningMatrix competitorPruneMat;
    public ArrayList<String> flexRes;
    public ArrayList<ArrayList<String>> allowedAAs;
    public boolean useEPIC = false;
    public boolean useTupExpForSearch = false;
    public boolean useERef = false;
    public boolean addResEntropy = false;
    public int numEmatThreads = 1;
    public PolytopeMatrix plugMat;

    public SearchProblem(SearchProblem other) {
        this.confSpace = other.confSpace;
        this.emat = other.emat;
        this.epicMat = other.epicMat;
        this.epicSettings = other.epicSettings;
        this.luteSettings = other.luteSettings;
        this.deeperSettings = other.deeperSettings;
        this.tupExpEMat = other.tupExpEMat;
        this.fullConfE = other.fullConfE;
        this.shellResidues = other.shellResidues;
        this.name = other.name + System.currentTimeMillis();
        this.pruneMat = other.pruneMat;
        this.competitorPruneMat = other.competitorPruneMat;
        this.contSCFlex = other.contSCFlex;
        this.flexRes = other.flexRes;
        this.allowedAAs = other.allowedAAs;
        this.useVoxelG = other.useVoxelG;
        this.gCalc = other.gCalc;
        this.useEPIC = other.useEPIC;
        this.useTupExpForSearch = other.useTupExpForSearch;
        this.useERef = other.useERef;
        this.addResEntropy = other.addResEntropy;
        this.numEmatThreads = other.numEmatThreads;
    }

    public SearchProblem(String name, String PDBFile, ArrayList<String> flexibleRes, ArrayList<ArrayList<String>> allowedAAs, boolean addWT, boolean contSCFlex, boolean useEPIC, EPICSettings epicSettings, boolean useTupExp, LUTESettings luteSettings, DEEPerSettings dset, ArrayList<String[]> moveableStrands, ArrayList<String[]> freeBBZones, boolean useEllipses, boolean useERef, boolean addResEntropy, boolean addWTRots, ResidueTermini termini, boolean useVoxelG, ArrayList<String> wtRotOnlyRes) {
        this.confSpace = new ConfSpace(PDBFile, flexibleRes, allowedAAs, addWT, wtRotOnlyRes, contSCFlex, dset, moveableStrands, freeBBZones, useEllipses, addWTRots, termini);
        this.name = name;
        this.flexRes = flexibleRes;
        this.allowedAAs = allowedAAs;
        this.contSCFlex = contSCFlex;
        this.useTupExpForSearch = useTupExp;
        this.useEPIC = useEPIC;
        this.epicSettings = epicSettings;
        this.luteSettings = luteSettings;
        this.deeperSettings = dset;
        this.useERef = useERef;
        this.addResEntropy = addResEntropy;
        this.useVoxelG = useVoxelG;
        EnergyFunctionGenerator eGen = EnvironmentVars.curEFcnGenerator;
        this.decideShellResidues(eGen.ffParams.shellDistCutoff);
        this.fullConfE = eGen.fullConfEnergy(this.confSpace, this.shellResidues);
    }

    private void decideShellResidues(double distCutoff) {
        ArrayList<Residue> flexibleResidues = new ArrayList<Residue>();
        for (PositionConfSpace pcs : this.confSpace.posFlex) {
            flexibleResidues.add(pcs.res);
        }
        this.shellResidues = new ArrayList();
        block1: for (Residue nonFlexRes : this.confSpace.m.residues) {
            if (flexibleResidues.contains(nonFlexRes)) continue;
            for (Residue flexRes : flexibleResidues) {
                double dist = flexRes.distanceTo(nonFlexRes);
                if (!(dist <= distCutoff)) continue;
                this.shellResidues.add(nonFlexRes);
                continue block1;
            }
        }
    }

    public double minimizedEnergy(int[] conf) {
        if (this.useVoxelG) {
            return this.gCalc.calcG(conf);
        }
        double E = this.confSpace.minimizeEnergy(conf, this.fullConfE, null);
        if (this.useERef) {
            E -= this.emat.geteRefMat().confERef(conf);
        }
        if (this.addResEntropy) {
            E += this.confSpace.getConfResEntropy(conf);
        }
        return E;
    }

    public void outputMinimizedStruct(int[] conf, String PDBFileName) {
        this.confSpace.minimizeEnergy(conf, this.fullConfE, PDBFileName);
    }

    public double approxMinimizedEnergy(int[] conf) {
        if (this.useTupExpForSearch) {
            return this.tupExpEMat.confE(conf);
        }
        if (this.useEPIC) {
            return this.EPICMinimizedEnergy(conf);
        }
        throw new RuntimeException("ERROR: Asking searchSpace to approximate minimized energy but using a non-approximating method");
    }

    public double voxelFreeEnergy(int[] conf) {
        if (this.gCalc == null) {
            throw new RuntimeException("ERROR: Free energy calculator is null (probably no EPIC matrix loaded)");
        }
        return this.gCalc.calcG(conf);
    }

    public double EPICMinimizedEnergy(int[] conf) {
        if (this.useVoxelG) {
            return this.voxelFreeEnergy(conf);
        }
        return this.epicMat.minimizeEnergy(new RCTuple(conf), true);
    }

    public double lowerBound(int[] conf) {
        double bound = this.emat.confE(conf);
        return bound;
    }

    public void loadEnergyMatrix() {
        this.loadMatrix(MatrixType.EMAT);
    }

    public void loadTupExpEMatrix() {
        this.loadMatrix(MatrixType.TUPEXPEMAT);
    }

    public void loadEPICMatrix() {
        this.loadMatrix(MatrixType.EPICMAT);
        if (this.useVoxelG) {
            this.gCalc = new VoxelGCalculator(this);
        }
    }

    public void loadPLUGMatrix() {
        this.loadMatrix(MatrixType.PLUGMAT);
    }

    public void loadMatrix(MatrixType type) {
        String matrixFileName = this.name + "." + type.name() + ".dat";
        if (!this.loadMatrixFromFile(type, matrixFileName)) {
            TupleMatrix<?> matrix = this.calcMatrix(type);
            ObjectIO.writeObject(matrix, matrixFileName);
            this.loadMatrixFromFile(type, matrixFileName);
        }
    }

    public TupleMatrix<?> calcMatrix(MatrixType type) {
        if (type == MatrixType.EMAT) {
            if (EnvironmentVars.useMPI || this.deeperSettings != null && this.deeperSettings.doPerturbations()) {
                System.out.println("\n\nWARNING: concurrent minimizations disabled\n");
                if (EnvironmentVars.useMPI && this.numEmatThreads > 1) {
                    System.out.println("\n\nWARNING: multiple threads and MPI both configured for emat calculation. Ignoring thread settings and using only MPI.\n");
                }
                EnergyMatrixCalculator emCalc = new EnergyMatrixCalculator(this.confSpace, this.shellResidues, this.useERef, this.addResEntropy);
                emCalc.calcPEM();
                return emCalc.getEMatrix();
            }
            SimpleEnergyMatrixCalculator.Cpu ecalc = new SimpleEnergyMatrixCalculator.Cpu(this.numEmatThreads, EnvironmentVars.curEFcnGenerator.ffParams, this.confSpace, this.shellResidues);
            EnergyMatrix emat = ecalc.calcEnergyMatrix();
            if (this.useERef) {
                System.out.println("Computing reference energies...");
                emat.seteRefMat(new ReferenceEnergies(this.confSpace));
            }
            if (this.addResEntropy) {
                System.out.println("Computing residue entropies...");
                for (int pos = 0; pos < emat.getNumPos(); ++pos) {
                    for (int rc = 0; rc < emat.getNumConfAtPos(pos); ++rc) {
                        double energy = emat.getOneBody(pos, rc);
                        emat.setOneBody(pos, rc, energy += this.confSpace.getRCResEntropy(pos, rc));
                    }
                }
            }
            ((SimpleEnergyMatrixCalculator)ecalc).cleanup();
            return emat;
        }
        if (type == MatrixType.EPICMAT) {
            EnergyMatrixCalculator emCalc = new EnergyMatrixCalculator(this.confSpace, this.shellResidues, this.pruneMat, this.epicSettings);
            emCalc.calcPEM();
            return emCalc.getEPICMatrix();
        }
        if (type == MatrixType.PLUGMAT) {
            return new PolytopeMatrix(this, false);
        }
        ConfETupleExpander expander = new ConfETupleExpander(this);
        TupleEnumerator tupEnum = new TupleEnumerator(this.pruneMat, this.emat, this.confSpace.numPos);
        TupExpChooser chooser = new TupExpChooser(expander, tupEnum);
        double curResid = chooser.calcPairwiseExpansion();
        if (curResid > this.luteSettings.goalResid) {
            System.out.println("EXPANDING PAIRWISE EXPANSION WITH STRONGLY PAIR-INTERACTING TRIPLES (2 PARTNERS)...");
            curResid = chooser.calcExpansionResTriples(2);
        }
        if (curResid > this.luteSettings.goalResid) {
            System.out.println("EXPANDING EXPANSION WITH STRONGLY PAIR-INTERACTING TRIPLES (5 PARTNERS)...");
            curResid = chooser.calcExpansionResTriples(5);
        }
        if (curResid > this.luteSettings.goalResid) {
            System.out.println("WARNING: Desired LUTE residual threshold " + this.luteSettings.goalResid + " not reached; best=" + curResid);
        }
        return expander.getEnergyMatrix();
    }

    boolean loadMatrixFromFile(MatrixType type, String matrixFileName) {
        Object matrixFromFile = ObjectIO.readObject(matrixFileName, true);
        if (type == MatrixType.EMAT) {
            this.emat = (EnergyMatrix)matrixFromFile;
        } else if (type == MatrixType.EPICMAT) {
            this.epicMat = (EPICMatrix)matrixFromFile;
        } else if (type == MatrixType.PLUGMAT) {
            this.plugMat = (PolytopeMatrix)matrixFromFile;
        } else {
            this.tupExpEMat = (EnergyMatrix)matrixFromFile;
        }
        if (matrixFromFile == null) {
            return false;
        }
        double matrixPruningInterval = ((TupleMatrix)matrixFromFile).getPruningInterval();
        if (matrixPruningInterval == Double.POSITIVE_INFINITY) {
            return true;
        }
        if (this.pruneMat == null) {
            throw new RuntimeException("ERROR: Trying to load pruning-dependent tuple matrix(EPIC or tup-exp) but haven't pruned yet");
        }
        return matrixPruningInterval >= this.pruneMat.getPruningInterval();
    }

    public boolean searchNeedsHigherOrderTerms() {
        if (this.useTupExpForSearch) {
            return this.tupExpEMat.hasHigherOrderTerms();
        }
        return this.emat.hasHigherOrderTerms();
    }

    public static enum MatrixType {
        EMAT,
        TUPEXPEMAT,
        EPICMAT,
        PLUGMAT;

    }
}

