/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Sequence {
    public static final int Unassigned = -1;
    public final SeqSpace seqSpace;
    public final int[] rtIndices;

    public Sequence(SeqSpace seqSpace) {
        this.seqSpace = seqSpace;
        this.rtIndices = new int[seqSpace.positions.size()];
        Arrays.fill(this.rtIndices, -1);
    }

    public Sequence(SeqSpace seqSpace, int[] rtIndices) {
        this.seqSpace = seqSpace;
        this.rtIndices = rtIndices;
    }

    public List<String> resNums() {
        return this.seqSpace.positions.stream().map(pos -> pos.resNum).collect(Collectors.toList());
    }

    private void checkPos(SeqSpace.Position pos) {
        if (pos.seqSpace != this.seqSpace) {
            throw new IllegalArgumentException("sequence position " + String.valueOf(pos) + " is not part of this sequence space");
        }
    }

    private void checkRT(SeqSpace.Position pos, SeqSpace.ResType rt) {
        if (rt.pos != pos) {
            throw new IllegalArgumentException("res type " + String.valueOf(rt) + " is not part of sequence position " + String.valueOf(pos));
        }
    }

    public SeqSpace.ResType get(SeqSpace.Position pos) {
        this.checkPos(pos);
        int rt = this.rtIndices[pos.index];
        if (rt == -1) {
            return null;
        }
        return pos.resTypes.get(rt);
    }

    public SeqSpace.ResType get(String resNum) {
        return this.get(this.seqSpace.getPositionOrThrow(resNum));
    }

    public Sequence set(SeqSpace.Position pos, SeqSpace.ResType rt) {
        this.checkPos(pos);
        if (rt != null) {
            this.checkRT(pos, rt);
            this.rtIndices[pos.index] = rt.index;
        } else {
            this.rtIndices[pos.index] = -1;
        }
        return this;
    }

    public Sequence set(SeqSpace.Position pos, String resType) {
        this.checkPos(pos);
        if (resType != null) {
            SeqSpace.ResType rt = pos.getResTypeOrThrow(resType);
            this.rtIndices[pos.index] = rt.index;
        } else {
            this.rtIndices[pos.index] = -1;
        }
        return this;
    }

    public Sequence set(String resNum, String resType) {
        SeqSpace.Position pos = this.seqSpace.getPositionOrThrow(resNum);
        if (resType != null) {
            SeqSpace.ResType rt = pos.getResTypeOrThrow(resType);
            this.rtIndices[pos.index] = rt.index;
        } else {
            this.rtIndices[pos.index] = -1;
        }
        return this;
    }

    public Sequence unset(SeqSpace.Position pos) {
        this.rtIndices[pos.index] = -1;
        return this;
    }

    public Sequence unset(String resNum) {
        SeqSpace.Position pos = this.seqSpace.getPositionOrThrow(resNum);
        this.rtIndices[pos.index] = -1;
        return this;
    }

    public SeqSpace.ResType getWildType(String resNum) {
        return this.seqSpace.getPositionOrThrow((String)resNum).wildType;
    }

    public Sequence setWildType(SeqSpace.Position pos) {
        this.checkPos(pos);
        if (pos.wildType == null) {
            throw new NoSuchElementException("sequence space does not contain the wild type at position " + String.valueOf(pos));
        }
        this.rtIndices[pos.index] = pos.wildType.index;
        return this;
    }

    public Sequence setWildType(String resNum) {
        SeqSpace.Position pos = this.seqSpace.getPositionOrThrow(resNum);
        this.rtIndices[pos.index] = pos.wildType.index;
        return this;
    }

    public Sequence fillWildType() {
        for (SeqSpace.Position pos : this.seqSpace.positions) {
            if (pos.wildType == null || this.isAssigned(pos)) continue;
            this.setWildType(pos);
        }
        return this;
    }

    public Iterable<Assignment> assignments() {
        return () -> this.seqSpace.positions.stream().map(pos -> new Assignment((SeqSpace.Position)pos)).iterator();
    }

    public Iterable<Assignment> assignments(Iterable<String> resNums) {
        return () -> Streams.of(resNums).map(resNum -> new Assignment(this.seqSpace.getPositionOrThrow((String)resNum))).iterator();
    }

    public Sequence copy() {
        Sequence other = new Sequence(this.seqSpace);
        for (SeqSpace.Position pos : this.seqSpace.positions) {
            other.rtIndices[pos.index] = this.rtIndices[pos.index];
        }
        return other;
    }

    public String toString() {
        return this.toString(Renderer.AssignmentMutations);
    }

    public boolean isAssigned(SeqSpace.Position pos) {
        return this.get(pos) != null;
    }

    public boolean isAssigned(String resNum) {
        return this.get(resNum) != null;
    }

    public int countAssignments() {
        return (int)this.resNums().stream().filter((? super T resNum) -> this.isAssigned((String)resNum)).count();
    }

    public boolean isFullyAssigned() {
        return this.resNums().stream().allMatch(resNum -> this.isAssigned((String)resNum));
    }

    public boolean isWildType(SeqSpace.Position pos) {
        this.checkPos(pos);
        SeqSpace.ResType resType = this.get(pos);
        return resType != null && resType == pos.wildType;
    }

    public boolean isWildType(String resNum) {
        return this.isWildType(this.seqSpace.getPositionOrThrow(resNum));
    }

    public boolean isWildType() {
        return this.resNums().stream().allMatch(resNum -> this.isWildType((String)resNum));
    }

    public boolean isMutated(SeqSpace.Position pos) {
        SeqSpace.ResType resType = this.get(pos);
        return resType != null && resType != pos.wildType;
    }

    public boolean isMutated(String resNum) {
        return this.isMutated(this.seqSpace.getPositionOrThrow(resNum));
    }

    public int countMutations() {
        return (int)this.resNums().stream().filter((? super T resNum) -> this.isMutated((String)resNum)).count();
    }

    public Sequence filter(SeqSpace smallerSeqSpace) {
        Sequence seq = smallerSeqSpace.makeUnassignedSequence();
        for (SeqSpace.Position smallerPos : smallerSeqSpace.positions) {
            SeqSpace.Position biggerPos = this.seqSpace.getPositionOrThrow(smallerPos.resNum);
            SeqSpace.ResType biggerRT = this.get(biggerPos);
            SeqSpace.ResType smallerRT = null;
            if (biggerRT != null) {
                smallerRT = smallerPos.getResTypeOrThrow(biggerRT.name);
            }
            seq.set(smallerPos, smallerRT);
        }
        return seq;
    }

    public RCs makeRCs(ConfSpaceIteration confSpace) {
        return new RCs(confSpace, (posi, confi) -> {
            if (!confSpace.hasMutations((int)posi)) {
                return true;
            }
            String name = confSpace.name((int)posi);
            if (!this.isAssigned(name)) {
                return true;
            }
            return this.get((String)name).name.equals(confSpace.confType((int)posi, (int)confi));
        });
    }

    public int hashCode() {
        return HashCalculator.combineHashes(this.seqSpace.hashCode(), Arrays.hashCode(this.rtIndices));
    }

    public boolean equals(Object other) {
        return other instanceof Sequence && this.equals((Sequence)other);
    }

    public boolean equals(Sequence other) {
        return this.seqSpace == other.seqSpace && Arrays.equals(this.rtIndices, other.rtIndices);
    }

    public boolean isSubsequenceOf(Sequence other) {
        if (this.seqSpace != other.seqSpace) {
            return false;
        }
        for (SeqSpace.Position pos : this.seqSpace.positions) {
            int thisRt;
            int otherRt = other.rtIndices[pos.index];
            if (otherRt == -1 || (thisRt = this.rtIndices[pos.index]) == otherRt) continue;
            return false;
        }
        return true;
    }

    public String toString(Renderer renderer) {
        return this.toString(renderer, null, this.resNums());
    }

    public String toString(Renderer renderer, int cellSize) {
        return this.toString(renderer, cellSize, this.resNums());
    }

    public String toString(Renderer renderer, Integer cellSize, List<String> resNums) {
        if (resNums.isEmpty()) {
            return "(no mutable residues)";
        }
        return String.join((CharSequence)" ", Streams.of(this.assignments(resNums)).filter((? super T assignment) -> assignment.isAssigned()).map(assignment -> {
            String rendered = renderer.render((Assignment)assignment);
            if (cellSize != null) {
                rendered = StringUtils.rightPad((String)rendered, (int)cellSize, (char)' ');
            }
            return rendered;
        }).collect(Collectors.toList()));
    }

    public int calcCellSize() {
        return this.seqSpace.positions.stream().map(pos -> Math.max(pos.resNum.length(), pos.resTypes.get((int)this.rtIndices[pos.index]).name.length())).max(Integer::compare).orElse(1);
    }

    public static enum Renderer {
        ResNum{

            @Override
            public String render(Assignment assignment) {
                return assignment.getResNum();
            }
        }
        ,
        ResType{

            @Override
            public String render(Assignment assignment) {
                return assignment.getResType().name;
            }
        }
        ,
        ResTypeMutations{

            @Override
            public String render(Assignment assignment) {
                return assignment.getResType().mutationName();
            }
        }
        ,
        Assignment{

            @Override
            public String render(Assignment assignment) {
                return ResNum.render(assignment) + "=" + ResType.render(assignment);
            }
        }
        ,
        AssignmentMutations{

            @Override
            public String render(Assignment assignment) {
                return ResNum.render(assignment) + "=" + ResTypeMutations.render(assignment);
            }
        };


        public abstract String render(Assignment var1);
    }

    public class Assignment {
        public final SeqSpace.Position pos;

        private Assignment(SeqSpace.Position pos) {
            this.pos = pos;
        }

        public String getResNum() {
            return this.pos.resNum;
        }

        public SeqSpace.ResType getResType() {
            return Sequence.this.get(this.pos);
        }

        public void setResType(String resType) {
            Sequence.this.set(this.pos, resType);
        }

        public SeqSpace.ResType getWildType() {
            return this.pos.wildType;
        }

        public void setWildType() {
            Sequence.this.setWildType(this.pos);
        }

        public boolean isAssigned() {
            return Sequence.this.isAssigned(this.pos);
        }

        public boolean isWildType() {
            return Sequence.this.isWildType(this.pos);
        }

        public boolean isMutated() {
            return Sequence.this.isMutated(this.pos);
        }
    }
}

