/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.VoxelShape;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.restypes.DAminoAcidHandler;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Strand
implements Serializable {
    public static final String WildType = "__WT__";
    public final Molecule mol;
    public final ResidueTemplateLibrary templateLib;
    public final Set<String> nonTemplateResNames;
    public final Flexibility flexibility;

    private Strand(Molecule mol, String firstResNumber, String lastResNumber, ResidueTemplateLibrary templateLib, boolean errorOnNonTemplateResidues, Residue.TemplateMatchingMethod templateMatchingMethod) {
        mol.residues.getOrThrow(firstResNumber);
        mol.residues.getOrThrow(lastResNumber);
        this.mol = new Molecule();
        for (Residue res : mol.getResRangeByPDBResNumber(firstResNumber, lastResNumber)) {
            Residue newRes = new Residue(res);
            this.mol.appendResidue(newRes);
            for (Residue altRes : mol.getAlternates(res.indexInMolecule)) {
                this.mol.addAlternate(newRes.indexInMolecule, new Residue(altRes));
            }
            assert (this.mol.getAlternates(newRes.indexInMolecule).size() == mol.getAlternates(res.indexInMolecule).size());
        }
        this.templateLib = templateLib;
        this.nonTemplateResNames = Strand.tryAssigningTemplates(this.mol, templateLib, templateMatchingMethod);
        if (!this.nonTemplateResNames.isEmpty()) {
            String resNames = String.join((CharSequence)"\n", this.nonTemplateResNames);
            if (errorOnNonTemplateResidues) {
                throw new Error("ERROR: " + this.nonTemplateResNames.size() + " Strand residue(s) could not be matched to templates:\n" + resNames);
            }
            this.mol.deleteResidues(this.nonTemplateResNames);
            System.out.println("WARNING: " + this.nonTemplateResNames.size() + " Strand residue(s) could not be matched to templates and were automatically deleted:\n" + resNames);
        }
        this.mol.markInterResBonds();
        this.flexibility = new Flexibility(this.mol.residues);
    }

    public static LinkedHashSet<String> tryAssigningTemplates(Molecule mol, ResidueTemplateLibrary templateLib, Residue.TemplateMatchingMethod templateMatchingMethod) {
        LinkedHashSet<String> nonTemplateResNames = new LinkedHashSet<String>();
        for (Residue res : mol.residues) {
            DAminoAcidHandler.tryRenamingAsD(res);
            for (Residue altRes : mol.getAlternates(res.indexInMolecule)) {
                DAminoAcidHandler.tryRenamingAsD(altRes);
            }
            boolean templateAssigned = res.assignTemplate(templateLib, templateMatchingMethod);
            if (templateAssigned) {
                Iterator<Residue> altIter = mol.getAlternates(res.indexInMolecule).iterator();
                while (altIter.hasNext()) {
                    Residue altRes = altIter.next();
                    boolean altTemplateAssigned = altRes.assignTemplate(templateLib, templateMatchingMethod);
                    if (altTemplateAssigned) continue;
                    altIter.remove();
                    nonTemplateResNames.add(altRes.fullName + " alternate");
                }
                continue;
            }
            nonTemplateResNames.add(res.fullName);
        }
        return nonTemplateResNames;
    }

    private static String stringResNumForMolec(int resNumInt, Molecule molec) {
        String pureNumber = Integer.toString(resNumInt);
        return molec.getResByPDBResNumber(pureNumber).getPDBResNumber();
    }

    public class Flexibility
    implements Serializable {
        private Map<String, ResidueFlex> residues = new LinkedHashMap<String, ResidueFlex>();

        public Flexibility(List<Residue> residues) {
            for (Residue res : residues) {
                this.residues.put(Residues.normalizeResNum(res.getPDBResNumber()), new ResidueFlex(res.template.name));
            }
        }

        @Deprecated
        public ResidueFlex get(int resNum) {
            return this.get(Strand.stringResNumForMolec(resNum, Strand.this.mol));
        }

        public ResidueFlex get(String resNum) {
            resNum = Residues.normalizeResNum(resNum);
            return this.residues.get(resNum);
        }

        public List<String> getFlexibleResidueNumbers() {
            return this.residues.entrySet().stream().filter(entry -> {
                ResidueFlex resFlex = (ResidueFlex)entry.getValue();
                return resFlex.isFlexible();
            }).map(entry -> {
                String resNum = (String)entry.getKey();
                return resNum;
            }).collect(Collectors.toList());
        }

        public List<String> getStaticResidueNumbers() {
            return this.residues.entrySet().stream().filter(entry -> {
                ResidueFlex resFlex = (ResidueFlex)entry.getValue();
                return !resFlex.isFlexible();
            }).map(entry -> {
                String resNum = (String)entry.getKey();
                return resNum;
            }).collect(Collectors.toList());
        }
    }

    public static class ResidueFlex
    implements Serializable {
        public final String wildType;
        public VoxelShape voxelShape;
        public Set<String> resTypes;
        public boolean addWildTypeRotamers;

        protected ResidueFlex(String wildType2) {
            this.wildType = wildType2;
            this.resTypes = new LinkedHashSet<String>();
            this.setDiscrete();
            this.setNoRotamers();
        }

        public boolean isFlexible() {
            return !this.resTypes.isEmpty() || this.addWildTypeRotamers;
        }

        public boolean isMutable() {
            Set<String> allResTypes = this.getAllResTypes();
            return allResTypes.size() >= 2 || allResTypes.size() == 1 && !allResTypes.iterator().next().equals(this.wildType);
        }

        public Set<String> getAllResTypes() {
            LinkedHashSet<String> out = new LinkedHashSet<String>(this.resTypes);
            if (this.addWildTypeRotamers) {
                out.add(this.wildType);
            }
            return out;
        }

        public ResidueFlex setNoRotamers() {
            this.resTypes.clear();
            this.addWildTypeRotamers = false;
            return this;
        }

        public ResidueFlex addWildTypeRotamers() {
            this.addWildTypeRotamers = true;
            return this;
        }

        public ResidueFlex setLibraryRotamers(String ... resTypes) {
            if (resTypes.length == 0) {
                return this.setLibraryRotamers(Collections.singletonList(this.wildType));
            }
            return this.setLibraryRotamers(Arrays.asList(resTypes));
        }

        public ResidueFlex setLibraryRotamers(List<String> resTypes) {
            this.resTypes.clear();
            if (resTypes.isEmpty()) {
                throw new IllegalArgumentException("no residue types chosen");
            }
            for (String resType : resTypes) {
                if (resType.equalsIgnoreCase(Strand.WildType)) {
                    resType = this.wildType;
                }
                this.resTypes.add(resType);
            }
            return this;
        }

        public ResidueFlex setDiscrete() {
            return this.setVoxelShape(new VoxelShape.Point());
        }

        public ResidueFlex setContinuous() {
            return this.setVoxelShape(new VoxelShape.Rect());
        }

        public ResidueFlex setContinuous(double voxelHalfWidth) {
            return this.setVoxelShape(new VoxelShape.Rect(voxelHalfWidth));
        }

        public ResidueFlex setVoxelShape(VoxelShape voxelShape) {
            this.voxelShape = voxelShape;
            return this;
        }
    }

    public static class Builder {
        private Molecule mol;
        private String firstResNum;
        private String lastResNum;
        private List<MutabilityParam> mutabilityParams = new ArrayList<MutabilityParam>();
        private ResidueTemplateLibrary templateLib;
        private boolean errorOnNonTemplateResidues;
        private Residue.TemplateMatchingMethod templateMatchingMethod = Residue.TemplateMatchingMethod.BondDistances;

        public Builder(Molecule mol) {
            this.mol = mol;
            this.firstResNum = ((Residue)mol.residues.get(0)).getPDBResNumber();
            this.lastResNum = ((Residue)mol.residues.get(mol.residues.size() - 1)).getPDBResNumber();
            this.templateLib = null;
            this.errorOnNonTemplateResidues = false;
        }

        @Deprecated
        public Builder setResidues(int firstResNum, int lastResNum) {
            return this.setResidues(Strand.stringResNumForMolec(firstResNum, this.mol), Strand.stringResNumForMolec(lastResNum, this.mol));
        }

        public Builder setResidues(String firstResNum, String lastResNum) {
            this.firstResNum = firstResNum;
            this.lastResNum = lastResNum;
            return this;
        }

        @Deprecated
        public Builder setResidues(ResidueTermini termini) {
            if (termini != null) {
                return this.setResidues(termini.lBound, termini.uBound);
            }
            return this;
        }

        public Builder setTemplateLibrary(ResidueTemplateLibrary val) {
            this.templateLib = val;
            return this;
        }

        public Builder setResidueMutability(String residue, List<String> targetResidues, boolean useWildTypeRotamer, boolean continuous) {
            if (targetResidues.isEmpty()) {
                targetResidues = List.of(Strand.WildType);
            }
            this.mutabilityParams.add(new MutabilityParam(residue, useWildTypeRotamer, continuous, targetResidues));
            return this;
        }

        public Builder setErrorOnNonTemplateResidues(boolean val) {
            this.errorOnNonTemplateResidues = val;
            return this;
        }

        public Builder setTemplateMatchingMethod(Residue.TemplateMatchingMethod val) {
            this.templateMatchingMethod = val;
            return this;
        }

        public Strand build() {
            if (this.templateLib == null) {
                this.templateLib = new ResidueTemplateLibrary.Builder().build();
            }
            Strand strand = new Strand(this.mol, this.firstResNum, this.lastResNum, this.templateLib, this.errorOnNonTemplateResidues, this.templateMatchingMethod);
            for (MutabilityParam param : this.mutabilityParams) {
                ResidueFlex residue = strand.flexibility.get(param.residue);
                if (residue == null) {
                    throw new Error(String.format("Trying to modify a residue that I can't find: %s", param.residue));
                }
                param.modifyResidue(residue);
            }
            return strand;
        }

        private static class MutabilityParam {
            List<String> targetResidues;
            protected String residue;
            boolean useWildtypeRotamer;
            boolean useContinuousFlexibility;

            MutabilityParam(String residue, boolean useWildTypeRotamer, boolean useContinuousFlexiblity, List<String> targetResidues) {
                this.residue = residue;
                this.useWildtypeRotamer = useWildTypeRotamer;
                this.useContinuousFlexibility = useContinuousFlexiblity;
                this.targetResidues = targetResidues;
            }

            void modifyResidue(ResidueFlex residueFlex) {
                residueFlex.addWildTypeRotamers = this.useWildtypeRotamer;
                if (this.useContinuousFlexibility) {
                    residueFlex.setContinuous();
                } else {
                    residueFlex.setDiscrete();
                }
                residueFlex.setLibraryRotamers(this.targetResidues);
            }
        }
    }
}

