/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import java.util.ArrayList;
import java.util.List;

public class TripleMatrix<T> {
    public final int numPos;
    public final int[] numConfByPos;
    private final List<T> triples;
    private final int[] offsets;
    private int count;

    public TripleMatrix(int numPos, int[] numConfByPos) {
        this.numPos = numPos;
        this.numConfByPos = numConfByPos;
        this.offsets = new int[numPos * (numPos - 1) * (numPos - 2) / 6];
        int tripleoi = 0;
        int triplei = 0;
        for (int pos1 = 2; pos1 < numPos; ++pos1) {
            for (int pos2 = 1; pos2 < pos1; ++pos2) {
                for (int pos3 = 0; pos3 < pos2; ++pos3) {
                    this.offsets[tripleoi++] = triplei;
                    triplei += numConfByPos[pos1] * numConfByPos[pos2] * numConfByPos[pos3];
                }
            }
        }
        this.triples = new ArrayList<T>(triplei);
        for (int i = 0; i < triplei; ++i) {
            this.triples.add(null);
        }
        this.count = 0;
    }

    public TripleMatrix(ConfSpaceIteration confSpace) {
        this(confSpace.numPos(), confSpace.numConfsByPos());
    }

    public int size() {
        return this.triples.size();
    }

    public int count() {
        return this.count;
    }

    public void fill(T val) {
        for (int i = 0; i < this.triples.size(); ++i) {
            this.triples.set(i, val);
        }
        this.count = val == null ? 0 : this.triples.size();
    }

    public int index(int posi1, int posi2, int posi3) {
        int swap;
        if (posi2 > posi1) {
            swap = posi1;
            posi1 = posi2;
            posi2 = swap;
        } else if (posi1 == posi2) {
            throw new Error("Can't pair design position " + posi1 + " with itself");
        }
        if (posi3 > posi2) {
            swap = posi2;
            posi2 = posi3;
            posi3 = swap;
        } else if (posi2 == posi3) {
            throw new Error("Can't pair design position " + posi2 + " with itself");
        }
        if (posi2 > posi1) {
            swap = posi1;
            posi1 = posi2;
            posi2 = swap;
        } else if (posi1 == posi2) {
            throw new Error("Can't pair design position " + posi1 + " with itself");
        }
        return posi1 * (posi1 - 1) * (posi1 - 2) / 6 + posi2 * (posi2 - 1) / 2 + posi3;
    }

    public int index(int posi1, int confi1, int posi2, int confi2, int posi3, int confi3) {
        int swap;
        if (posi2 > posi1) {
            swap = posi1;
            posi1 = posi2;
            posi2 = swap;
            swap = confi1;
            confi1 = confi2;
            confi2 = swap;
        } else if (posi1 == posi2) {
            throw new Error("Can't pair design position " + posi1 + " with itself");
        }
        if (posi3 > posi2) {
            swap = posi2;
            posi2 = posi3;
            posi3 = swap;
            swap = confi2;
            confi2 = confi3;
            confi3 = swap;
        } else if (posi2 == posi3) {
            throw new Error("Can't pair design position " + posi2 + " with itself");
        }
        if (posi2 > posi1) {
            swap = posi1;
            posi1 = posi2;
            posi2 = swap;
            swap = confi1;
            confi1 = confi2;
            confi2 = swap;
        } else if (posi1 == posi2) {
            throw new Error("Can't pair design position " + posi1 + " with itself");
        }
        return this.offsets[posi1 * (posi1 - 1) * (posi1 - 2) / 6 + posi2 * (posi2 - 1) / 2 + posi3] + this.numConfByPos[posi3] * this.numConfByPos[posi2] * confi1 + this.numConfByPos[posi3] * confi2 + confi3;
    }

    public void set(int posi1, int confi1, int posi2, int confi2, int posi3, int confi3, T val) {
        T oldVal = this.triples.set(this.index(posi1, confi1, posi2, confi2, posi3, confi3), val);
        if (oldVal == null && val != null) {
            ++this.count;
        } else if (oldVal != null && val == null) {
            --this.count;
        }
    }

    public T get(int posi1, int confi1, int posi2, int confi2, int posi3, int confi3) {
        return this.triples.get(this.index(posi1, confi1, posi2, confi2, posi3, confi3));
    }
}

