/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupleMatrixGeneric;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class TuplesIndex
implements Iterable<RCTuple> {
    public final SimpleConfSpace confSpace;
    private final List<RCTuple> tuples;
    private final TupleMatrixGeneric<Integer> index;

    public TuplesIndex(SimpleConfSpace confSpace, RCTuple[] tuples) {
        this(confSpace);
        for (RCTuple tuple : tuples) {
            this.appendTuple(tuple);
        }
    }

    public TuplesIndex(SimpleConfSpace confSpace) {
        this.confSpace = confSpace;
        this.tuples = new ArrayList<RCTuple>();
        this.index = new TupleMatrixGeneric(confSpace);
        this.index.fill((Integer)null);
    }

    public int appendTuple(RCTuple tuple) {
        if (this.contains(tuple)) {
            throw new IllegalArgumentException("can't add the same tuple more than once: " + String.valueOf(tuple));
        }
        int i = this.tuples.size();
        this.tuples.add(tuple);
        this.index.setTuple(tuple, i);
        return i;
    }

    @Override
    public Iterator<RCTuple> iterator() {
        return new Iterator<RCTuple>(){
            Iterator<RCTuple> iter;
            {
                this.iter = TuplesIndex.this.tuples.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public RCTuple next() {
                return this.iter.next();
            }
        };
    }

    public RCTuple get(int index) {
        return this.tuples.get(index);
    }

    public int size() {
        return this.tuples.size();
    }

    public Integer getIndex(int pos1, int rc1) {
        return this.index.getOneBody(pos1, rc1);
    }

    public Integer getIndex(int pos1, int rc1, int pos2, int rc2) {
        return this.index.getPairwise(pos1, rc1, pos2, rc2);
    }

    public Integer getIndex(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        return this.getIndex(new RCTuple(pos1, rc1, pos2, rc2, pos3, rc3).sorted());
    }

    public Integer getIndex(RCTuple tuple) {
        return (Integer)this.index.getTuple(tuple);
    }

    public boolean contains(int pos1, int rc1) {
        return this.getIndex(pos1, rc1) != null;
    }

    public boolean contains(int pos1, int rc1, int pos2, int rc2) {
        return this.getIndex(pos1, rc1, pos2, rc2) != null;
    }

    public boolean contains(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        return this.getIndex(new RCTuple(pos1, rc1, pos2, rc2, pos3, rc3).sorted()) != null;
    }

    public boolean contains(RCTuple tuple) {
        return this.getIndex(tuple) != null;
    }

    public boolean isAssignmentCoveredByPairs(int[] conf, int nextPos, int nextRC) {
        for (int pos = 0; pos < conf.length; ++pos) {
            int rc = conf[pos];
            if (rc == -1) continue;
            if (pos == nextPos) {
                throw new IllegalArgumentException(String.format("pos %d already assigned in conf %s", nextPos, Conf.toString(conf)));
            }
            if (this.contains(pos, rc, nextPos, nextRC)) continue;
            return false;
        }
        return true;
    }

    public void forEachIn(int[] conf, boolean throwIfMissingSingle, boolean throwIfMissingPair, Consumer<Integer> callback) {
        int numPos = this.confSpace.positions.size();
        for (int pos1 = 0; pos1 < numPos; ++pos1) {
            int rc1 = conf[pos1];
            if (rc1 == -1) continue;
            Integer t = this.index.getOneBody(pos1, rc1);
            if (t != null) {
                callback.accept(t);
            } else if (throwIfMissingSingle) {
                throw new NoSuchTupleException(new RCTuple(pos1, rc1), conf);
            }
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                int rc2 = conf[pos2];
                if (rc2 == -1) continue;
                t = this.index.getPairwise(pos1, rc1, pos2, rc2);
                if (t != null) {
                    callback.accept(t);
                    continue;
                }
                if (!throwIfMissingPair) continue;
                throw new NoSuchTupleException(new RCTuple(pos1, rc1, pos2, rc2), conf);
            }
        }
        this.index.forEachHigherOrderTupleIn(conf, (tuple, index) -> callback.accept((Integer)index));
    }

    public static class NoSuchTupleException
    extends RuntimeException {
        public NoSuchTupleException(RCTuple tuple, int[] conf) {
            super("no tuple found matching " + String.valueOf(tuple) + " from conf " + Conf.toString(conf));
        }
    }
}

