/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.ConfPrinter;
import edu.duke.cs.osprey.control.ConfigFileParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class ConfInfo {
    ConfigFileParser cfp;
    int numRes;
    boolean outputPDBs;
    int numConfsToOutput;
    boolean doFullOutput;
    String outputConfFileName;

    public ConfInfo(ConfigFileParser cfp) {
        this.cfp = cfp;
        this.numRes = cfp.getFlexRes().size();
        this.outputPDBs = cfp.params.getBool("outputPDBs");
        this.numConfsToOutput = cfp.params.getInt("NumConfsToOutput");
        this.doFullOutput = cfp.params.getBool("doFullOutput");
        this.outputConfFileName = cfp.params.getRunSpecificFileName("OutputConfFileName", ".outputconfs.txt");
    }

    public void outputConfInfo() {
        String confFileName = this.cfp.params.getRunSpecificFileName("CONFFILENAME", ".confs.txt");
        try (BufferedReader br = new BufferedReader(new FileReader(confFileName));){
            SearchProblem searchProb = this.cfp.getSearchProblem();
            if (searchProb.useERef || this.doFullOutput) {
                searchProb.loadEnergyMatrix();
            }
            System.out.println("OUTPUTTING CONF INFO...");
            ConfPrinter confPrinter = null;
            if (this.outputPDBs) {
                this.setupPDBDir();
            }
            if (this.doFullOutput) {
                confPrinter = new ConfPrinter(searchProb, this.outputConfFileName, false);
            }
            double bestESoFar = Double.POSITIVE_INFINITY;
            for (int confCount = 0; confCount < this.numConfsToOutput; ++confCount) {
                String confLine = br.readLine();
                int[] conf = this.parseConfLine(confLine);
                double confE = searchProb.minimizedEnergy(conf);
                bestESoFar = Math.min(confE, bestESoFar);
                if (this.doFullOutput) {
                    ConfSearch.EnergiedConf econf = new ConfSearch.EnergiedConf(conf, searchProb.lowerBound(conf), confE);
                    confPrinter.printConf(econf);
                    System.out.println("ENUMERATING CONFORMATION:");
                    System.out.print(confPrinter.getConfReport(econf));
                } else {
                    System.out.println("Conf " + confCount + " energy: " + confE);
                }
                if (!this.outputPDBs) continue;
                searchProb.outputMinimizedStruct(conf, "pdbs/" + searchProb.name + ".STRUCT" + confCount + ".pdb");
            }
            if (this.doFullOutput) {
                confPrinter.closeConfFile();
            }
            System.out.println("DONE OUTPUTTING CONF INFO.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void setupPDBDir() {
        File pdbsHandle = new File("pdbs");
        if (!pdbsHandle.isDirectory()) {
            if (pdbsHandle.exists()) {
                throw new RuntimeException("ERROR: Can't create pdbs directory (there is already a file called pdbs)");
            }
            pdbsHandle.mkdir();
        }
    }

    int[] parseConfLine(String confLine) {
        if (confLine == null) {
            throw new RuntimeException("ERROR: Conformation file ends prematurely");
        }
        StringTokenizer st = new StringTokenizer(confLine, " ");
        if (st.countTokens() < this.numRes + 2) {
            throw this.confLineException(confLine);
        }
        st.nextToken();
        if (!st.nextToken().equalsIgnoreCase("CONF:")) {
            throw this.confLineException(confLine);
        }
        int[] ans = new int[this.numRes];
        try {
            for (int res = 0; res < this.numRes; ++res) {
                ans[res] = Integer.valueOf(st.nextToken());
            }
        }
        catch (NumberFormatException e) {
            throw this.confLineException(confLine);
        }
        return ans;
    }

    RuntimeException confLineException(String confLine) {
        throw new RuntimeException("ERROR: Expected conformation file line in format 'conf_num CONF: rc_number1 ... rc_number" + this.numRes + " ...' but found this: " + confLine);
    }
}

