/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.analysis;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.design.analysis.CommandAnalysis;
import edu.duke.cs.osprey.design.analysis.EnergiedConfQueue;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.ResidueForcefieldBreakdown;
import edu.duke.cs.osprey.gmec.ConfAnalyzer;
import java.util.Collections;
import java.util.List;

public class EnergyAnalysisConfListener
implements CommandAnalysis {
    private final ConfEnergyCalculator eCalc;
    private final List<Integer> indices;
    private final EnergiedConfQueue confQueue;

    public EnergyAnalysisConfListener(ConfEnergyCalculator eCalc, List<Integer> indicesToAnalyze) {
        this.eCalc = eCalc;
        this.indices = indicesToAnalyze;
        this.confQueue = new EnergiedConfQueue(Collections.max(indicesToAnalyze));
    }

    @Override
    public void onConf(ConfSearch.ScoredConf conf) {
        ConfSearch.EnergiedConf eConf = (ConfSearch.EnergiedConf)conf;
        this.confQueue.add(eConf);
    }

    ConfAnalyzer.ConfAnalysis analyzeConf(List<ConfSearch.EnergiedConf> sortedConfs, int idx) {
        ConfAnalyzer analyzer = new ConfAnalyzer(this.eCalc);
        return analyzer.analyze(sortedConfs.get(idx - 1));
    }

    @Override
    public void printResults() {
        System.out.println("Energy analysis follows:\n");
        List<ConfSearch.EnergiedConf> sortedConfs = this.confQueue.toOrderedList();
        for (Integer idx : this.indices) {
            ConfAnalyzer.ConfAnalysis analysis = this.analyzeConf(sortedConfs, idx);
            System.out.println(String.format("Energy Analysis of %d sequence", idx + 1));
            System.out.println(String.valueOf(analysis) + "\n");
            System.out.println(String.format("Forcefield breakdown: \n%s\n", analysis.breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type.All)));
            System.out.println(String.format("Electrostatic breakdown: \n%s\n", analysis.breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type.Electrostatics)));
            System.out.println(String.format("van der Waals breakdown: \n%s\n", analysis.breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type.VanDerWaals)));
            System.out.println(String.format("Solvation breakdown: \n%s\n", analysis.breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type.Solvation)));
            System.out.println(String.format("Offsets breakdown: \n%s\n", analysis.breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type.Offsets)));
        }
    }
}

