/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.analysis;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.design.analysis.CommandAnalysis;
import edu.duke.cs.osprey.design.analysis.EnergiedConfQueue;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.ConfAnalyzer;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;

public class EnsembleAnalysisListener
implements CommandAnalysis {
    private final ConfEnergyCalculator eCalc;
    private final String outputDir;
    private final EnergiedConfQueue confs;

    public EnsembleAnalysisListener(ConfEnergyCalculator eCalc, int maxConfs, String outputDir) {
        this.eCalc = eCalc;
        this.outputDir = Paths.get(outputDir, new String[0]).toAbsolutePath().toString();
        this.confs = new EnergiedConfQueue(maxConfs);
    }

    @Override
    public void printResults() {
        String path2 = String.format("%s%s%s", this.outputDir, File.separator, "conf-*.pdb");
        System.out.println(String.format("Writing ensemble out to %s", path2));
        List<ConfSearch.EnergiedConf> lst = this.confs.toOrderedList();
        ConfAnalyzer.EnsembleAnalysis analysis = new ConfAnalyzer(this.eCalc).analyzeEnsemble(lst.iterator(), lst.size());
        analysis.writePdbs(path2);
    }

    @Override
    public void onConf(ConfSearch.ScoredConf conf) {
        ConfSearch.EnergiedConf eConf = (ConfSearch.EnergiedConf)conf;
        this.confs.add(eConf);
    }
}

