/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ParametricMolecule;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.design.commands.DelegatingCommand;
import edu.duke.cs.osprey.design.models.MoleculeDesign;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gmec.SimpleGMECFinder;
import edu.duke.cs.osprey.structure.PDBIO;
import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;

@Parameters(commandDescription="Find the GMEC of the conformation space")
public class CommandGMEC
extends DelegatingCommand {
    public static final String CommandName = "gmec";
    static final String CommandDescription = "Find the GMEC of the conformation space";

    @Override
    public int run(JCommander commander, String[] args) {
        Optional<Integer> retVal = this.processHelpAndNoArgs(commander, args);
        if (retVal.isPresent()) {
            return retVal.get();
        }
        Optional<MoleculeDesign> designOpt = this.parseDesignSpec(MoleculeDesign.class);
        if (designOpt.isEmpty()) {
            return 1;
        }
        return this.runGMEC(designOpt.get());
    }

    @Override
    public String getCommandName() {
        return CommandName;
    }

    @Override
    public String getCommandDescription() {
        return CommandDescription;
    }

    private int runGMEC(MoleculeDesign design) {
        ForcefieldParams ffParams = new ForcefieldParams();
        SimpleConfSpace confSpace = this.delegate.createConfSpace(design.molecule, ffParams);
        EnergyCalculator eCalc = new EnergyCalculator.Builder(confSpace, ffParams).setParallelism(this.delegate.getParallelism()).build();
        ConfEnergyCalculator confEnergyCalc = new ConfEnergyCalculator.Builder(confSpace, eCalc).build();
        EnergyMatrix emat = new SimplerEnergyMatrixCalculator.Builder(confEnergyCalc).build().calcEnergyMatrix();
        ConfAStarTree astar = new ConfAStarTree.Builder(emat, confSpace).setMPLP().build();
        ConfSearch.EnergiedConf gmec = new SimpleGMECFinder.Builder(astar, confEnergyCalc).build().find();
        ParametricMolecule structure = confSpace.makeMolecule(gmec.getAssignments());
        if (this.delegate.ensembleDir != null) {
            File outFile = Paths.get(this.delegate.ensembleDir, "gmec.pdb").toFile();
            PDBIO.writeFile(structure.mol, "GMEC structure", (Double)gmec.getEnergy(), outFile);
        }
        return 0;
    }
}

