/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.io;

import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.PosInterDist;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.PosInterGen;
import edu.duke.cs.osprey.kstar.NewKStar;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import edu.duke.cs.osprey.structure.PDBIO;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class ScoredSequenceEnsembleWriter
implements NewKStar.SequenceComputedListener {
    private final int ensembleSize;
    private final String outputDir;
    private final SimpleReferenceEnergies refEnergiesComplex;
    private final ConfEnergyCalculator ecalc;
    private final ConfSpace confSpaceComplex;

    public ScoredSequenceEnsembleWriter(int ensembleSize, String outputDir, SimpleReferenceEnergies refEnergiesComplex, ConfEnergyCalculator ecalc, ConfSpace confSpaceComplex) {
        this.ensembleSize = ensembleSize;
        this.outputDir = outputDir;
        this.refEnergiesComplex = refEnergiesComplex;
        this.ecalc = ecalc;
        this.confSpaceComplex = confSpaceComplex;
    }

    @Override
    public void onSequence(NewKStar kstar, ScoredSequence seq) {
        try (ConfDB confDb = new ConfDB(kstar.complex.confSpace, kstar.complex.confDBFile);){
            Iterator<ConfSearch.EnergiedConf> iterator2 = confDb.getSequence(seq.sequence()).energiedConfs(ConfDB.SortOrder.Energy).iterator();
            ArrayList<ConfEnergyCalculator.EnergiedCoords> coords = new ArrayList<ConfEnergyCalculator.EnergiedCoords>();
            for (int i = 0; i < this.ensembleSize && iterator2.hasNext(); ++i) {
                ConfSearch.EnergiedConf energiedConf = iterator2.next();
                int[] assignments = energiedConf.getAssignments();
                PosInterGen posInterGen = new PosInterGen(PosInterDist.DesmetEtAl1992, this.refEnergiesComplex);
                ConfEnergyCalculator.EnergiedCoords energiedCoords = this.ecalc.minimize(assignments, posInterGen.all(this.confSpaceComplex, assignments));
                coords.add(energiedCoords);
            }
            String seqStr = seq.sequence().toString(Sequence.Renderer.AssignmentMutations);
            String comment = String.format("Ensemble of %d conformations for:\n\t   State  %s\n\tSequence  [%s]", coords.size(), this.confSpaceComplex.name, seqStr);
            String safeSeqStr = seqStr.replace(' ', '-');
            File ensembleFile = new File(this.outputDir, String.format("seq.%s.pdb", safeSeqStr));
            PDBIO.writeFileEcoords(coords, ensembleFile, comment);
        }
    }
}

