/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import edu.duke.cs.osprey.design.models.MoleculeDto;
import edu.duke.cs.osprey.design.models.ScanDto;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class AffinityDesign {
    @JsonProperty(value="osprey_version")
    public String ospreyVersion = "3.1.0";
    @JsonProperty(value="design_name")
    public String designName = "default-design";
    @JsonProperty(value="protein")
    public MoleculeDto protein;
    @JsonProperty(value="ligand")
    public MoleculeDto ligand;
    @JsonProperty(value="scan")
    public ScanDto scanSettings;
    private static final YAMLFactory factory = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE);

    public static AffinityDesign parse(File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        FileInputStream stream = new FileInputStream(file);
        return (AffinityDesign)mapper.readValue((InputStream)stream, AffinityDesign.class);
    }

    public void write(OutputStream stream) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.writeValue(stream, (Object)this);
    }

    public void write(Path dest) throws IOException {
        FileOutputStream stream = new FileOutputStream(dest.toFile());
        this.write(stream);
    }

    public AffinityDesign copy() {
        ObjectMapper om = new ObjectMapper();
        try {
            return (AffinityDesign)om.readValue(om.writeValueAsString((Object)this), this.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.ligand == null || this.protein == null) {
            errors.add("The this must have both a protein and ligand specified");
            return errors;
        }
        if (this.protein.coordinates.isEmpty()) {
            errors.add("You must specify PDB coordinates for the protein");
        }
        if (this.ligand.coordinates.isEmpty()) {
            errors.add("You must specify PDB coordinates for the ligand");
        }
        return errors;
    }

    public Molecule makeProteinMolecule() {
        return PDBIO.read(this.protein.coordinates);
    }

    public Molecule makeLigandMolecule() {
        return PDBIO.read(this.ligand.coordinates);
    }
}

