/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.StrandRotation;
import edu.duke.cs.osprey.dof.StrandTranslation;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.RotationMatrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;

public class MoveableStrand
implements Serializable,
DOFBlock {
    ArrayList<Residue> res;
    StrandTranslation[] translations;
    StrandRotation[] rotations;
    double[] initCenter;
    double[] curTrans;
    RotationMatrix curRotMatrix;
    double[] curAngles;
    public static final double maxStrandRot = 5.0;
    public static final double maxStrandTrans = 1.2;

    public MoveableStrand() {
    }

    public MoveableStrand(ArrayList<Residue> res) {
        this.res = res;
        this.translations = new StrandTranslation[3];
        this.rotations = new StrandRotation[3];
        for (int coord = 0; coord < 3; ++coord) {
            this.translations[coord] = new StrandTranslation(this, coord);
            this.rotations[coord] = new StrandRotation(this, coord);
        }
        this.initCenter = this.strandCOM();
        this.curTrans = new double[3];
        this.curRotMatrix = RotationMatrix.identity();
        this.curAngles = new double[3];
    }

    void updateRotMatrixFromAngles() {
        RotationMatrix rot1 = new RotationMatrix(1.0, 0.0, 0.0, this.curAngles[0], false);
        RotationMatrix rot2 = new RotationMatrix(0.0, 1.0, 0.0, this.curAngles[1], false);
        RotationMatrix rot3 = new RotationMatrix(0.0, 0.0, 1.0, this.curAngles[2], false);
        this.curRotMatrix = rot3.multiply(rot2.multiply(rot1));
    }

    private double[] strandCOM() {
        double[] com = new double[3];
        int numAtoms = 0;
        for (Residue curRes : this.res) {
            int resNumAtoms = curRes.atoms.size();
            numAtoms += resNumAtoms;
            for (int atomNum = 0; atomNum < resNumAtoms; ++atomNum) {
                for (int a = 0; a < 3; ++a) {
                    int n = a;
                    com[n] = com[n] + curRes.coords[3 * atomNum + a];
                }
            }
        }
        int a = 0;
        while (a < 3) {
            int n = a++;
            com[n] = com[n] / (double)numAtoms;
        }
        return com;
    }

    public ArrayList<DegreeOfFreedom> getDOFs() {
        ArrayList<DegreeOfFreedom> ans = new ArrayList<DegreeOfFreedom>();
        ans.addAll(Arrays.asList(this.rotations));
        ans.addAll(Arrays.asList(this.translations));
        return ans;
    }

    public ArrayList<Residue> getResidues() {
        return this.res;
    }

    public static double[] getStrandDOFBounds(DegreeOfFreedom strandDOF) {
        if (strandDOF instanceof StrandRotation) {
            return new double[]{-5.0, 5.0};
        }
        if (strandDOF instanceof StrandTranslation) {
            return new double[]{-1.2, 1.2};
        }
        throw new RuntimeException("ERROR: Not a strand DOF");
    }

    @Override
    public DOFBlock copyForNewMolecule(Molecule mol, LinkedHashMap<DegreeOfFreedom, DegreeOfFreedom> copiedDOFMap) {
        MoveableStrand copiedStrand = new MoveableStrand();
        copiedStrand.res = new ArrayList();
        for (Residue curRes : this.res) {
            copiedStrand.res.add(mol.getResByPDBResNumber(curRes.getPDBResNumber()));
        }
        copiedStrand.translations = new StrandTranslation[3];
        copiedStrand.rotations = new StrandRotation[3];
        for (int coord = 0; coord < 3; ++coord) {
            copiedStrand.translations[coord] = new StrandTranslation(copiedStrand, coord);
            copiedStrand.rotations[coord] = new StrandRotation(copiedStrand, coord);
            copiedDOFMap.put(this.translations[coord], copiedStrand.translations[coord]);
            copiedDOFMap.put(this.rotations[coord], copiedStrand.rotations[coord]);
            copiedStrand.translations[coord].curVal = this.translations[coord].curVal;
            copiedStrand.rotations[coord].curVal = this.rotations[coord].curVal;
        }
        copiedStrand.initCenter = this.initCenter;
        copiedStrand.curTrans = (double[])this.curTrans.clone();
        copiedStrand.curRotMatrix = this.curRotMatrix.copy();
        copiedStrand.curAngles = (double[])this.curAngles.clone();
        return copiedStrand;
    }
}

