/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.InterResBondingTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MutAlignment {
    ResidueTemplate oldTemplate;
    ResidueTemplate newTemplate;
    TreeSet<String> nonmovingAtomNames;
    int[][] mutAlignmentAtoms;

    public MutAlignment(ResidueTemplate oldTemplate, ResidueTemplate newTemplate) {
        this.oldTemplate = oldTemplate;
        this.newTemplate = newTemplate;
        String curCA = oldTemplate.CAEquivalent;
        if (curCA == null || newTemplate.CAEquivalent == null) {
            throw new RuntimeException("ERROR: Trying to align templates " + oldTemplate.name + " and " + newTemplate.name + " for mutation but CAEQUIVALENT not specified in template and cannot be inferred");
        }
        if (!newTemplate.CAEquivalent.equalsIgnoreCase(curCA)) {
            throw this.makeError("sidechains are defined differently: CA equivalent is " + curCA + " for old template, " + newTemplate.CAEquivalent + " for new");
        }
        if (curCA == null) {
            throw this.makeError("sidechain undefined (CAEquivalent==null)");
        }
        if (newTemplate.templateRes.coords == null) {
            throw this.makeError("new template has no coordinates");
        }
        this.checkInterResBondingMatch();
        if (oldTemplate.name.equalsIgnoreCase("PRO") || newTemplate.name.equalsIgnoreCase("PRO") || oldTemplate.name.equalsIgnoreCase("CYX") || newTemplate.name.equalsIgnoreCase("CYX")) {
            this.initStdAAAlignment();
            return;
        }
        this.matchAtoms();
        this.handlePeptideTermini();
        this.checkCAValidity(curCA);
        ArrayList<String> matchedSCAtoms = new ArrayList<String>();
        for (String at : this.nonmovingAtomNames) {
            if (this.getOldTemplateAtom(at) == null || this.getNewTemplateAtom(at) == null || !this.isMoreSidechainward(at, curCA, true) || !this.isMoreSidechainward(at, curCA, false)) continue;
            matchedSCAtoms.add(at);
        }
        this.nonmovingAtomNames.removeAll(matchedSCAtoms);
        if (curCA.equalsIgnoreCase("CA") && this.nonmovingAtomNames.contains("N") && this.nonmovingAtomNames.contains("C")) {
            this.initStdAAAlignment();
            return;
        }
        String N = this.pickRefFrameAtom(curCA, null);
        String C = this.pickRefFrameAtom(curCA, N);
        String[] refFrameAtoms = new String[]{curCA, N, C};
        this.mutAlignmentAtoms = new int[2][3];
        for (int a = 0; a < 3; ++a) {
            this.mutAlignmentAtoms[0][a] = oldTemplate.templateRes.getAtomIndexByName(refFrameAtoms[a]);
            this.mutAlignmentAtoms[1][a] = newTemplate.templateRes.getAtomIndexByName(refFrameAtoms[a]);
        }
    }

    private boolean newTemplateHasAtom(String name) {
        Atom oldTemplateAtom = this.getOldTemplateAtom(name);
        Atom newTemplateAtom = this.getNewTemplateAtom(name);
        if (newTemplateAtom == null) {
            return false;
        }
        if (newTemplateAtom.elementNumber != oldTemplateAtom.elementNumber) {
            return false;
        }
        Predicate<String> nm = a -> this.nonmovingAtomNames.contains(a);
        Set oldNonMovingBonds = oldTemplateAtom.bonds.stream().map(b -> b.name).filter(nm).collect(Collectors.toSet());
        Set newNonMovingBonds = newTemplateAtom.bonds.stream().map(b -> b.name).filter(nm).collect(Collectors.toSet());
        for (String bondedName : oldNonMovingBonds) {
            if (newNonMovingBonds.contains(bondedName)) continue;
            return false;
        }
        for (String bondedName : newNonMovingBonds) {
            if (oldNonMovingBonds.contains(bondedName)) continue;
            return false;
        }
        return true;
    }

    private void matchAtoms() {
        this.nonmovingAtomNames = new TreeSet();
        for (Atom at : this.oldTemplate.templateRes.atoms) {
            if (!this.oldTemplate.interResBonding.atomCanBondOtherRes(at)) continue;
            if (this.newTemplateHasAtom(at.name)) {
                this.nonmovingAtomNames.add(at.name);
                continue;
            }
            throw this.makeError("atom " + at.name + " bonded to other residue but changes in mutation");
        }
        if (this.nonmovingAtomNames.isEmpty()) {
            for (Atom at : this.oldTemplate.templateRes.atoms) {
                if (!this.newTemplateHasAtom(at.name)) continue;
                this.nonmovingAtomNames.add(at.name);
                break;
            }
        }
        if (this.nonmovingAtomNames.isEmpty()) {
            throw new RuntimeException("ERROR: Can't mutate " + this.oldTemplate.name + " to " + this.newTemplate.name + " because they have no atoms in common");
        }
        while (true) {
            Atom nextAtom = null;
            for (String prevMatchedAtom : this.nonmovingAtomNames) {
                for (Atom at2 : this.getOldTemplateAtom((String)prevMatchedAtom).bonds) {
                    if (!this.newTemplateHasAtom(at2.name) || this.nonmovingAtomNames.contains(at2.name)) continue;
                    nextAtom = at2;
                    break;
                }
                if (nextAtom == null) continue;
                break;
            }
            if (nextAtom == null) break;
            this.nonmovingAtomNames.add(nextAtom.name);
        }
    }

    private boolean canBeCA(String possibleCA) {
        for (Atom at : this.oldTemplate.templateRes.atoms) {
            if (this.nonmovingAtomNames.contains(at.name) || this.isMoreSidechainward(at.name, possibleCA, true)) continue;
            return false;
        }
        for (Atom at : this.newTemplate.templateRes.atoms) {
            if (this.nonmovingAtomNames.contains(at.name) || this.isMoreSidechainward(at.name, possibleCA, false)) continue;
            return false;
        }
        return true;
    }

    private boolean isMoreSidechainward(String at1, String at2, boolean useOldTemplate) {
        HashSet<String> atomsVisited = new HashSet<String>();
        atomsVisited.add(at2);
        return !this.canEscapeResNotVia(at1, atomsVisited, useOldTemplate);
    }

    private boolean canEscapeResNotVia(String atName, HashSet<String> forbidden, boolean useOldTemplate) {
        ResidueTemplate templ = useOldTemplate ? this.oldTemplate : this.newTemplate;
        Atom at = templ.templateRes.getAtomByName(atName);
        if (templ.interResBonding.atomCanBondOtherRes(at)) {
            return true;
        }
        forbidden.add(atName);
        for (Atom at2 : at.bonds) {
            if (forbidden.contains(at2.name) || !this.canEscapeResNotVia(at2.name, forbidden, useOldTemplate)) continue;
            return true;
        }
        return false;
    }

    private String pickRefFrameAtom(String CA, String N) {
        for (Atom cand : this.getOldTemplateAtom((String)CA).bonds) {
            if (!this.nonmovingAtomNames.contains(cand.name) || !this.isGoodRefFrameAtom(cand.name, CA, N)) continue;
            return cand.name;
        }
        for (String candName : this.nonmovingAtomNames) {
            if (!this.isGoodRefFrameAtom(candName, CA, N)) continue;
            return candName;
        }
        throw this.makeError("can't find 3 noncollinear unchanging (backbone) atoms to use as a frame of reference");
    }

    private boolean isGoodRefFrameAtom(String atom, String CA, String N) {
        if (!this.nonmovingAtomNames.contains(atom)) {
            return false;
        }
        if (this.getNewTemplateAtom(atom) == null || this.getOldTemplateAtom(atom) == null) {
            return false;
        }
        if (atom.equalsIgnoreCase(N) || atom.equalsIgnoreCase(CA)) {
            return false;
        }
        if (N != null) {
            ArrayList<Double> newDists = this.interAtomDistances(new String[]{atom, CA, N}, false);
            if (this.oldTemplate.templateRes.coords != null) {
                ArrayList<Double> oldDists = this.interAtomDistances(new String[]{atom, CA, N}, true);
                for (int a = 0; a < 3; ++a) {
                    if (!(Math.abs(oldDists.get(a) - newDists.get(a)) > 0.1 * Math.abs(oldDists.get(a)))) continue;
                    return false;
                }
            }
            if (Collections.max(newDists) > 0.499 * (newDists.get(0) + newDists.get(1) + newDists.get(2))) {
                return false;
            }
        }
        return true;
    }

    private Atom getOldTemplateAtom(String name) {
        return this.oldTemplate.templateRes.getAtomByName(name);
    }

    private Atom getNewTemplateAtom(String name) {
        return this.newTemplate.templateRes.getAtomByName(name);
    }

    private void initStdAAAlignment() {
        if (!HardCodedResidueInfo.hasAminoAcidBB(this.oldTemplate.templateRes) || !HardCodedResidueInfo.hasAminoAcidBB(this.newTemplate.templateRes)) {
            throw this.makeError(" can't do standard AA alignment for non-amino acids");
        }
        this.nonmovingAtomNames = new TreeSet<String>(HardCodedResidueInfo.listBBAtomsForMut(this.newTemplate, this.oldTemplate));
        this.mutAlignmentAtoms = HardCodedResidueInfo.findMutAlignmentAtoms(this.oldTemplate, this.newTemplate);
    }

    private void handlePeptideTermini() {
        if (HardCodedResidueInfo.hasAminoAcidBB(this.oldTemplate.templateRes) && HardCodedResidueInfo.hasAminoAcidBB(this.newTemplate.templateRes)) {
            Atom N = this.getOldTemplateAtom("N");
            Atom C = this.getOldTemplateAtom("C");
            if (this.oldTemplate.interResBonding.atomCanBondOtherRes(N) && this.oldTemplate.interResBonding.atomCanBondOtherRes(C)) {
                for (Atom nc : new Atom[]{N, C, this.getNewTemplateAtom("N"), this.getNewTemplateAtom("C")}) {
                    for (Atom at : nc.bonds) {
                        this.nonmovingAtomNames.add(at.name);
                    }
                }
            }
        }
    }

    private static Set<String> getBondingAtomNames(InterResBondingTemplate irb) {
        if (irb instanceof InterResBondingTemplate.SpecifiedBondingAtomsTemplate) {
            return new HashSet<String>(((InterResBondingTemplate.SpecifiedBondingAtomsTemplate)irb).getBondingAtomNames());
        }
        if (irb instanceof InterResBondingTemplate.NoBondingTemplate) {
            return new HashSet<String>();
        }
        if (irb instanceof InterResBondingTemplate.CysteineBondingTemplate) {
            return new HashSet<String>(Arrays.asList("N", "C", "SG"));
        }
        if (irb instanceof InterResBondingTemplate.PeptideBondingTemplate) {
            return new HashSet<String>(Arrays.asList("N", "C"));
        }
        throw new RuntimeException("ERROR: Unknown inter-residue bonding type");
    }

    private void checkInterResBondingMatch() {
        InterResBondingTemplate irb1 = this.oldTemplate.interResBonding;
        InterResBondingTemplate irb2 = this.newTemplate.interResBonding;
        if (irb1 instanceof InterResBondingTemplate.PeptideBondingTemplate && irb2 instanceof InterResBondingTemplate.PeptideBondingTemplate) {
            return;
        }
        Set<String> bondingAtoms1 = MutAlignment.getBondingAtomNames(irb1);
        Set<String> bondingAtoms2 = MutAlignment.getBondingAtomNames(irb2);
        for (String name : bondingAtoms1) {
            if (bondingAtoms2.contains(name)) continue;
            throw this.makeError("Only the old template has inter-residue bonding through atom " + name);
        }
        for (String name : bondingAtoms2) {
            if (bondingAtoms1.contains(name)) continue;
            throw this.makeError("Only the new template has inter-residue bonding through atom " + name);
        }
    }

    private ArrayList<Double> interAtomDistances(String[] atomNames2, boolean useOldTemplate) {
        Function<String, Atom> at = s -> useOldTemplate ? this.getOldTemplateAtom((String)s) : this.getNewTemplateAtom((String)s);
        List atoms = Arrays.asList(atomNames2).stream().map(at).collect(Collectors.toList());
        ArrayList<Double> ans = new ArrayList<Double>();
        ans.add(VectorAlgebra.distance(((Atom)atoms.get(0)).getCoords(), ((Atom)atoms.get(1)).getCoords()));
        ans.add(VectorAlgebra.distance(((Atom)atoms.get(2)).getCoords(), ((Atom)atoms.get(1)).getCoords()));
        ans.add(VectorAlgebra.distance(((Atom)atoms.get(0)).getCoords(), ((Atom)atoms.get(2)).getCoords()));
        return ans;
    }

    private boolean areThereMovingAtoms() {
        for (ResidueTemplate templ : new ResidueTemplate[]{this.oldTemplate, this.newTemplate}) {
            for (Atom at : templ.templateRes.atoms) {
                if (this.nonmovingAtomNames.contains(at.name)) continue;
                return true;
            }
        }
        return false;
    }

    private String inferCA() {
        boolean CAisCA = false;
        String curCA = null;
        for (String at : this.nonmovingAtomNames) {
            if (this.getNewTemplateAtom(at) == null || this.getOldTemplateAtom(at) == null || !this.canBeCA(at)) continue;
            if (at.equalsIgnoreCase("CA")) {
                CAisCA = true;
            }
            if (curCA == null) {
                curCA = at;
                continue;
            }
            if (!this.isMoreSidechainward(curCA, at, true) || !this.isMoreSidechainward(curCA, at, false)) continue;
            curCA = at;
        }
        if (curCA == null) {
            throw this.makeError("changing atoms are not all in a single sidechain");
        }
        return curCA;
    }

    private void checkCAValidity(String curCA) {
        if (this.getOldTemplateAtom(curCA) == null || this.getNewTemplateAtom(curCA) == null) {
            throw this.makeError("invalid CA equivalent: " + curCA + ".  Must appear in both old and new template");
        }
        if (!this.canBeCA(curCA)) {
            throw this.makeError("invalid CA equivalent: " + curCA + ".  Some changing atoms are not in the sidechain starting at it");
        }
    }

    private RuntimeException makeError(String specifMessage) {
        return new RuntimeException("ERROR: Can't mutate " + this.oldTemplate.name + " to " + this.newTemplate.name + " because " + specifMessage);
    }

    public int[][] getMutAlignmentAtoms() {
        return this.mutAlignmentAtoms;
    }

    public TreeSet<String> getNonmovingAtomNames() {
        return this.nonmovingAtomNames;
    }
}

