/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.deeper.SidechainIdealizer;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.ConfProblem;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;

public class ProlinePucker
extends DegreeOfFreedom {
    private static final long serialVersionUID = -5326286110623671996L;
    Direction basePucker;
    Direction curPucker;
    ResidueTemplateLibrary templateLib;
    Residue res;
    ConfProblem puckerProblem = null;

    @Override
    public String getName() {
        return "PROPUCKER" + this.res.getPDBResNumber();
    }

    public ProlinePucker(ResidueTemplateLibrary templateLib, Residue res) {
        this.templateLib = templateLib;
        this.res = res;
        if (res.fullName.toUpperCase().startsWith("PRO")) {
            this.basePucker = ProlinePucker.computePucker(res);
        } else {
            Residue idealPro = this.templateLib.getTemplateForMutation((String)"PRO", (Residue)res).templateRes;
            this.basePucker = ProlinePucker.computePucker(idealPro);
        }
        this.curPucker = this.basePucker;
    }

    public static Direction computePucker(Residue res) {
        double[] CA = res.getCoordsByAtomName("CA");
        double[] CB = res.getCoordsByAtomName("CB");
        double[] CG = res.getCoordsByAtomName("CG");
        double[] CD = res.getCoordsByAtomName("CD");
        double[][] dArrayArray = new double[][]{CA, CB, CG, CD};
        double chi2 = Protractor.measureDihedral(dArrayArray);
        if (chi2 > 0.0) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }

    @Override
    public void apply(double paramVal) {
        if (paramVal == 0.0) {
            this.apply(this.basePucker);
        } else if (paramVal == 1.0) {
            this.apply(this.basePucker.flip());
        } else {
            throw new RuntimeException("ERROR: Bad parameter value of proline pucker: " + paramVal);
        }
    }

    public void apply(Direction val) {
        this.curPucker = val;
        SidechainIdealizer.idealizeSidechain(this.templateLib, this.res);
    }

    public boolean ringCloseable() {
        return this.puckerProblem == null;
    }

    public void setRingCloseable(boolean closeable) {
        if (closeable && this.puckerProblem != null) {
            this.puckerProblem.removeFromRes();
            this.puckerProblem = null;
        } else if (!closeable && this.puckerProblem == null) {
            this.puckerProblem = new ConfProblem(this, this.res);
        }
    }

    public Direction getCurPucker() {
        return this.curPucker;
    }

    public Direction getBasePucker() {
        return this.basePucker;
    }

    public void setBasePucker(Direction basePucker) {
        this.basePucker = basePucker;
    }

    public void setCurPucker(Direction curPucker) {
        this.curPucker = curPucker;
    }

    @Override
    public Residue getResidue() {
        return this.res;
    }

    @Override
    public DegreeOfFreedom copy() {
        return new ProlinePucker(this.templateLib, this.res);
    }

    @Override
    public void setMolecule(Molecule val) {
        this.res = val.getResByPDBResNumber(this.res.getPDBResNumber());
    }

    @Override
    public DOFBlock getBlock() {
        return null;
    }

    public static enum Direction {
        DOWN{

            @Override
            public Direction flip() {
                return UP;
            }
        }
        ,
        UP{

            @Override
            public Direction flip() {
                return DOWN;
            }
        };


        public abstract Direction flip();
    }
}

