/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.MutAlignment;
import edu.duke.cs.osprey.dof.MutAlignmentCache;
import edu.duke.cs.osprey.dof.deeper.SidechainIdealizer;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.TreeSet;

public class ResidueTypeDOF
extends DegreeOfFreedom {
    private static final long serialVersionUID = 4285811771185813789L;
    public transient ResidueTemplateLibrary templateLib;
    private Residue res;
    private boolean idealizeSidechainAfterMutation;

    @Deprecated
    public ResidueTypeDOF(ResidueTemplateLibrary templateLib, Residue res) {
        this(templateLib, res, false);
    }

    @Deprecated
    public ResidueTypeDOF(ResidueTemplateLibrary templateLib, Residue res, boolean idealizeSidechainAfterMutation) {
        this.templateLib = templateLib;
        this.res = res;
        this.idealizeSidechainAfterMutation = idealizeSidechainAfterMutation;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.templateLib = EnvironmentVars.resTemplates;
        assert (this.templateLib != null);
    }

    public void mutateTo(String resType) {
        this.switchToTemplate(this.getLibraryTemplate(resType));
    }

    public ResidueTemplate getLibraryTemplate(String resType) {
        return this.templateLib.getTemplateForMutation(resType, this.res);
    }

    public boolean isTemplate(ResidueTemplate template) {
        return this.res.template == template;
    }

    public void switchToTemplate(ResidueTemplate newTemplate) {
        ResidueTypeDOF.switchToTemplate(this.templateLib, this.res, newTemplate, this.idealizeSidechainAfterMutation);
    }

    public static void switchToTemplate(ResidueTemplateLibrary templateLib, Residue res, ResidueTemplate newTemplate, boolean idealizeSidechainAfterMutation) {
        ResidueTypeDOF.switchToTemplate(templateLib, res, newTemplate, idealizeSidechainAfterMutation, new MutAlignmentCache(), true);
    }

    public static void switchToTemplate(ResidueTemplateLibrary templateLib, Residue res, ResidueTemplate newTemplate, boolean idealizeSidechainAfterMutation, MutAlignmentCache mutAlignmentCache, boolean reconnectInterResBonds) {
        ResidueTemplate oldTemplate = res.template;
        if (oldTemplate.CAEquivalent == null || newTemplate.CAEquivalent == null) {
            if (oldTemplate.name.equalsIgnoreCase(newTemplate.name)) {
                res.markIntraResBondsByTemplate();
                return;
            }
            throw new RuntimeException("ERROR: Trying to mutate " + oldTemplate.name + " to " + newTemplate.name + " but CAEQUIVALENT not specified in template and cannot be inferred");
        }
        res.removeInterResBonds();
        res.intraResBondsMarked = false;
        res.template = newTemplate;
        res.fullName = newTemplate.name + res.fullName.substring(3);
        MutAlignment mutAlignment = mutAlignmentCache.get(oldTemplate, newTemplate);
        int[][] mutAlignAtoms = mutAlignment.getMutAlignmentAtoms();
        double[][] oldMAACoords = ResidueTypeDOF.extractCoords(mutAlignAtoms[0], res.coords);
        double[] newCoords = (double[])newTemplate.templateRes.coords.clone();
        double[][] templateMAACords = ResidueTypeDOF.extractCoords(mutAlignAtoms[1], newCoords);
        RigidBodyMotion templMotion = new RigidBodyMotion(templateMAACords, oldMAACoords);
        templMotion.transform(newCoords);
        TreeSet<String> BBAtomNames = mutAlignment.getNonmovingAtomNames();
        for (String BBAtomName : BBAtomNames) {
            int BBAtomIndexOld = oldTemplate.templateRes.getAtomIndexByName(BBAtomName);
            int BBAtomIndexNew = newTemplate.templateRes.getAtomIndexByName(BBAtomName);
            if (BBAtomIndexOld == -1 || BBAtomIndexNew == -1) continue;
            System.arraycopy(res.coords, 3 * BBAtomIndexOld, newCoords, 3 * BBAtomIndexNew, 3);
        }
        res.coords = newCoords;
        ArrayList<Atom> newAtoms = new ArrayList<Atom>();
        for (Atom at : newTemplate.templateRes.atoms) {
            Atom newAtom = at.copy();
            newAtom.res = res;
            newAtoms.add(newAtom);
        }
        res.atoms = newAtoms;
        res.markIntraResBondsByTemplate();
        if (reconnectInterResBonds) {
            res.reconnectInterResBonds();
        }
        if (oldTemplate.name.equalsIgnoreCase("PRO") || newTemplate.name.equalsIgnoreCase("PRO")) {
            if (idealizeSidechainAfterMutation) {
                SidechainIdealizer.idealizeSidechain(templateLib, res);
            }
            if (!newTemplate.name.equalsIgnoreCase("PRO") && res.pucker != null && res.pucker.puckerProblem != null) {
                res.pucker.puckerProblem.removeFromRes();
                res.pucker.puckerProblem = null;
            }
        } else if (idealizeSidechainAfterMutation && HardCodedResidueInfo.hasAminoAcidBB(res) && (res.template.name.equalsIgnoreCase("GLY") || res.getAtomByName("CB") != null)) {
            SidechainIdealizer.idealizeSidechain(templateLib, res);
        }
    }

    public void restoreCoordsFromTemplate() {
        if (this.res.template.CAEquivalent == null) {
            return;
        }
        MutAlignment mutAlignment = new MutAlignment(this.res.template, this.res.template);
        int[][] mutAlignAtoms = mutAlignment.getMutAlignmentAtoms();
        double[][] resBBCoords = ResidueTypeDOF.extractCoords(mutAlignAtoms[0], this.res.coords);
        double[][] templateBBCoords = ResidueTypeDOF.extractCoords(mutAlignAtoms[1], this.res.template.templateRes.coords);
        RigidBodyMotion xform = new RigidBodyMotion(templateBBCoords, resBBCoords);
        TreeSet<String> nonmovingAtomNames = mutAlignment.getNonmovingAtomNames();
        for (Atom atom : this.res.atoms) {
            if (nonmovingAtomNames.contains(atom.name)) continue;
            int i = atom.indexInRes * 3;
            System.arraycopy(this.res.template.templateRes.coords, i, this.res.coords, i, 3);
            xform.transform(this.res.coords, atom.indexInRes);
        }
    }

    static double[][] extractCoords(int[] index, double[] allCoords) {
        double[][] ans = new double[index.length][3];
        for (int i = 0; i < index.length; ++i) {
            System.arraycopy(allCoords, 3 * index[i], ans[i], 0, 3);
        }
        return ans;
    }

    public String getCurResType() {
        return this.res.fullName.substring(0, 3);
    }

    @Override
    public void apply(double paramVal) {
        throw new IllegalArgumentException("ERROR: ResidueTypeDOF takes an residue type name as argument; can't take " + paramVal);
    }

    @Override
    public Residue getResidue() {
        return this.res;
    }

    @Override
    public DegreeOfFreedom copy() {
        return new ResidueTypeDOF(this.templateLib, this.res);
    }

    @Override
    public void setMolecule(Molecule val) {
        this.res = val.getResByPDBResNumber(this.res.getPDBResNumber());
    }

    @Override
    public DOFBlock getBlock() {
        return null;
    }

    @Override
    public String getName() {
        return "RESTYPE" + this.res.getPDBResNumber();
    }
}

