/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper;

import edu.duke.cs.osprey.dof.DihedralRotation;
import edu.duke.cs.osprey.dof.deeper.SidechainIdealizer;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;

public class GenChi1Calc {
    public static double getGenChi1(Residue res) {
        if (res.template.name.equalsIgnoreCase("GLY")) {
            return 0.0;
        }
        String lastAtom = GenChi1Calc.getGenChi1LastAtom(res.template.name);
        double[] lastCoords = res.getCoordsByAtomName(lastAtom);
        double[] NCoords = res.getCoordsByAtomName("N");
        double[] CACoords = res.getCoordsByAtomName("CA");
        double[] CBCoords = res.getCoordsByAtomName("CB");
        if (lastCoords == null || NCoords == null || CACoords == null | CBCoords == null) {
            return Double.NaN;
        }
        double[][] dihCoords = new double[][]{NCoords, CACoords, CBCoords, lastCoords};
        return Protractor.measureDihedral(dihCoords);
    }

    public static void setGenChi1(Residue res, double ang) {
        if (!HardCodedResidueInfo.hasAminoAcidBB(res) || res.template.name.equalsIgnoreCase("GLY") || res.template.name.equalsIgnoreCase("PRO")) {
            return;
        }
        double curGenChi1 = GenChi1Calc.getGenChi1(res);
        double genChi1Change = ang - curGenChi1;
        DihedralRotation dihRot = new DihedralRotation(res.getCoordsByAtomName("CA"), res.getCoordsByAtomName("CB"), genChi1Change);
        int numAtoms = res.atoms.size();
        for (int atomNum = 0; atomNum < numAtoms; ++atomNum) {
            String atomName = res.atoms.get((int)atomNum).name;
            if (!SidechainIdealizer.isSidechainAtom(atomName, res) || atomName.equalsIgnoreCase("CB")) continue;
            dihRot.transform(res.coords, atomNum);
        }
    }

    public static String getGenChi1LastAtom(String resName) {
        if (resName.equalsIgnoreCase("val") || resName.equalsIgnoreCase("ile")) {
            return "CG1";
        }
        if (resName.equalsIgnoreCase("ser")) {
            return "OG";
        }
        if (resName.equalsIgnoreCase("thr")) {
            return "OG1";
        }
        if (resName.equalsIgnoreCase("cys") || resName.equalsIgnoreCase("cyx")) {
            return "SG";
        }
        if (resName.equalsIgnoreCase("ala")) {
            return "HB1";
        }
        return "CG";
    }
}

