/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper;

import edu.duke.cs.osprey.dof.deeper.perts.Backrub;
import edu.duke.cs.osprey.dof.deeper.perts.LoopClosureAdjustment;
import edu.duke.cs.osprey.dof.deeper.perts.PartialStructureSwitch;
import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.dof.deeper.perts.PerturbationBlock;
import edu.duke.cs.osprey.dof.deeper.perts.Shear;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.StringParsing;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PertSet
implements Serializable {
    ArrayList<String> pertTypes = new ArrayList();
    ArrayList<ArrayList<String>> resNums = new ArrayList();
    ArrayList<ArrayList<double[]>> pertIntervals = new ArrayList();
    ArrayList<ArrayList<ArrayList<int[]>>> pertStates = new ArrayList();
    ArrayList<ArrayList<String>> additionalInfo = new ArrayList();

    public boolean loadPertFile(String pertFileName, boolean loadStates, ResidueTermini termini) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(pertFileName));
            br.readLine();
            this.readPerts(br, termini);
            if (loadStates) {
                this.pertStates = new ArrayList();
                while (br.readLine() != null) {
                    int numStates = Integer.valueOf(StringParsing.getToken(br.readLine(), 1));
                    ArrayList<Integer> resPerts = new ArrayList<Integer>();
                    StringTokenizer st = new StringTokenizer(br.readLine(), " ");
                    int resNumPerts = st.countTokens() - 1;
                    st.nextToken();
                    for (int a = 0; a < resNumPerts; ++a) {
                        resPerts.add(Integer.valueOf(st.nextToken()));
                    }
                    ArrayList resPertStates = new ArrayList();
                    for (int a = 0; a < numStates; ++a) {
                        ArrayList<int[]> pertState = new ArrayList<int[]>();
                        st = new StringTokenizer(br.readLine(), " ");
                        for (int b = 0; b < resNumPerts; ++b) {
                            int[] p = new int[]{(Integer)resPerts.get(b), Integer.valueOf(st.nextToken())};
                            pertState.add(p);
                        }
                        resPertStates.add(pertState);
                    }
                    this.pertStates.add(resPertStates);
                }
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("ERROR READING PERTURBATION FILE: " + e.getMessage());
        }
        return true;
    }

    public void readPerts(BufferedReader br) throws Exception {
        int numPerts = Integer.valueOf(br.readLine().trim());
        this.pertTypes = new ArrayList();
        this.resNums = new ArrayList();
        this.pertIntervals = new ArrayList();
        this.additionalInfo = new ArrayList();
        for (int a = 0; a < numPerts; ++a) {
            String pertType = br.readLine();
            this.pertTypes.add(pertType);
            StringTokenizer st = new StringTokenizer(br.readLine(), " ");
            int numAffectedRes = st.countTokens();
            ArrayList<String> pertResNums = new ArrayList<String>();
            for (int b = 0; b < numAffectedRes; ++b) {
                String inputNumber = st.nextToken();
                pertResNums.add(inputNumber);
            }
            this.resNums.add(pertResNums);
            this.recordAdditionalInfo(br, pertType);
            st = new StringTokenizer(br.readLine(), " ");
            int numStates = Integer.valueOf(st.nextToken());
            ArrayList<double[]> curPertIntervals = new ArrayList<double[]>();
            for (int b = 0; b < numStates; ++b) {
                st = new StringTokenizer(br.readLine(), " ");
                if (st.countTokens() != 2) {
                    throw new Exception("Bad formatting of perturbation " + a);
                }
                double lo = Double.valueOf(st.nextToken());
                double hi = Double.valueOf(st.nextToken());
                curPertIntervals.add(new double[]{lo, hi});
            }
            this.pertIntervals.add(curPertIntervals);
        }
    }

    public void readPerts(BufferedReader br, ResidueTermini termini) throws Exception {
        int numPerts = Integer.valueOf(br.readLine().trim());
        this.pertTypes = new ArrayList();
        this.resNums = new ArrayList();
        this.pertIntervals = new ArrayList();
        this.additionalInfo = new ArrayList();
        for (int a = 0; a < numPerts; ++a) {
            String pertType = br.readLine();
            this.pertTypes.add(pertType);
            StringTokenizer st = new StringTokenizer(br.readLine(), " ");
            int numAffectedRes = st.countTokens();
            ArrayList<String> pertResNums = new ArrayList<String>();
            for (int b = 0; b < numAffectedRes; ++b) {
                String inputNumber = st.nextToken();
                if (termini != null && !termini.contains(inputNumber)) continue;
                pertResNums.add(inputNumber);
            }
            if (pertResNums.isEmpty()) {
                this.pertTypes.remove(this.pertTypes.size() - 1);
                continue;
            }
            this.resNums.add(pertResNums);
            this.recordAdditionalInfo(br, pertType);
            st = new StringTokenizer(br.readLine(), " ");
            int numStates = Integer.valueOf(st.nextToken());
            ArrayList<double[]> curPertIntervals = new ArrayList<double[]>();
            for (int b = 0; b < numStates; ++b) {
                st = new StringTokenizer(br.readLine(), " ");
                if (st.countTokens() != 2) {
                    throw new Exception("Bad formatting of perturbation " + a);
                }
                double lo = Double.valueOf(st.nextToken());
                double hi = Double.valueOf(st.nextToken());
                curPertIntervals.add(new double[]{lo, hi});
            }
            this.pertIntervals.add(curPertIntervals);
        }
        if (this.pertTypes.isEmpty()) {
            while (br.readLine() != null) {
            }
        }
    }

    void recordAdditionalInfo(BufferedReader br, String pertType) throws IOException {
        if (pertType.equalsIgnoreCase("PARTIAL STRUCTURE SWITCH")) {
            int numStructs = Integer.valueOf(StringParsing.getToken(br.readLine(), 1));
            ArrayList<String> altPDBs = new ArrayList<String>();
            for (int structNum = 1; structNum < numStructs; ++structNum) {
                altPDBs.add(br.readLine().trim());
            }
            this.additionalInfo.add(altPDBs);
        } else {
            this.additionalInfo.add(null);
        }
    }

    public void writePertFile(String pertFileName) {
        try {
            int state;
            BufferedWriter bw = new BufferedWriter(new FileWriter(pertFileName));
            bw.append("PERTURBATIONS");
            bw.newLine();
            int numPerts = this.pertTypes.size();
            bw.append(String.valueOf(numPerts));
            bw.newLine();
            for (int pertNum = 0; pertNum < numPerts; ++pertNum) {
                bw.append(this.pertTypes.get(pertNum));
                bw.newLine();
                for (String resNum : this.resNums.get(pertNum)) {
                    bw.append(resNum + " ");
                }
                bw.newLine();
                this.writeAdditionalInfo(bw, this.additionalInfo.get(pertNum));
                int numIntervals = this.pertIntervals.get(pertNum).size();
                bw.append(numIntervals + " states");
                bw.newLine();
                for (state = 0; state < numIntervals; ++state) {
                    double[] interv = this.pertIntervals.get(pertNum).get(state);
                    bw.append(interv[0] + " " + interv[1]);
                    bw.newLine();
                }
            }
            for (int pos = 0; pos < this.pertStates.size(); ++pos) {
                ArrayList<ArrayList<int[]>> resPertStates = this.pertStates.get(pos);
                bw.append("RES");
                bw.newLine();
                bw.append(resPertStates.size() + " states ");
                bw.newLine();
                bw.append("PERTURBATIONS ");
                if (resPertStates.size() > 0) {
                    ArrayList<int[]> firstState = resPertStates.get(0);
                    for (int a = 0; a < firstState.size(); ++a) {
                        bw.append(firstState.get(a)[0] + " ");
                    }
                }
                bw.newLine();
                for (state = 0; state < resPertStates.size(); ++state) {
                    ArrayList<int[]> pertState = resPertStates.get(state);
                    for (int pertInd = 0; pertInd < pertState.size(); ++pertInd) {
                        bw.append(pertState.get(pertInd)[1] + " ");
                    }
                    bw.newLine();
                }
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("ERROR WRITING PERTURBATION FILE: " + e.getMessage());
        }
    }

    private void writeAdditionalInfo(BufferedWriter bw, ArrayList<String> altPDBs) throws IOException {
        if (altPDBs != null) {
            int numStructs = altPDBs.size() + 1;
            bw.append(numStructs + " structures");
            bw.newLine();
            for (String fileName : altPDBs) {
                bw.append(fileName);
                bw.newLine();
            }
        }
    }

    ArrayList<Perturbation> makePerturbations(Molecule m) {
        ArrayList<Perturbation> ans = new ArrayList<Perturbation>();
        for (int pertNum = 0; pertNum < this.pertTypes.size(); ++pertNum) {
            Perturbation pert;
            String type = this.pertTypes.get(pertNum);
            ArrayList<Residue> directlyAffectedResidues = new ArrayList<Residue>();
            for (String resNum : this.resNums.get(pertNum)) {
                directlyAffectedResidues.add(m.getResByPDBResNumber(resNum));
            }
            if (type.equalsIgnoreCase("BACKRUB")) {
                pert = new Backrub(directlyAffectedResidues);
            } else if (type.equalsIgnoreCase("SHEAR")) {
                pert = new Shear(directlyAffectedResidues);
            } else if (type.equalsIgnoreCase("LOOP CLOSURE ADJUSTMENT")) {
                pert = new LoopClosureAdjustment(directlyAffectedResidues);
            } else if (type.equalsIgnoreCase("PARTIAL STRUCTURE SWITCH")) {
                pert = new PartialStructureSwitch(directlyAffectedResidues, this.additionalInfo.get(pertNum));
            } else {
                throw new RuntimeException("ERROR: Unrecognized perturbation type: " + type);
            }
            ans.add(pert);
        }
        PerturbationBlock pblock = new PerturbationBlock(ans);
        return ans;
    }

    PertSet makeDiscreteVersion() {
        PertSet discrSet = new PertSet();
        discrSet.pertTypes = this.pertTypes;
        discrSet.resNums = this.resNums;
        discrSet.pertStates = this.pertStates;
        discrSet.additionalInfo = this.additionalInfo;
        for (ArrayList<double[]> curPertIntervals : this.pertIntervals) {
            ArrayList<double[]> curDiscr = new ArrayList<double[]>();
            for (double[] bounds : curPertIntervals) {
                if (bounds[0] == bounds[1]) {
                    curDiscr.add(bounds);
                    continue;
                }
                double discrValue = (bounds[0] + bounds[1]) / 2.0;
                curDiscr.add(new double[]{discrValue, discrValue});
            }
            discrSet.pertIntervals.add(curDiscr);
        }
        return discrSet;
    }
}

