/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper;

import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class ResBBState
implements Serializable {
    HashMap<String, double[]> coords = new HashMap();
    double[] CBCoord = null;
    static final double HNProRatio = 0.692297285699751;

    public ResBBState(Residue res) {
        for (Atom at : res.atoms) {
            boolean isBBAtom = false;
            for (String BBAtomName : HardCodedResidueInfo.possibleBBAtoms) {
                if (!at.name.equalsIgnoreCase(BBAtomName)) continue;
                isBBAtom = true;
                break;
            }
            if (isBBAtom) {
                this.coords.put(at.name, at.getCoords());
            } else if (at.name.equalsIgnoreCase("CB")) {
                this.CBCoord = at.getCoords();
            } else if (res.fullName.startsWith("GLY") && at.name.equalsIgnoreCase("HA3")) {
                this.CBCoord = at.getCoords();
            }
            if (!res.fullName.startsWith("PRO") || !at.name.equalsIgnoreCase("CD")) continue;
            double[] HCoord = at.getCoords();
            this.rescaleBondLen(HCoord, res.getCoordsByAtomName("N"), 0.692297285699751);
            this.coords.put("H", HCoord);
        }
    }

    public ResBBState(ResBBState state2) {
        if (state2.CBCoord != null) {
            this.CBCoord = (double[])state2.CBCoord.clone();
        }
        for (String s : state2.coords.keySet()) {
            this.coords.put(s, (double[])state2.coords.get(s).clone());
        }
    }

    public void putInState(Residue res) {
        double[] resCBCoord;
        Set<String> BBAtomNames = this.coords.keySet();
        if (this.CBCoord != null && (resCBCoord = res.getCoordsByAtomName("CB")) != null) {
            double[] resCACoord = res.getCoordsByAtomName("CA");
            RigidBodyMotion sidechainMotion = new RigidBodyMotion(new double[][]{resCACoord, resCBCoord, new double[3]}, new double[][]{this.coords.get("CA"), this.CBCoord, new double[3]});
            for (int atomIndex = 0; atomIndex < res.atoms.size(); ++atomIndex) {
                if (BBAtomNames.contains(res.atoms.get((int)atomIndex).name)) continue;
                sidechainMotion.transform(res.coords, atomIndex);
            }
        }
        for (String atomName : BBAtomNames) {
            int atomIndex = res.getAtomIndexByName(atomName);
            double[] atomCoords = this.coords.get(atomName);
            if (atomIndex == -1) {
                if (res.fullName.startsWith("PRO") && atomName.equalsIgnoreCase("H")) {
                    atomIndex = res.getAtomIndexByName("CD");
                    atomCoords = (double[])atomCoords.clone();
                    this.rescaleBondLen(atomCoords, this.coords.get("N"), 1.4444661573231987);
                } else {
                    throw new RuntimeException("ERROR: Didn't find atom " + atomName + " in residue " + res.fullName);
                }
            }
            System.arraycopy(atomCoords, 0, res.coords, 3 * atomIndex, 3);
        }
    }

    void rescaleBondLen(double[] coord, double[] refCoord, double distRatio) {
        for (int dim = 0; dim < 3; ++dim) {
            coord[dim] = refCoord[dim] + distRatio * (coord[dim] - refCoord[dim]);
        }
    }
}

