/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.dof.deeper.perts.PerturbationBlock;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import edu.duke.cs.osprey.tools.RotationMatrix;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;

public class Shear
extends Perturbation {
    public Shear(ArrayList<Residue> resDirectlyAffected) {
        super(resDirectlyAffected);
    }

    @Override
    public boolean doPerturbationMotion(double paramVal) {
        RigidBodyMotion[] pepMotions = this.calcMotions(paramVal);
        this.movePeptidePlane(pepMotions[0], 0, true);
        this.movePeptidePlane(pepMotions[1], 1, true);
        this.movePeptidePlane(pepMotions[2], 2, false);
        return true;
    }

    RigidBodyMotion[] calcMotions(double paramVal) {
        RotationMatrix[] rm = new RotationMatrix[3];
        double[][] tr = new double[2][];
        double[][] x = new double[4][3];
        for (int a = 0; a < 4; ++a) {
            x[a] = ((Residue)this.resDirectlyAffected.get(a)).getCoordsByAtomName("CA");
        }
        Residue midRes = (Residue)this.resDirectlyAffected.get(1);
        double[] midOCoord = midRes.getCoordsByAtomName("O");
        double[] midCCoord = midRes.getCoordsByAtomName("C");
        double[] w = VectorAlgebra.subtract(midOCoord, midCCoord);
        double[] x01 = VectorAlgebra.subtract(x[1], x[0]);
        double[] x12 = VectorAlgebra.subtract(x[2], x[1]);
        double[] x23 = VectorAlgebra.subtract(x[3], x[2]);
        double[] rotax1 = VectorAlgebra.cross(x01, x12);
        rm[0] = new RotationMatrix(rotax1[0], rotax1[1], rotax1[2], paramVal, false);
        tr[0] = VectorAlgebra.subtract(rm[0].rotateVector(x01), x01);
        double[] y1 = VectorAlgebra.add(x[1], tr[0]);
        double[] y13 = VectorAlgebra.subtract(x[3], y1);
        double a = VectorAlgebra.norm(x23);
        double b = VectorAlgebra.norm(y13);
        double d = VectorAlgebra.norm(x12);
        double beta = Math.acos(VectorAlgebra.dot(x23, y13) / (a * b)) - Math.acos((b * b + a * a - d * d) / (2.0 * a * b));
        double[] rotax2 = VectorAlgebra.cross(x23, y13);
        rm[2] = new RotationMatrix(rotax2[0], rotax2[1], rotax2[2], beta, true);
        tr[1] = VectorAlgebra.subtract(x23, rm[2].rotateVector(x23));
        double[] y2 = VectorAlgebra.add(x[2], tr[1]);
        double[] y12 = VectorAlgebra.subtract(y2, y1);
        double theta = Protractor.getAngleRadians(x12, y12);
        double[] srotax = VectorAlgebra.cross(x12, y12);
        rm[1] = VectorAlgebra.norm(srotax) == 0.0 ? RotationMatrix.identity() : new RotationMatrix(srotax[0], srotax[1], srotax[2], theta, true);
        double[] u = rm[1].rotateVector(w);
        double[] vhat = VectorAlgebra.scale(y12, 1.0 / VectorAlgebra.norm(y12));
        double alpha = Math.atan2(VectorAlgebra.dot(VectorAlgebra.cross(u, w), vhat), VectorAlgebra.dot(w, u) - VectorAlgebra.dot(w, vhat) * VectorAlgebra.dot(u, vhat));
        RotationMatrix rmalpha = new RotationMatrix(vhat[0], vhat[1], vhat[2], alpha, true);
        rm[1] = rmalpha.multiply(rm[1]);
        RigidBodyMotion[] ans = new RigidBodyMotion[3];
        ans[0] = new RigidBodyMotion(x[0], rm[0], x[0]);
        for (int m = 1; m < 3; ++m) {
            double[] center2 = VectorAlgebra.add(x[m], tr[m - 1]);
            ans[m] = new RigidBodyMotion(x[m], rm[m], center2);
        }
        return ans;
    }

    @Override
    public Perturbation copyForNewMolecule(Molecule mol, PerturbationBlock block) {
        Shear s = new Shear(Residue.equivalentInMolec(this.resDirectlyAffected, mol));
        s.curParamVal = this.curParamVal;
        s.indexInBlock = this.indexInBlock;
        s.block = block;
        return s;
    }
}

