/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import edu.duke.cs.osprey.confspace.AbstractTupleMatrix;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ParameterizedMoleculeCopy;
import edu.duke.cs.osprey.confspace.ParameterizedMoleculePool;
import edu.duke.cs.osprey.ematrix.DofMatrix;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleEnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gpu.cuda.GpuStreamPool;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.parallelism.ThreadPoolTaskExecutor;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.ObjectPool;
import edu.duke.cs.osprey.tools.Progress;
import java.io.File;
import java.util.List;

@Deprecated
public abstract class SimpleEnergyMatrixCalculator {
    protected SimpleEnergyCalculator ecalc;
    protected TaskExecutor tasks;

    protected SimpleEnergyMatrixCalculator() {
    }

    public EnergyMatrix calcEnergyMatrix(File cacheFile) {
        return ObjectIO.readOrMake(cacheFile, EnergyMatrix.class, "energy matrix", context -> this.calcEnergyMatrix());
    }

    public EnergyMatrix calcEnergyMatrix() {
        EnergyMatrix emat = new EnergyMatrix(this.ecalc.confSpace, Double.POSITIVE_INFINITY);
        this.calcMatrices(emat, null);
        return emat;
    }

    public DofMatrix calcDofMatrix() {
        DofMatrix dofmat = new DofMatrix(this.ecalc.confSpace);
        this.calcMatrices(null, dofmat);
        return dofmat;
    }

    public void calcMatrices(EnergyMatrix emat, DofMatrix dofmat) {
        if (emat != null && dofmat != null) {
            if (emat.getNumPos() != dofmat.getNumPos()) {
                throw new IllegalArgumentException("emat and dofmat must match size!");
            }
            for (int i = 0; i < emat.getNumPos(); ++i) {
                if (emat.getNumConfAtPos(i) == dofmat.getNumConfAtPos(i)) continue;
                throw new IllegalArgumentException("emat and dofmat must match size!");
            }
        }
        AbstractTupleMatrix sizemat = null;
        if (emat != null) {
            sizemat = emat;
        }
        if (dofmat != null) {
            sizemat = dofmat;
        }
        if (sizemat == null) {
            throw new IllegalArgumentException("emat and dofmat cannot both be null");
        }
        if (this.tasks == null) {
            this.tasks = new TaskExecutor();
        }
        long numWork = 0L;
        for (int pos1 = 0; pos1 < sizemat.getNumPos(); ++pos1) {
            numWork += (long)sizemat.getNumConfAtPos(pos1);
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                for (int rc1 = 0; rc1 < sizemat.getNumConfAtPos(pos1); ++rc1) {
                    numWork += (long)sizemat.getNumConfAtPos(pos2);
                }
            }
        }
        Progress progress2 = new Progress(numWork);
        ParameterizedMoleculePool pmols = new ParameterizedMoleculePool(this.ecalc.confSpace);
        System.out.println("Calculating energies...");
        for (int pos1 = 0; pos1 < emat.getNumPos(); ++pos1) {
            for (int rc1 = 0; rc1 < emat.getNumConfAtPos(pos1); ++rc1) {
                int fpos1 = pos1;
                int frc1 = rc1;
                this.tasks.submit(() -> {
                    try (ObjectPool.Checkout pmol = pmols.autoCheckout();){
                        Minimizer.Result result = this.ecalc.calcSingle(fpos1, frc1, (ParameterizedMoleculeCopy)pmol.get());
                        return result;
                    }
                }, result -> {
                    if (emat != null) {
                        emat.setOneBody(fpos1, frc1, result.energy);
                    }
                    if (dofmat != null) {
                        dofmat.setOneBody(fpos1, frc1, result.dofValues);
                    }
                    progress2.incrementProgress();
                });
                for (int pos2 = 0; pos2 < pos1; ++pos2) {
                    int fpos2 = pos2;
                    int numrc2 = emat.getNumConfAtPos(pos2);
                    this.tasks.submit(() -> {
                        try (ObjectPool.Checkout pmol = pmols.autoCheckout();){
                            Minimizer.Result[] results2 = new Minimizer.Result[numrc2];
                            for (int rc2 = 0; rc2 < numrc2; ++rc2) {
                                results2[rc2] = this.ecalc.calcPair(fpos1, frc1, fpos2, rc2, (ParameterizedMoleculeCopy)pmol.get());
                            }
                            Minimizer.Result[] resultArray = results2;
                            return resultArray;
                        }
                    }, results2 -> {
                        int rc2;
                        if (emat != null) {
                            for (rc2 = 0; rc2 < numrc2; ++rc2) {
                                emat.setPairwise(fpos1, frc1, fpos2, rc2, results2[rc2].energy);
                            }
                        }
                        if (dofmat != null) {
                            for (rc2 = 0; rc2 < numrc2; ++rc2) {
                                dofmat.setPairwise(fpos1, frc1, fpos2, rc2, results2[rc2].dofValues);
                            }
                        }
                        progress2.incrementProgress(numrc2);
                    });
                }
            }
        }
        this.tasks.waitForFinish();
    }

    public abstract void cleanup();

    @Deprecated
    public static class Cuda
    extends SimpleEnergyMatrixCalculator {
        private GpuStreamPool pool;
        private ThreadPoolTaskExecutor tasks;

        public Cuda(int numGpus, int numStreamsPerGpu, ForcefieldParams ffparams, ConfSpace confSpace, List<Residue> shellResidues) {
            this.pool = new GpuStreamPool(numGpus, numStreamsPerGpu);
            this.ecalc = new SimpleEnergyCalculator.Cuda(this.pool, ffparams, confSpace, shellResidues);
            this.tasks = new ThreadPoolTaskExecutor();
            this.tasks.start(this.pool.getNumStreams());
            ((SimpleEnergyMatrixCalculator)this).tasks = this.tasks;
        }

        @Override
        public void cleanup() {
            this.tasks.stop();
            this.pool.cleanup();
        }
    }

    public static class Cpu
    extends SimpleEnergyMatrixCalculator {
        private ThreadPoolTaskExecutor tasks;

        private Cpu(int numThreads, SimpleEnergyCalculator ecalc) {
            this.ecalc = ecalc;
            this.tasks = new ThreadPoolTaskExecutor();
            this.tasks.start(numThreads);
            ((SimpleEnergyMatrixCalculator)this).tasks = this.tasks;
        }

        public Cpu(int numThreads, ForcefieldParams ffparams, ConfSpace confSpace, List<Residue> shellResidues) {
            this(numThreads, new SimpleEnergyCalculator.Cpu(ffparams, confSpace, shellResidues));
        }

        @Override
        public void cleanup() {
            this.tasks.stop();
        }
    }
}

