/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.ematrix.epic.EPICEnergyFunction;
import edu.duke.cs.osprey.ematrix.epic.EPICFitter;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.ematrix.epic.EPoly;
import edu.duke.cs.osprey.ematrix.epic.FitParams;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.handlempi.MPISlaveTask;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class TermECalculator
implements MPISlaveTask {
    ConfSpace confSpace;
    boolean doingEPIC;
    boolean doingIntra;
    int[] res;
    EnergyFunction termE;
    PruningMatrix pruneMat;
    EPICSettings epicSettings = null;
    boolean addResEntropy;
    ArrayList<Double> oneBodyE = new ArrayList();
    ArrayList<ArrayList<Double>> pairwiseE = new ArrayList();
    ArrayList<EPoly> oneBodyPoly = new ArrayList();
    ArrayList<ArrayList<EPoly>> pairwisePoly = new ArrayList();
    HashMap<ArrayList<Integer>, Double> nBodyE = new HashMap();
    ArrayList<MoleculeModifierAndScorer> mofs = null;
    private static final boolean SAPEKeepStandalone = false;

    public TermECalculator(ConfSpace s, ArrayList<Residue> shellResidues, boolean doEPIC, boolean doIntra, PruningMatrix prm, EPICSettings es, boolean addResEnt, int ... resToCalc) {
        this.confSpace = s;
        this.doingEPIC = doEPIC;
        this.doingIntra = doIntra;
        this.res = resToCalc;
        this.pruneMat = prm;
        this.epicSettings = es;
        this.addResEntropy = addResEnt;
        Residue firstRes = this.confSpace.posFlex.get((int)this.res[0]).res;
        if (this.doingIntra) {
            this.termE = EnvironmentVars.curEFcnGenerator.singleResEnergy(firstRes);
        } else if (this.res.length == 1) {
            this.termE = EnvironmentVars.curEFcnGenerator.intraAndShellEnergy(firstRes, shellResidues);
        } else if (this.res.length == 2) {
            Residue secondRes = this.confSpace.posFlex.get((int)this.res[1]).res;
            this.termE = EnvironmentVars.curEFcnGenerator.resPairEnergy(firstRes, secondRes);
        } else if (this.res.length > 2) {
            this.termE = new MultiTermEnergyFunction();
            for (int i = 0; i < this.res.length; ++i) {
                Residue l = this.confSpace.posFlex.get((int)this.res[i]).res;
                for (int j = i + 1; j < this.res.length; ++j) {
                    Residue r = this.confSpace.posFlex.get((int)this.res[j]).res;
                    ((MultiTermEnergyFunction)this.termE).addTerm(EnvironmentVars.curEFcnGenerator.resPairEnergy(l, r));
                }
            }
        } else {
            throw new UnsupportedOperationException("ERROR: Can only precompute energy for >= 1 body terms");
        }
    }

    @Override
    public Object doCalculation() {
        if (this.res.length == 1) {
            this.oneBodyCalc();
            if (this.doingEPIC) {
                return this.oneBodyPoly;
            }
            return this.oneBodyE;
        }
        if (this.res.length == 2) {
            this.pairwiseCalc();
            if (this.doingEPIC) {
                return this.pairwisePoly;
            }
            return this.pairwiseE;
        }
        if (this.res.length > 2) {
            this.nBodyCalc();
            if (this.doingEPIC) {
                throw new UnsupportedOperationException("ERROR: have not implemented >2-body energies with EPIC");
            }
            return this.nBodyE;
        }
        throw new UnsupportedOperationException("ERROR: Trying to precompute term for " + this.res.length + " bodies");
    }

    public void oneBodyCalc() {
        ArrayList<RC> RCList = this.confSpace.posFlex.get((int)this.res[0]).RCs;
        for (int RCNum = 0; RCNum < RCList.size(); ++RCNum) {
            RCTuple RCTup = new RCTuple(this.res[0], RCNum);
            this.calcTupleEnergy(RCTup);
        }
    }

    public void pairwiseCalc() {
        ArrayList<RC> RCList1 = this.confSpace.posFlex.get((int)this.res[0]).RCs;
        ArrayList<RC> RCList2 = this.confSpace.posFlex.get((int)this.res[1]).RCs;
        for (int firstRCNum = 0; firstRCNum < RCList1.size(); ++firstRCNum) {
            for (int secondRCNum = 0; secondRCNum < RCList2.size(); ++secondRCNum) {
                RCTuple RCTup = new RCTuple(this.res[0], firstRCNum, this.res[1], secondRCNum);
                this.calcTupleEnergy(RCTup);
            }
        }
    }

    public void nBodyCalc() {
        if (this.pruneMat == null) {
            throw new RuntimeException("ERROR: n-body calc requires a pruning matrix");
        }
        ArrayList<ArrayList<RC>> RCLists = new ArrayList<ArrayList<RC>>(this.res.length);
        for (int index = 0; index < this.res.length; ++index) {
            RCLists.add(new ArrayList());
        }
        for (int i = 0; i < this.res.length; ++i) {
            for (Integer rcNum : this.pruneMat.unprunedRCsAtPos(this.res[i])) {
                ((ArrayList)RCLists.get(i)).add(this.confSpace.posFlex.get((int)this.res[i]).RCs.get(rcNum));
            }
        }
        Object[] resElements = new Integer[this.res.length];
        Arrays.fill(resElements, (Object)-1);
        Object[] rcNums = new Integer[this.res.length];
        Arrays.fill(rcNums, (Object)-1);
        this.createNBodyTuples(RCLists, (Integer[])resElements, (Integer[])rcNums, 0);
    }

    private void createNBodyTuples(ArrayList<ArrayList<RC>> RCLists, Integer[] resElements, Integer[] rcNums, int depth) {
        if (depth == resElements.length) {
            RCTuple nTuple = new RCTuple(new ArrayList<Integer>(Arrays.asList(resElements)), new ArrayList<Integer>(Arrays.asList(rcNums)));
            this.calcTupleEnergy(nTuple);
            return;
        }
        if (resElements[depth] == -1) {
            resElements[depth] = this.res[depth];
        }
        for (int rcNum = 0; rcNum < RCLists.get(depth).size(); ++rcNum) {
            rcNums[depth] = rcNum;
            this.createNBodyTuples(RCLists, resElements, rcNums, depth + 1);
        }
    }

    public void calcTupleEnergyLazy(RCTuple RCs2) {
        this.mofs = new ArrayList();
        boolean skipTuple = false;
        if (RCs2.pos.size() == 2) {
            RC rc2;
            RC rc1 = this.confSpace.posFlex.get((int)RCs2.pos.get((int)0).intValue()).RCs.get(RCs2.RCs.get(0));
            if (rc1.isParametricallyIncompatibleWith(rc2 = this.confSpace.posFlex.get((int)RCs2.pos.get((int)1).intValue()).RCs.get(RCs2.RCs.get(1)))) {
                skipTuple = true;
            }
        } else if (RCs2.pos.size() > 2) {
            int i;
            ArrayList<RC> indivRCs = new ArrayList<RC>(RCs2.pos.size());
            for (i = 0; i < RCs2.pos.size(); ++i) {
                indivRCs.add(this.confSpace.posFlex.get((int)RCs2.pos.get((int)i).intValue()).RCs.get(RCs2.RCs.get(i)));
            }
            for (i = 0; i < indivRCs.size(); ++i) {
                RC rc1 = (RC)indivRCs.get(i);
                for (int j = i + 1; j < indivRCs.size(); ++j) {
                    RC rc2 = (RC)indivRCs.get(j);
                    if (!rc1.isParametricallyIncompatibleWith(rc2)) continue;
                    skipTuple = true;
                    break;
                }
                if (skipTuple) break;
            }
        }
        if (this.pruneMat != null && !skipTuple && this.pruneMat.isPruned(RCs2)) {
            skipTuple = true;
        }
        if (!skipTuple) {
            DoubleMatrix1D bestDOFVals;
            MoleculeModifierAndScorer mof = new MoleculeModifierAndScorer(this.termE, this.confSpace, RCs2);
            this.mofs.add(mof);
            if (mof.getNumDOFs() > 0) {
                CCDMinimizer ccdMin = new CCDMinimizer(mof, true);
                bestDOFVals = ccdMin.minimize().dofValues;
            } else {
                bestDOFVals = DoubleFactory1D.dense.make(0);
            }
            double minEnergy = mof.getValue(bestDOFVals);
            if (this.doingEPIC) {
                throw new UnsupportedOperationException("ERROR: EPIC is not supprted in this function");
            }
        }
    }

    public void calcTupleEnergy(RCTuple RCs2) {
        int numBodies;
        boolean skipTuple = false;
        double minEnergy = Double.POSITIVE_INFINITY;
        EPoly EPICFit = null;
        if (RCs2.pos.size() == 2) {
            RC rc2;
            RC rc1 = this.confSpace.posFlex.get((int)RCs2.pos.get((int)0).intValue()).RCs.get(RCs2.RCs.get(0));
            if (rc1.isParametricallyIncompatibleWith(rc2 = this.confSpace.posFlex.get((int)RCs2.pos.get((int)1).intValue()).RCs.get(RCs2.RCs.get(1)))) {
                skipTuple = true;
            }
        } else if (RCs2.pos.size() > 2) {
            int i;
            ArrayList<RC> indivRCs = new ArrayList<RC>(RCs2.pos.size());
            for (i = 0; i < RCs2.pos.size(); ++i) {
                indivRCs.add(this.confSpace.posFlex.get((int)RCs2.pos.get((int)i).intValue()).RCs.get(RCs2.RCs.get(i)));
            }
            for (i = 0; i < indivRCs.size(); ++i) {
                RC rc1 = (RC)indivRCs.get(i);
                for (int j = i + 1; j < indivRCs.size(); ++j) {
                    RC rc2 = (RC)indivRCs.get(j);
                    if (!rc1.isParametricallyIncompatibleWith(rc2)) continue;
                    skipTuple = true;
                    break;
                }
                if (skipTuple) break;
            }
        }
        if (this.pruneMat != null && !skipTuple && this.pruneMat.isPruned(RCs2)) {
            skipTuple = true;
        }
        if (!skipTuple) {
            DoubleMatrix1D bestDOFVals;
            MoleculeModifierAndScorer mof = new MoleculeModifierAndScorer(this.termE, this.confSpace, RCs2);
            if (mof.getNumDOFs() > 0) {
                CCDMinimizer ccdMin = new CCDMinimizer(mof, true);
                bestDOFVals = ccdMin.minimize().dofValues;
            } else {
                bestDOFVals = DoubleFactory1D.dense.make(0);
            }
            minEnergy = mof.getValue(bestDOFVals);
            if (this.doingEPIC) {
                EPICFit = this.compEPICFit(mof, minEnergy, bestDOFVals, RCs2);
            }
        }
        if ((numBodies = RCs2.pos.size()) == 1) {
            if (this.doingEPIC) {
                this.oneBodyPoly.add(EPICFit);
            } else {
                if (this.addResEntropy) {
                    minEnergy += this.getResEntropy(RCs2);
                }
                this.oneBodyE.add(minEnergy);
            }
        } else if (numBodies == 2) {
            int firstRCNum = RCs2.RCs.get(0);
            if (this.doingEPIC) {
                if (this.pairwisePoly.size() <= firstRCNum) {
                    this.pairwisePoly.add(new ArrayList());
                }
                this.pairwisePoly.get(firstRCNum).add(EPICFit);
            } else {
                if (this.pairwiseE.size() <= firstRCNum) {
                    this.pairwiseE.add(new ArrayList());
                }
                this.pairwiseE.get(firstRCNum).add(minEnergy);
            }
        } else if (numBodies > 2) {
            if (this.doingEPIC) {
                throw new RuntimeException("ERROR: have not implemented > 2-body terms with EPIC");
            }
            if (!skipTuple) {
                this.nBodyE.put(RCs2.RCs, minEnergy);
            }
        } else {
            throw new UnsupportedOperationException("ERROR: Trying to precompute term for " + numBodies + " bodies");
        }
    }

    double getResEntropy(RCTuple RCs2) {
        if (RCs2.pos.size() != 1) {
            throw new RuntimeException("ERROR: Trying to get res entropy for non-singleton RC tuple " + RCs2.stringListing());
        }
        double resEntropy = this.confSpace.getRCResEntropy(RCs2.pos.get(0), RCs2.RCs.get(0));
        return resEntropy;
    }

    private EPoly compEPICFit(MoleculeModifierAndScorer mof, double minEnergy, DoubleMatrix1D bestDOFVals, RCTuple RCList) {
        EPICFitter fitter = new EPICFitter(mof, this.epicSettings, bestDOFVals, minEnergy);
        EPoly bestFit = null;
        if (mof.getNumDOFs() > 0) {
            FitParams curFitParams = FitParams.quadratic(mof.getNumDOFs(), false);
            double bestResid = Double.POSITIVE_INFINITY;
            int bestBound = -1;
            ArrayList<EPoly> series = new ArrayList<EPoly>();
            int boundCount = 0;
            while (bestResid > this.epicSettings.EPICGoalResid && curFitParams != null) {
                block9: {
                    EPoly curSeries;
                    System.out.println("FIT NUMBER " + boundCount + ": " + curFitParams.getDescription());
                    try {
                        curSeries = fitter.doFit(curFitParams);
                    }
                    catch (Exception e) {
                        System.err.println("Fit failed: " + e.getMessage());
                        e.printStackTrace();
                        series.add(null);
                        curFitParams = fitter.raiseFitOrder(curFitParams);
                        break block9;
                    }
                    double meanResid = fitter.crossValidateSeries(curSeries, curFitParams);
                    series.add(curSeries);
                    if (curFitParams.order == 2 && curFitParams.PCOrder <= 2 && curFitParams.SAPECutoff == 0.0) {
                        fitter.PCTemplate = curSeries;
                    }
                    if (meanResid < bestResid && this.checkStaysPositive(curSeries, mof)) {
                        bestResid = meanResid;
                        bestBound = boundCount;
                    }
                    curFitParams = fitter.raiseFitOrder(curFitParams);
                }
                ++boundCount;
            }
            if (bestBound == -1) {
                throw new RuntimeException("ERROR: No EPIC fit found without serious errors (e.g. significant error at minimum)");
            }
            if (bestResid > this.epicSettings.EPICGoalResid) {
                System.out.println("Failed to reach goal residual.");
            }
            System.out.println("Best residual: " + bestResid + " for bound number " + bestBound);
            this.printFitTests(fitter, RCList, minEnergy, mof, bestDOFVals, series);
            bestFit = series.get(bestBound);
        } else {
            bestFit = fitter.blank();
        }
        bestFit.setMinE(minEnergy);
        bestFit.deleteMOFStandalone();
        return bestFit;
    }

    private void printFitTests(EPICFitter fitter, RCTuple RCList, double minEnergy, MoleculeModifierAndScorer mof, DoubleMatrix1D bestDOFVals, ArrayList<EPoly> series) {
        int numDOFs = fitter.numDOFs;
        System.out.println("RCs: " + RCList.stringListing());
        System.out.println("Minimum energy: " + minEnergy);
        double[] testScales = new double[]{0.01, 0.5, 5.0, 100.0};
        int samplesPerScale = 3;
        double[] relMax = new double[numDOFs];
        double[] relMin = new double[numDOFs];
        DoubleMatrix1D[] constr = mof.getConstraints();
        for (int dof = 0; dof < numDOFs; ++dof) {
            relMax[dof] = constr[1].get(dof) - bestDOFVals.get(dof);
            relMin[dof] = constr[0].get(dof) - bestDOFVals.get(dof);
        }
        for (double scale : testScales) {
            for (int s = 0; s < samplesPerScale; ++s) {
                double[] dx = new double[numDOFs];
                DoubleMatrix1D sampAbs = DoubleFactory1D.dense.make(numDOFs);
                for (int dof = 0; dof < numDOFs; ++dof) {
                    double top = Math.min(relMax[dof], scale);
                    double bottom = Math.max(relMin[dof], -scale);
                    dx[dof] = bottom + Math.random() * (top - bottom);
                    sampAbs.set(dof, bestDOFVals.get(dof) + dx[dof]);
                }
                double trueVal = mof.getValue(sampAbs) - minEnergy;
                System.out.print("TEST: scale=" + scale + " dx=");
                for (int dof = 0; dof < numDOFs; ++dof) {
                    System.out.print(dx[dof] + " ");
                }
                System.out.print("TRUE=" + trueVal + " FIT=");
                for (EPoly b : series) {
                    if (b == null) continue;
                    System.out.print(b.evaluate(sampAbs, false, false) + " ");
                }
                System.out.println();
            }
        }
    }

    private boolean checkStaysPositive(EPoly term, MoleculeModifierAndScorer mof) {
        ArrayList<EPoly> termList = new ArrayList<EPoly>();
        termList.add(term);
        EPICEnergyFunction epicEF = new EPICEnergyFunction(termList, false);
        MoleculeModifierAndScorer ofEPIC = new MoleculeModifierAndScorer((EnergyFunction)epicEF, mof.getConstraints(), mof.getMolec(), mof.getDOFs());
        CCDMinimizer emin = new CCDMinimizer(ofEPIC, true);
        DoubleMatrix1D lowPoint = emin.minimize().dofValues;
        double lowPointTrueE = mof.getValue(lowPoint) - term.getMinE();
        double lowPointEPICE = ofEPIC.getValue(lowPoint);
        double tol = 0.1;
        if (lowPointEPICE < lowPointTrueE - tol) {
            System.out.println("Rejecting fit because of low minimum for EPIC term, " + lowPointEPICE + ".  Corresponding true E: " + lowPointTrueE);
            return false;
        }
        if (lowPointEPICE < -tol) {
            System.out.println("Warning: low minimum for EPIC term, " + lowPointEPICE + ".  Corresponding true E: " + lowPointTrueE);
        }
        return true;
    }
}

