/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.compiled;

import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.Progress;
import java.util.ArrayList;

public class ErefCalculator {
    public final ConfEnergyCalculator confEcalc;
    public final boolean minimize;

    private ErefCalculator(ConfEnergyCalculator confEcalc, boolean minimize2) {
        this.confEcalc = confEcalc;
        this.minimize = minimize2;
    }

    public SimpleReferenceEnergies calc() {
        return this.calc(new TaskExecutor());
    }

    public SimpleReferenceEnergies calc(TaskExecutor tasks) {
        SimpleReferenceEnergies eref = new SimpleReferenceEnergies();
        ConfSpace confSpace = this.confEcalc.confSpace();
        Progress progress2 = new Progress(confSpace.countSingles());
        Log.log("Calculating reference energies for %s position confs...", progress2.getTotalWork());
        for (int posi = 0; posi < confSpace.numPos(); ++posi) {
            int fposi = posi;
            int numConf = confSpace.numConf(fposi);
            int confi = 0;
            while (confi < numConf) {
                int fconfi = confi++;
                tasks.submit(() -> {
                    ArrayList<PosInter> inters = new ArrayList<PosInter>();
                    inters.add(new PosInter(fposi, fposi, 1.0, 0.0));
                    int[] assignments = confSpace.assign(fposi, fconfi);
                    return new ECalcResultContainer(fposi, fconfi, this.confEcalc.calcOrMinimizeEnergy(assignments, inters, this.minimize));
                }, container -> {
                    double energy = container.energy;
                    int pos = container.pos;
                    int conf = container.conf;
                    String resType = confSpace.confType(pos, conf);
                    Double e = eref.get(pos, resType);
                    if (e == null || energy < e) {
                        e = energy;
                    }
                    eref.set(pos, resType, e);
                    progress2.incrementProgress();
                });
            }
        }
        tasks.waitForFinish();
        return eref;
    }

    record ECalcResultContainer(int pos, int conf, double energy) {
    }

    public static class Builder {
        public final ConfEnergyCalculator confEcalc;
        private boolean minimize = true;

        public Builder(ConfEnergyCalculator confEcalc) {
            this.confEcalc = confEcalc;
        }

        public Builder setMinimize(boolean val) {
            this.minimize = val;
            return this;
        }

        public ErefCalculator build() {
            return new ErefCalculator(this.confEcalc, this.minimize);
        }
    }
}

