/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.TupleMatrixGeneric;
import edu.duke.cs.osprey.ematrix.epic.EPICEnergyFunction;
import edu.duke.cs.osprey.ematrix.epic.EPoly;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import java.util.ArrayList;

public class EPICMatrix
extends TupleMatrixGeneric<EPoly> {
    ConfSpace confSpace = null;

    public EPICMatrix(ConfSpace confSpace, double pruningInterval) {
        super(confSpace.numPos, confSpace.getNumRCsAtPos(), pruningInterval, null);
        this.confSpace = confSpace;
    }

    public double minimizeEnergy(RCTuple RCTup, boolean includeMinE) {
        long startTime = System.currentTimeMillis();
        EPICEnergyFunction efunc = this.internalEnergyFunction(RCTup, includeMinE);
        long gotEFcnTime = System.currentTimeMillis() - startTime;
        if (efunc == null) {
            return Double.POSITIVE_INFINITY;
        }
        MoleculeModifierAndScorer objFcn = new MoleculeModifierAndScorer(efunc, this.confSpace, RCTup);
        CCDMinimizer minim = new CCDMinimizer(objFcn, false);
        long preMinTime = System.currentTimeMillis() - startTime;
        DoubleMatrix1D bestDOFVals = minim.minimize().dofValues;
        double E = objFcn.getValue(bestDOFVals);
        long sampTime = System.currentTimeMillis() - startTime;
        if (sampTime > 10000L) {
            System.out.println();
            System.out.println("Minimization took over 10 s (ms shown): " + sampTime);
            System.out.println("Time to get E Fcn: " + gotEFcnTime + " to start min: " + preMinTime);
            System.out.println("Sample: " + RCTup.stringListing());
            System.out.println("Energy: " + E);
            CCDMinimizer ccdMin = minim;
            System.out.println("GVCounts.  Estmin: " + ccdMin.GVCountEstmin + " Edge: " + ccdMin.GVCountEdge + " Bigger: " + ccdMin.GVCountBigger + " Smaller: " + ccdMin.GVCountSmaller);
            System.out.println();
        }
        return E;
    }

    public EPICEnergyFunction internalEnergyFunction(RCTuple tup, boolean includeMinE) {
        int numPosInTuple = tup.pos.size();
        ArrayList<EPoly> terms = new ArrayList<EPoly>();
        for (int indexInTuple = 0; indexInTuple < numPosInTuple; ++indexInTuple) {
            int RCNum;
            int posNum = tup.pos.get(indexInTuple);
            EPoly intraE = (EPoly)this.getOneBody(posNum, RCNum = tup.RCs.get(indexInTuple).intValue());
            if (intraE == null) {
                return null;
            }
            terms.add(intraE);
            for (int index2 = 0; index2 < indexInTuple; ++index2) {
                int rc2;
                int pos2 = tup.pos.get(index2);
                EPoly pairwiseE = (EPoly)this.getPairwise(posNum, RCNum, pos2, rc2 = tup.RCs.get(index2).intValue());
                if (pairwiseE == null) {
                    return null;
                }
                terms.add(pairwiseE);
                if (this.getHigherOrderTerms(posNum, RCNum, pos2, rc2) == null) continue;
                throw new UnsupportedOperationException("ERROR: Higher-order EPIC terms not yet supported in internalEnergyFunction");
            }
        }
        EPICEnergyFunction efunc = new EPICEnergyFunction(terms, includeMinE);
        return efunc;
    }

    public ConfSpace getConfSpace() {
        return this.confSpace;
    }
}

