/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.MultiStateConfSpace;
import edu.duke.cs.osprey.confspace.ParametricMolecule;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.EnergyFunctionGenerator;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.approximation.ApproximatedObjectiveFunction;
import edu.duke.cs.osprey.energy.approximation.ResidueInteractionsApproximator;
import edu.duke.cs.osprey.energy.forcefield.BigForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.GpuForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ResPairCache;
import edu.duke.cs.osprey.energy.forcefield.ResidueForcefieldEnergy;
import edu.duke.cs.osprey.gpu.BufferTools;
import edu.duke.cs.osprey.gpu.cuda.GpuStreamPool;
import edu.duke.cs.osprey.gpu.cuda.Gpus;
import edu.duke.cs.osprey.gpu.cuda.kernels.ResidueCudaCCDMinimizer;
import edu.duke.cs.osprey.gpu.cuda.kernels.ResidueForcefieldEnergyCuda;
import edu.duke.cs.osprey.gpu.opencl.GpuQueuePool;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.CudaCCDMinimizer;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.MoleculeObjectiveFunction;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.minimization.SimpleCCDMinimizer;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.AtomConnectivity;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residues;
import edu.duke.cs.osprey.tools.AutoCleanable;
import edu.duke.cs.osprey.tools.Factory;
import edu.duke.cs.osprey.tools.UseableBuilder;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class EnergyCalculator
implements AutoCleanable {
    public final Parallelism parallelism;
    public final TaskExecutor tasks;
    public final Type type;
    public final Type.Context context;
    public final ResPairCache resPairCache;
    public final boolean isMinimizing;
    public final Double infiniteWellEnergy;
    public final Double alwaysResolveClashesEnergy;
    private final Type.Context cpuContext;

    private EnergyCalculator(Parallelism parallelism, Type type, ResPairCache resPairCache, boolean isMinimizing, Double infiniteWellEnergy, Double alwaysResolveClashesEnergy) {
        this.parallelism = parallelism;
        this.tasks = parallelism.makeTaskExecutor();
        this.type = type;
        this.context = type.makeContext(parallelism, resPairCache);
        this.resPairCache = resPairCache;
        this.isMinimizing = isMinimizing;
        this.infiniteWellEnergy = infiniteWellEnergy;
        this.alwaysResolveClashesEnergy = alwaysResolveClashesEnergy;
        this.cpuContext = infiniteWellEnergy != null || alwaysResolveClashesEnergy != null ? Type.Cpu.makeContext(parallelism, resPairCache) : null;
    }

    private EnergyCalculator(EnergyCalculator parent, boolean isMinimizing) {
        this.parallelism = parent.parallelism;
        this.tasks = parent.tasks;
        this.type = parent.type;
        this.context = parent.context;
        this.resPairCache = parent.resPairCache;
        this.isMinimizing = isMinimizing;
        this.infiniteWellEnergy = parent.infiniteWellEnergy;
        this.alwaysResolveClashesEnergy = parent.alwaysResolveClashesEnergy;
        this.cpuContext = parent.cpuContext;
    }

    @Override
    public void clean() {
        this.context.cleanup();
        this.tasks.clean();
    }

    public EnergyCalculator local() {
        return new EnergyCalculator(this, this.parallelism.makeTaskExecutor());
    }

    private EnergyCalculator(EnergyCalculator parent, TaskExecutor tasks) {
        this.parallelism = parent.parallelism;
        this.tasks = tasks;
        this.type = parent.type;
        this.context = parent.context;
        this.resPairCache = parent.resPairCache;
        this.isMinimizing = parent.isMinimizing;
        this.infiniteWellEnergy = parent.infiniteWellEnergy;
        this.alwaysResolveClashesEnergy = parent.alwaysResolveClashesEnergy;
        this.cpuContext = parent.cpuContext;
    }

    public EnergiedParametricMolecule calcEnergy(ParametricMolecule pmol, ResidueInteractions inters) {
        return this.calcEnergy(pmol, inters, null);
    }

    public EnergiedParametricMolecule calcEnergy(ParametricMolecule pmol, ResidueInteractions inters, ResidueInteractionsApproximator approximator) {
        if (inters.size() <= 0) {
            return new EnergiedParametricMolecule(pmol, null, 0.0);
        }
        ResidueInteractions ffInters = inters;
        if (approximator != null) {
            ffInters = approximator.ffInters;
        }
        DoubleMatrix1D x = DoubleFactory1D.dense.make(pmol.dofs.size());
        if (!this.isMinimizing || pmol.dofBounds.size() <= 0) {
            if (approximator != null) {
                for (int d = 0; d < pmol.dofs.size(); ++d) {
                    x.set(d, pmol.dofs.get(d).getCurVal());
                }
            }
            try (EnergyFunction efunc = this.context.efuncs.make(ffInters, pmol.mol);){
                double energy = efunc.getEnergy();
                if (approximator != null) {
                    energy += approximator.approximator.getValue(x);
                }
                EnergiedParametricMolecule energiedParametricMolecule = new EnergiedParametricMolecule(pmol, inters, x, energy);
                return energiedParametricMolecule;
            }
        }
        pmol.dofBounds.getCenter(x);
        if (this.alwaysResolveClashesEnergy != null) {
            Minimizer.Result vdwResult = this.minimizeWithVdw(pmol, inters, x);
            if (vdwResult.energy >= this.alwaysResolveClashesEnergy) {
                return new EnergiedParametricMolecule(pmol, inters, vdwResult.dofValues, Double.POSITIVE_INFINITY);
            }
            x = vdwResult.dofValues;
        }
        try (EnergyFunction efunc = this.context.efuncs.make(ffInters, pmol.mol);){
            EnergiedParametricMolecule energiedParametricMolecule;
            block31: {
                Minimizer.Result result;
                Minimizer minimizer;
                block29: {
                    EnergiedParametricMolecule energiedParametricMolecule2;
                    block30: {
                        ObjectiveFunction f = new MoleculeObjectiveFunction(pmol, efunc);
                        if (approximator != null) {
                            f = new ApproximatedObjectiveFunction(f, approximator.approximator);
                        }
                        minimizer = this.context.minimizers.make(f);
                        try {
                            result = minimizer.minimizeFrom(x);
                            if (!this.isInfiniteWell(result.energy)) break block29;
                            Minimizer.Result vdwResult = this.minimizeWithVdw(pmol, ffInters, x);
                            result = minimizer.minimizeFrom(vdwResult.dofValues);
                            if (!this.isInfiniteWell(result.energy)) break block29;
                            energiedParametricMolecule2 = new EnergiedParametricMolecule(pmol, inters, result.dofValues, Double.POSITIVE_INFINITY);
                            if (minimizer == null) break block30;
                        }
                        catch (Throwable throwable) {
                            if (minimizer != null) {
                                try {
                                    minimizer.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        minimizer.close();
                    }
                    return energiedParametricMolecule2;
                }
                energiedParametricMolecule = new EnergiedParametricMolecule(pmol, inters, result.dofValues, result.energy);
                if (minimizer == null) break block31;
                minimizer.close();
            }
            return energiedParametricMolecule;
        }
    }

    private Minimizer.Result minimizeWithVdw(ParametricMolecule pmol, ResidueInteractions inters, DoubleMatrix1D x) {
        try (EnergyFunction efunc = this.cpuContext.efuncs.make(inters, pmol.mol);){
            Minimizer.Result result;
            block12: {
                ResidueForcefieldEnergy.Vdw vdwEfunc = new ResidueForcefieldEnergy.Vdw((ResidueForcefieldEnergy)efunc);
                Minimizer minimizer = this.cpuContext.minimizers.make(new MoleculeObjectiveFunction(pmol, vdwEfunc));
                try {
                    result = minimizer.minimizeFrom(x);
                    if (minimizer == null) break block12;
                }
                catch (Throwable throwable) {
                    if (minimizer != null) {
                        try {
                            minimizer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                minimizer.close();
            }
            return result;
        }
    }

    private boolean isInfiniteWell(double energy) {
        return this.infiniteWellEnergy != null && energy <= this.infiniteWellEnergy;
    }

    public EnergyFunction makeEnergyFunction(EnergiedParametricMolecule epmol) {
        return this.makeEnergyFunction(epmol.pmol, epmol.inters);
    }

    public EnergyFunction makeEnergyFunction(ParametricMolecule pmol, ResidueInteractions inters) {
        return this.context.efuncs.make(inters, pmol.mol);
    }

    public MoleculeObjectiveFunction makeEnergyObjFcn(ParametricMolecule pmol, ResidueInteractions inters) {
        return new MoleculeObjectiveFunction(pmol, this.makeEnergyFunction(pmol, inters));
    }

    public void calcEnergyAsync(ParametricMolecule pmol, ResidueInteractions inters, TaskExecutor.TaskListener<EnergiedParametricMolecule> listener) {
        this.tasks.submit(() -> this.calcEnergy(pmol, inters), listener);
    }

    public static enum Type {
        CpuOriginalCCD{

            @Override
            public boolean isSupported() {
                return true;
            }

            @Override
            public Context makeContext(final Parallelism parallelism, final ResPairCache resPairCache) {
                return new Context(this){
                    {
                        EnergyFunctionGenerator egen = new EnergyFunctionGenerator(resPairCache.ffparams);
                        this.numStreams = parallelism.numThreads;
                        this.efuncs = (interactions, mol) -> egen.interactionEnergy(new ForcefieldInteractions(interactions, mol));
                        this.minimizers = f -> new CCDMinimizer((ObjectiveFunction)f, false);
                    }
                };
            }
        }
        ,
        Cpu{

            @Override
            public boolean isSupported() {
                return true;
            }

            @Override
            public Context makeContext(final Parallelism parallelism, final ResPairCache resPairCache) {
                return new Context(this){
                    {
                        this.numStreams = parallelism.numThreads;
                        this.efuncs = (interactions, mol) -> new ResidueForcefieldEnergy(resPairCache, interactions, mol);
                        this.minimizers = f -> new SimpleCCDMinimizer((ObjectiveFunction)f);
                    }
                };
            }
        }
        ,
        Cuda{

            @Override
            public boolean isSupported() {
                return !Gpus.get().getGpus().isEmpty();
            }

            @Override
            public Context makeContext(final Parallelism parallelism, final ResPairCache resPairCache) {
                return new Context(this){
                    private GpuStreamPool pool;
                    {
                        this.pool = new GpuStreamPool(parallelism.numGpus, parallelism.numStreamsPerGpu);
                        this.numStreams = this.pool.getNumStreams();
                        this.efuncs = (interactions, mol) -> new GpuForcefieldEnergy(resPairCache2.ffparams, new ForcefieldInteractions(interactions, mol), this.pool);
                        this.minimizers = f -> new SimpleCCDMinimizer((ObjectiveFunction)f);
                        this.needsCleanup = true;
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                        this.needsCleanup = false;
                    }
                };
            }
        }
        ,
        ResidueCuda{

            @Override
            public boolean isSupported() {
                return !Gpus.get().getGpus().isEmpty();
            }

            @Override
            public Context makeContext(final Parallelism parallelism, final ResPairCache resPairCache) {
                return new Context(this){
                    private GpuStreamPool pool;
                    {
                        this.pool = new GpuStreamPool(parallelism.numGpus, parallelism.numStreamsPerGpu);
                        this.numStreams = this.pool.getNumStreams();
                        this.efuncs = (interactions, mol) -> new ResidueForcefieldEnergyCuda(this.pool, resPairCache, interactions, mol);
                        this.minimizers = f -> new SimpleCCDMinimizer((ObjectiveFunction)f);
                        this.needsCleanup = true;
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                        this.needsCleanup = false;
                    }
                };
            }
        }
        ,
        CudaCCD{

            @Override
            public boolean isSupported() {
                return Cuda.isSupported();
            }

            @Override
            public Context makeContext(final Parallelism parallelism, final ResPairCache resPairCache) {
                return new Context(this){
                    private GpuStreamPool pool;
                    {
                        this.pool = new GpuStreamPool(parallelism.numGpus, parallelism.numStreamsPerGpu);
                        this.numStreams = this.pool.getNumStreams();
                        this.efuncs = (interactions, mol) -> new BigForcefieldEnergy(resPairCache2.ffparams, new ForcefieldInteractions(interactions, mol), BufferTools.Type.Direct);
                        this.minimizers = mof -> new CudaCCDMinimizer(this.pool, (ObjectiveFunction)mof);
                        this.needsCleanup = true;
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                        this.needsCleanup = false;
                    }
                };
            }
        }
        ,
        ResidueCudaCCD{

            @Override
            public boolean isSupported() {
                return ResidueCuda.isSupported();
            }

            @Override
            public Context makeContext(final Parallelism parallelism, final ResPairCache resPairCache) {
                return new Context(this){
                    private GpuStreamPool pool;
                    {
                        this.pool = new GpuStreamPool(parallelism.numGpus, parallelism.numStreamsPerGpu);
                        this.numStreams = this.pool.getNumStreams();
                        this.efuncs = (interactions, mol) -> new ResidueForcefieldEnergy(resPairCache, interactions, mol);
                        this.minimizers = mof -> new ResidueCudaCCDMinimizer(this.pool, (ObjectiveFunction)mof);
                        this.needsCleanup = true;
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                        this.needsCleanup = false;
                    }
                };
            }
        }
        ,
        OpenCL{

            @Override
            public boolean isSupported() {
                return !edu.duke.cs.osprey.gpu.opencl.Gpus.get().getGpus().isEmpty();
            }

            @Override
            public Context makeContext(final Parallelism parallelism, final ResPairCache resPairCache) {
                return new Context(this){
                    private GpuQueuePool pool;
                    {
                        this.pool = new GpuQueuePool(parallelism.numGpus, parallelism.numStreamsPerGpu);
                        this.numStreams = this.pool.getNumQueues();
                        this.efuncs = (interactions, mol) -> new GpuForcefieldEnergy(resPairCache2.ffparams, new ForcefieldInteractions(interactions, mol), this.pool);
                        this.minimizers = mof -> new SimpleCCDMinimizer((ObjectiveFunction)mof);
                        this.needsCleanup = true;
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                        this.needsCleanup = false;
                    }
                };
            }
        };


        public abstract boolean isSupported();

        public abstract Context makeContext(Parallelism var1, ResPairCache var2);

        public static Type pickBest(SimpleConfSpace.DofTypes dofTypes) {
            if (ResidueCuda.isSupported()) {
                switch (dofTypes) {
                    case None: 
                    case OnlyDihedrals: {
                        return ResidueCudaCCD;
                    }
                    case Any: {
                        return ResidueCuda;
                    }
                }
            }
            return Cpu;
        }

        public static abstract class Context {
            public int numStreams;
            public EfuncFactory efuncs;
            public Factory<Minimizer, ObjectiveFunction> minimizers;
            protected boolean needsCleanup = false;

            public void cleanup() {
            }

            protected void finalize() throws Throwable {
                try {
                    if (this.needsCleanup) {
                        System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                        this.cleanup();
                    }
                }
                finally {
                    super.finalize();
                }
            }
        }

        public static interface EfuncFactory {
            public EnergyFunction make(ResidueInteractions var1, Molecule var2);
        }
    }

    public static class EnergiedParametricMolecule {
        public final ParametricMolecule pmol;
        public final ResidueInteractions inters;
        public final DoubleMatrix1D params;
        public final double energy;

        public EnergiedParametricMolecule(ParametricMolecule pmol, ResidueInteractions inters, double energy) {
            this(pmol, inters, null, energy);
        }

        public EnergiedParametricMolecule(ParametricMolecule pmol, ResidueInteractions inters, DoubleMatrix1D params, double energy) {
            this.pmol = pmol;
            this.inters = inters;
            this.params = params;
            this.energy = energy;
        }
    }

    public static class SharedBuilder {
        private EnergyCalculator parent;
        private boolean isMinimizing = true;

        public SharedBuilder(EnergyCalculator parent) {
            this.parent = parent;
        }

        public SharedBuilder setIsMinimizing(boolean val) {
            this.isMinimizing = val;
            return this;
        }

        public EnergyCalculator build() {
            return new EnergyCalculator(this, this.parent, this.isMinimizing){

                @Override
                public void clean() {
                }
            };
        }
    }

    public static class Builder
    implements UseableBuilder<EnergyCalculator> {
        private ForcefieldParams ffparams;
        private Parallelism parallelism = Parallelism.makeCpu(1);
        private Type type = null;
        private SimpleConfSpace.DofTypes dofTypes = SimpleConfSpace.DofTypes.Any;
        private AtomConnectivity.Builder atomConnectivityBuilder = new AtomConnectivity.Builder();
        private ResPairCache resPairCache;
        private boolean isMinimizing = true;
        private Double infiniteWellEnergy = null;
        private Double alwaysResolveClashesEnergy = null;

        public Builder(ForcefieldParams ffparams) {
            this.ffparams = ffparams;
        }

        @Deprecated
        public Builder(ResidueTemplateLibrary templateLib, ForcefieldParams ffparams) {
            this.ffparams = ffparams;
        }

        public Builder(SimpleConfSpace confSpace, ForcefieldParams ffparams) {
            this.ffparams = ffparams;
            this.dofTypes = confSpace.getDofTypes();
        }

        public Builder(List<SimpleConfSpace> confSpaces, ForcefieldParams ffparams) {
            this.ffparams = ffparams;
            this.dofTypes = SimpleConfSpace.DofTypes.combine(confSpaces.stream().map(confSpace -> confSpace.getDofTypes()).collect(Collectors.toList()));
        }

        public Builder(MultiStateConfSpace confSpace, ForcefieldParams ffparams) {
            this(confSpace.states.stream().map(state -> (SimpleConfSpace)state.confSpace).collect(Collectors.toList()), ffparams);
        }

        @Deprecated
        public Builder(Residues residues, ForcefieldParams ffparams) {
            this.ffparams = ffparams;
        }

        public Builder setParallelism(Parallelism val) {
            this.parallelism = val;
            return this;
        }

        public Builder setType(Type val) {
            this.type = val;
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public Builder setDofTypes(SimpleConfSpace.DofTypes val) {
            this.dofTypes = val;
            return this;
        }

        @Deprecated
        public Builder addTemplates(Consumer<AtomConnectivity.Builder> block) {
            block.accept(this.atomConnectivityBuilder);
            return this;
        }

        public Builder setResPairCache(ResPairCache val) {
            this.resPairCache = val;
            return this;
        }

        public Builder setIsMinimizing(boolean val) {
            this.isMinimizing = val;
            return this;
        }

        public Builder setInfiniteWellEnergy(Double val) {
            this.infiniteWellEnergy = val;
            return this;
        }

        public Builder setAlwaysResolveClashesEnergy(Double val) {
            this.alwaysResolveClashesEnergy = val;
            return this;
        }

        @Override
        public EnergyCalculator build() {
            if (this.type == null) {
                this.type = this.parallelism.numGpus > 0 ? Type.pickBest(this.dofTypes) : Type.Cpu;
            }
            if (this.resPairCache == null) {
                this.resPairCache = new ResPairCache(this.ffparams, this.atomConnectivityBuilder.build());
            }
            return new EnergyCalculator(this.parallelism, this.type, this.resPairCache, this.isMinimizing, this.infiniteWellEnergy, this.alwaysResolveClashesEnergy);
        }
    }
}

