/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.energy.PoissonBoltzmannEnergy;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.ScaledEnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.ResPairEnergy;
import edu.duke.cs.osprey.energy.forcefield.SingleResEnergy;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import java.util.ArrayList;
import java.util.List;

public class EnergyFunctionGenerator {
    public ForcefieldParams ffParams;

    public EnergyFunctionGenerator(ForcefieldParams fParams) {
        this.ffParams = fParams;
    }

    public EnergyFunction resPairEnergy(Residue res1, Residue res2) {
        return new ResPairEnergy(res1, res2, this.ffParams);
    }

    public EnergyFunction singleResEnergy(Residue res) {
        return new SingleResEnergy(res, this.ffParams);
    }

    public EnergyFunction intraAndShellEnergy(Residue res, List<Residue> shellResidues) {
        EnergyFunction intraE = this.singleResEnergy(res);
        MultiTermEnergyFunction intraAndShellE = new MultiTermEnergyFunction();
        intraAndShellE.addTerm(intraE);
        for (Residue shellRes : shellResidues) {
            EnergyFunction pairE = this.resPairEnergy(res, shellRes);
            intraAndShellE.addTerm(pairE);
        }
        return intraAndShellE;
    }

    public EnergyFunction intraAndDistributedShellEnergy(Residue res, List<Residue> shellResidues, int numPos, double singleWeight) {
        if (singleWeight == 0.0) {
            return new SingleResEnergy(res, this.ffParams);
        }
        MultiTermEnergyFunction efunc = new MultiTermEnergyFunction();
        efunc.addTerm(new SingleResEnergy(res, this.ffParams));
        for (Residue shellRes : shellResidues) {
            efunc.addTerm(this.scaleEfunc(new ResPairEnergy(res, shellRes, this.ffParams), singleWeight));
        }
        return efunc;
    }

    public EnergyFunction resPairAndDistributedShellEnergy(Residue res1, Residue res2, List<Residue> shellResidues, int numPos, double singleWeight) {
        if (singleWeight == 1.0) {
            return new ResPairEnergy(res1, res2, this.ffParams);
        }
        double pairWeight = (1.0 - singleWeight) / (double)(numPos - 1);
        MultiTermEnergyFunction efunc = new MultiTermEnergyFunction();
        efunc.addTerm(new ResPairEnergy(res1, res2, this.ffParams));
        for (Residue shellRes : shellResidues) {
            efunc.addTerm(this.scaleEfunc(new ResPairEnergy(res1, shellRes, this.ffParams), pairWeight));
            efunc.addTerm(this.scaleEfunc(new ResPairEnergy(res2, shellRes, this.ffParams), pairWeight));
        }
        return efunc;
    }

    private EnergyFunction scaleEfunc(EnergyFunction efunc, double scale) {
        if (scale == 1.0) {
            return efunc;
        }
        return new ScaledEnergyFunction(efunc, scale);
    }

    public EnergyFunction fullConfEnergy(ConfSpace cSpace, List<Residue> shellResidues) {
        return this.fullConfEnergy(cSpace, shellResidues, null);
    }

    public EnergyFunction fullConfEnergy(ConfSpace cSpace, List<Residue> shellResidues, Molecule mol) {
        List<Residue> flexibleResidues = new ArrayList<Residue>();
        for (PositionConfSpace pcs : cSpace.posFlex) {
            flexibleResidues.add(pcs.res);
        }
        flexibleResidues = this.matchToMolecule(flexibleResidues, mol);
        shellResidues = this.matchToMolecule(shellResidues, mol);
        MultiTermEnergyFunction fullEFunc = new MultiTermEnergyFunction();
        for (int flexResNum = 0; flexResNum < flexibleResidues.size(); ++flexResNum) {
            Residue flexRes = flexibleResidues.get(flexResNum);
            fullEFunc.addTerm(this.singleResEnergy(flexRes));
            for (int flexResNum2 = 0; flexResNum2 < flexResNum; ++flexResNum2) {
                Residue flexRes2 = flexibleResidues.get(flexResNum2);
                fullEFunc.addTerm(this.resPairEnergy(flexRes, flexRes2));
            }
        }
        for (Residue flexRes : flexibleResidues) {
            for (Residue shellRes : shellResidues) {
                fullEFunc.addTerm(this.resPairEnergy(flexRes, shellRes));
            }
        }
        if (this.ffParams.solvationForcefield == ForcefieldParams.SolvationForcefield.PoissonBoltzmann) {
            fullEFunc.addTermWithCoeff(new PoissonBoltzmannEnergy(cSpace.m), this.ffParams.solvScale);
        }
        return fullEFunc;
    }

    private List<Residue> matchToMolecule(List<Residue> residues, Molecule mol) {
        if (mol == null) {
            return residues;
        }
        ArrayList<Residue> matched = new ArrayList<Residue>(residues.size());
        for (Residue res : residues) {
            matched.add((Residue)mol.residues.get(res.indexInMolecule));
        }
        return matched;
    }

    public EnergyFunction fullMolecEnergy(Molecule molec) {
        MultiTermEnergyFunction fullEFunc = new MultiTermEnergyFunction();
        for (Residue res : molec.residues) {
            fullEFunc.addTerm(this.singleResEnergy(res));
        }
        for (int res1 = 0; res1 < molec.residues.size(); ++res1) {
            for (int res2 = 0; res2 < res1; ++res2) {
                fullEFunc.addTerm(this.resPairEnergy((Residue)molec.residues.get(res1), (Residue)molec.residues.get(res2)));
            }
        }
        return fullEFunc;
    }

    public EnergyFunction interactionEnergy(ForcefieldInteractions interactions) {
        MultiTermEnergyFunction efunc = new MultiTermEnergyFunction();
        for (ForcefieldInteractions.AtomGroup[] groups : interactions) {
            ForcefieldInteractions.ResidueAtomGroup group1;
            ForcefieldInteractions.ResidueAtomGroup group0 = (ForcefieldInteractions.ResidueAtomGroup)groups[0];
            if (group0 == (group1 = (ForcefieldInteractions.ResidueAtomGroup)groups[1])) {
                efunc.addTerm(this.singleResEnergy(group0.getResidue()));
                continue;
            }
            efunc.addTerm(this.resPairEnergy(group0.getResidue(), group1.getResidue()));
        }
        return efunc;
    }

    public EnergyFunction residueInteractionEnergy(Residues residues, ResidueInteractions interactions) {
        MultiTermEnergyFunction efunc = new MultiTermEnergyFunction();
        for (ResidueInteractions.Pair pair : interactions) {
            Residue res2;
            Residue res1 = residues.getOrThrow(pair.resNum1);
            EnergyFunction term = res1 == (res2 = residues.getOrThrow(pair.resNum2)) ? this.singleResEnergy(res1) : this.resPairEnergy(res1, res2);
            if (pair.weight != 1.0) {
                term = new ScaledEnergyFunction(term, pair.weight);
            }
            if (pair.offset != 0.0) {
                final EnergyFunction fterm = term;
                final double foffset = pair.offset;
                term = new EnergyFunction(){
                    private static final long serialVersionUID = 8343782653796072786L;

                    @Override
                    public double getEnergy() {
                        return fterm.getEnergy() + foffset;
                    }
                };
            }
            efunc.addTerm(term);
        }
        return efunc;
    }
}

