/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.parallelism.WorkCrew;
import edu.duke.cs.osprey.parallelism.Worker;
import java.util.ArrayList;

public class ParallelEnergyFunction
implements EnergyFunction {
    private static WorkCrew<EnergyWorker> crew = null;
    private static ParallelEnergyFunction efunc = null;
    private static final long serialVersionUID = -2789380428939629566L;
    private ArrayList<EnergyFunction> terms;
    private ArrayList<Double> coeffs;

    public static boolean isCrewStarted() {
        return crew != null;
    }

    public static void startCrew(int numThreads) {
        crew = new WorkCrew("Energy");
        for (int i = 0; i < numThreads; ++i) {
            new EnergyWorker(crew);
        }
        crew.start();
    }

    public static void stopCrew() {
        if (crew == null) {
            return;
        }
        crew.askToStop();
        crew = null;
    }

    public static void setEFunc(ParallelEnergyFunction val) {
        if (efunc == val) {
            return;
        }
        efunc = val;
        int numTerms = ParallelEnergyFunction.efunc.terms.size();
        int numWorkers = crew.getWorkers().size();
        int width = (numTerms + numWorkers - 1) / numWorkers;
        int startIndex = 0;
        int stopIndex = startIndex + width - 1;
        for (EnergyWorker worker : crew.getWorkers()) {
            worker.startIndex = startIndex;
            worker.stopIndex = stopIndex;
            startIndex += width;
            stopIndex = Math.min(stopIndex + width, numTerms - 1);
        }
    }

    public ParallelEnergyFunction(ArrayList<EnergyFunction> terms, ArrayList<Double> coeffs) {
        this.terms = terms;
        this.coeffs = coeffs;
    }

    public ArrayList<EnergyFunction> getTerms() {
        return this.terms;
    }

    public ArrayList<Double> getCoeffs() {
        return this.coeffs;
    }

    @Override
    public double getEnergy() {
        ParallelEnergyFunction.setEFunc(this);
        crew.sendWork();
        try {
            boolean finished = crew.waitForResults(10000);
            if (!finished) {
                System.err.println("WARNING: ParallelEnergyFunction is taking more than 10 seconds to evaluate. Maybe something is wrong?");
                finished = crew.waitForResults(10000000);
                if (!finished) {
                    throw new Error("Timed out waiting 10000 seconds for energy calculations to finish!\nEnergy calculation shouldn't take more than 10000 seconds, right?");
                }
            }
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
        double energy = 0.0;
        for (EnergyWorker worker : crew) {
            energy += worker.energy;
        }
        return energy;
    }

    private static class EnergyWorker
    extends Worker {
        private int startIndex;
        private int stopIndex;
        private double energy;

        public EnergyWorker(WorkCrew<EnergyWorker> crew) {
            super(crew);
        }

        @Override
        protected void workIt() {
            ArrayList<EnergyFunction> terms = ParallelEnergyFunction.efunc.terms;
            ArrayList<Double> coeffs = ParallelEnergyFunction.efunc.coeffs;
            int startIndex = this.startIndex;
            int stopIndex = this.stopIndex;
            double energy = 0.0;
            for (int i = startIndex; i <= stopIndex; ++i) {
                energy += terms.get(i).getEnergy() * coeffs.get(i);
            }
            this.energy = energy;
        }
    }
}

