/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import edu.duke.cs.osprey.energy.compiled.EnergyCalculator;
import java.io.DataInput;
import java.io.IOException;

public class AmberEnergyCalculator
implements EnergyCalculator {
    public static final EnergyCalculator.Type type = EnergyCalculator.Type.Amber;
    public final String id;
    public final int ffi;
    public Settings settings = null;

    public AmberEnergyCalculator(String id, int ffi) {
        this.id = id;
        this.ffi = ffi;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public EnergyCalculator.Type type() {
        return type;
    }

    @Override
    public int ffi() {
        return this.ffi;
    }

    @Override
    public void readSettings(DataInput in) throws IOException {
        this.settings = new Settings();
        this.settings.distanceDependentDielectric = in.readBoolean();
    }

    @Override
    public double calcEnergy(double r, double r2, double[] params) {
        double esQ = params[0];
        double vdwA = params[1];
        double vdwB = params[2];
        double es = this.settings.distanceDependentDielectric ? esQ / r2 : esQ / r;
        double r6 = r2 * r2 * r2;
        double r12 = r6 * r6;
        double vdw = vdwA / r12 - vdwB / r6;
        return es + vdw;
    }

    public static class Settings {
        boolean distanceDependentDielectric;
    }
}

